/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.optim;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.ObjectValue;

public class MultithreadedItemMappingIterator<F extends Item<?>, T extends Item<?>>
extends ItemMappingIterator<F, T> {
    private ExecutorService service;
    private BlockingQueue<Future<T>> resultQueue = new LinkedBlockingQueue<Future<T>>();

    public MultithreadedItemMappingIterator(SequenceIterator<F> base, ItemMappingFunction<F, T> action) throws XPathException {
        super(base, action);
        int maxThreads = this.getMaxThreads();
        this.service = this.makeExecutorService(maxThreads);
        int n = 0;
        while (++n < maxThreads * 3) {
            F item = base.next();
            if (item == null) {
                return;
            }
            this.mapOneItem(item);
        }
    }

    protected int getMaxThreads() {
        int maxThreads = Runtime.getRuntime().availableProcessors();
        return maxThreads > 0 ? maxThreads : 1;
    }

    protected ExecutorService makeExecutorService(int maxThreads) {
        return Executors.newFixedThreadPool(maxThreads);
    }

    /*
     * Exception decompiling
     */
    @Override
    public T next() throws XPathException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void close() {
        super.close();
        this.service.shutdown();
    }

    private void mapOneItem(F in) {
        Future<Item> future = this.service.submit(new CallableAction(this, this.getMappingFunction(), in));
        this.resultQueue.add(future);
    }

    private static class NullItem
    extends ObjectValue<Boolean> {
        public NullItem(Boolean success) {
            super(success);
        }
    }

    private static class CallableAction<F extends Item<?>, T extends Item<?>>
    implements Callable<Item> {
        private ItemMappingFunction<F, T> action;
        private F input;
        final /* synthetic */ MultithreadedItemMappingIterator this$0;

        public CallableAction(ItemMappingFunction<F, T> action, F input) {
            this.this$0 = var1_1;
            this.action = action;
            this.input = input;
        }

        @Override
        public Item call() throws XPathException {
            try {
                T out = this.action.mapItem(this.input);
                if (out == null) {
                    return new NullItem(true);
                }
                return out;
            }
            catch (XPathException e) {
                this.this$0.service.shutdown();
                throw e;
            }
        }
    }
}

