/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.config;

import com.saxonica.config.EnterpriseConfiguration;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.SchemaURIResolver;
import net.sf.saxon.lib.StandardEntityResolver;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.InputSource;

public class StandardSchemaResolver
implements SchemaURIResolver {
    private EnterpriseConfiguration config;
    private static final StreamSource[] EMPTY_SOURCE_ARRAY = new StreamSource[0];

    public StandardSchemaResolver() {
    }

    public StandardSchemaResolver(EnterpriseConfiguration config) {
        this.config = config;
    }

    @Override
    public void setConfiguration(Configuration config) {
        this.config = (EnterpriseConfiguration)config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public Source[] resolve(String targetNamespace, String baseURI, String[] locations) throws XPathException {
        if (this.config == null) {
            throw new NullPointerException("No configuration supplied to schema URI resolver");
        }
        if (this.config.isSchemaAvailable(targetNamespace) && !this.config.getConfigurationProperty(Feature.MULTIPLE_SCHEMA_IMPORTS).booleanValue()) {
            return EMPTY_SOURCE_ARRAY;
        }
        if ("http://www.w3.org/1999/xlink".equals(targetNamespace)) {
            InputSource is = StandardEntityResolver.fetch("w3c/xlink/xlink.xsd", this.config);
            return new Source[]{new SAXSource(is)};
        }
        if ("http://www.w3.org/2005/xpath-functions".equals(targetNamespace)) {
            InputSource is = StandardEntityResolver.fetch("xpath-functions.xsd", this.config);
            return new Source[]{new SAXSource(is)};
        }
        try {
            URIResolver uriResolver = this.config.getURIResolver();
            Source[] sources = new Source[locations.length];
            for (int i = 0; i < locations.length; ++i) {
                if (uriResolver != null) {
                    sources[i] = uriResolver.resolve(locations[i], baseURI);
                }
                if (sources[i] != null) continue;
                sources[i] = this.config.getSystemURIResolver().resolve(locations[i], baseURI);
            }
            return sources;
        }
        catch (TransformerException e) {
            throw XPathException.makeXPathException(e);
        }
    }
}

