/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.update;

import com.saxonica.ee.update.PendingUpdateAction;
import java.util.Set;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SimpleType;

public class InsertAttributeAction
extends PendingUpdateAction {
    private NodeInfo element;
    NodeName name;
    SimpleType typeCode;
    CharSequence value;
    int properties;

    public InsertAttributeAction(NodeInfo element, NodeName name, SimpleType typeCode, CharSequence value, int properties) {
        this.element = element;
        this.name = this.fixNodeName(name);
        this.typeCode = typeCode;
        this.value = value;
        this.properties = properties;
    }

    @Override
    public void apply(XPathContext context, Set affectedRootSet) throws XPathException {
        if (!(this.element instanceof MutableNodeInfo)) {
            throw new XPathException("Attempting to update a non-updateable element");
        }
        if (this.element.getAttributeValue(this.name.getURI(), this.name.getLocalPart()) != null) {
            throw new XPathException("Attempt to insert an attribute " + this.name.getDisplayName() + " that is already present on the target element", "XUDY0021");
        }
        affectedRootSet.add(this.element.getRoot());
        ((MutableNodeInfo)this.element).addAttribute(this.name, this.typeCode, this.value, this.properties);
        ((MutableNodeInfo)this.element).removeTypeAnnotation();
    }

    @Override
    public NodeInfo getTargetNode() {
        return this.element;
    }

    public NodeName getAttributeName() {
        return this.name;
    }

    public SimpleType getNewTypeCode() {
        return this.typeCode;
    }

    public CharSequence getNewStringValue() {
        return this.value;
    }

    @Override
    public int getApplyPhase() {
        return 2;
    }
}

