/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.UserSimpleType;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CallableDelegate;
import net.sf.saxon.expr.sort.CustomMap;
import net.sf.saxon.expr.sort.SimpleTypeIdentityComparison;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.StringValue;

public class EnumerationFacetSet
extends Facet {
    private final CustomMap<AtomicSequence, AtomicSequence> typedValues = new CustomMap(SimpleTypeIdentityComparison.getInstance());
    private final List<String> stringValues = new ArrayList<String>(20);

    @Override
    public String getName() {
        return "enumeration";
    }

    public List<String> getStringValues() {
        return this.stringValues;
    }

    public void addEnumerationValue(AtomicSequence val, String stringValue) {
        this.typedValues.put(val, val);
        this.stringValues.add(stringValue);
    }

    @Override
    public UnicodeString getValue() {
        UnicodeBuilder sb = new UnicodeBuilder();
        boolean first = true;
        for (String s : this.stringValues) {
            if (first) {
                first = false;
            } else {
                sb.appendLatin(", ");
            }
            sb.append(s);
        }
        return sb.toUnicodeString();
    }

    @Override
    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) {
    }

    @Override
    public boolean testAtomicValue(AtomicValue value) {
        return this.typedValues.containsKey(value);
    }

    @Override
    public boolean testListValue(AtomicSequence value) {
        return this.typedValues.containsKey(value);
    }

    public String getSharedInstance(String value) {
        for (String s : this.stringValues) {
            if (!s.equals(value)) continue;
            return s;
        }
        return value;
    }

    public AtomicSequence getSharedInstance(AtomicSequence value) {
        return this.typedValues.get(value);
    }

    @Override
    public void serializeFacet(SchemaModelSerializer serializer) throws XPathException {
        for (AtomicSequence v : this.typedValues.values()) {
            serializer.startElement("enumeration");
            boolean namespaceSensitive = false;
            for (AtomicValue av : v) {
                if (!(av instanceof QualifiedNameValue)) continue;
                String prefix = ((QualifiedNameValue)av).getPrefix();
                NamespaceUri uri = ((QualifiedNameValue)av).getNamespaceURI();
                serializer.declareNamespace(prefix, uri);
                namespaceSensitive = true;
            }
            serializer.emitAttribute("value", v.getUnicodeStringValue().toString());
            if (namespaceSensitive) {
                serializer.emitAttribute("namespaceSensitive", "true");
            }
            serializer.endElement();
        }
    }

    @Override
    public FunctionItem getFacetAsFunctionItem() {
        EnumerationFacetSet facet = this;
        CallableDelegate callable = new CallableDelegate((context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return new StringValue(this.getName());
                }
                case "implementation": {
                    return new ObjectValue<EnumerationFacetSet>(facet);
                }
                case "value": {
                    ArrayList<AtomicValue> list = new ArrayList<AtomicValue>();
                    for (String s : this.stringValues) {
                        list.add(new StringValue(s));
                    }
                    return new AtomicArray(list);
                }
                case "typed-value": {
                    ArrayList<GroundedValue> members = new ArrayList<GroundedValue>(this.typedValues.values());
                    return new SimpleArrayItem(members);
                }
            }
            return EmptySequence.getInstance();
        });
        return new CallableFunction(1, (Callable)callable, SpecificFunctionType.COMPONENT_FUNCTION_TYPE);
    }
}

