/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.StreamingPatternMaker;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.ApplyTemplatesFeed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.ApplyTemplatesAction;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ApplyTemplates;
import net.sf.saxon.expr.sort.SortExpression;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.XPathException;

public class ApplyTemplatesAdjunct
extends StreamingAdjunct
implements FeedMaker {
    @Override
    public void setExpression(Expression expression) {
        super.setExpression(expression);
    }

    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        ApplyTemplates exp;
        PostureAndSweep selectPS;
        if (reasons == null) {
            reasons = new ArrayList<String>();
        }
        if ((selectPS = Streamability.getStreamability((exp = (ApplyTemplates)this.getExpression()).getSelectExpression(), contextInfo, reasons)).getPosture() == Posture.GROUNDED) {
            return Streamability.generalStreamabilityRules(exp, exp.operands(), contextInfo, reasons);
        }
        if (exp.getSelectExpression() instanceof SortExpression) {
            reasons.add("Cannot use sorting in a streamable template");
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        Mode mode = exp.getMode();
        if (!exp.usesCurrentMode() && mode != null && !mode.isDeclaredStreamable()) {
            StructuredQName modeName = mode.getModeName();
            String name = modeName == null ? "(unnamed)" : modeName.getDisplayName();
            reasons.add("Cannot use non-streamable mode " + name + " in a streamable template");
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        if (selectPS.getPosture() == Posture.CLIMBING) {
            reasons.add("In a streaming apply-templates instruction, the select expression must not have climbing posture (for example, it cannot select ancestors)");
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        if (selectPS.getPosture() == Posture.CRAWLING) {
            reasons.add("In a streaming apply-templates instruction, the select expression must not have crawling posture (for example, it cannot select descendants)");
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        return Streamability.generalStreamabilityRules(exp, exp.operands(), contextInfo, reasons);
    }

    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        ApplyTemplates instruction = (ApplyTemplates)this.getExpression();
        Expression select = instruction.getSelectExpression();
        if (Streamability.getPosture(select) == Posture.GROUNDED) {
            return null;
        }
        Pattern selection = StreamingPatternMaker.makeStreamingPattern(select, this.getConfiguration(), null);
        StreamingAdjunct sa = StreamingAdjunct.makeStreamingAdjunct(this.getConfiguration(), select);
        if (selection != null || sa instanceof TransmissionAdjunct) {
            return (watchManager, out, context) -> {
                Component.M actualMode = instruction.getTargetMode(context);
                ApplyTemplatesAction action = new ApplyTemplatesAction(this.getExpression(), out, context);
                action.setMode(actualMode);
                action.setWatchManager(watchManager);
                if (selection != null) {
                    return new Trigger(selection, action, context);
                }
                return ((TransmissionAdjunct)sa).makeTransmissionFlow(watchManager, select, action, context);
            };
        }
        return null;
    }

    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
        if (Streamability.getSweep(((ApplyTemplates)this.getExpression()).getSelectExpression()) != Sweep.CONSUMING) {
            int i = 0;
            for (Operand o : this.getExpression().operands()) {
                if (Streamability.getSweep(o.getChildExpression()) == Sweep.CONSUMING) {
                    return this.getDefaultFeedMaker(i).makeItemFeed(watchManager, out, context);
                }
                ++i;
            }
        }
        return new ApplyTemplatesFeed((ApplyTemplates)this.getExpression(), out, context);
    }
}

