/*
 * Decompiled with CFR 0.152.
 */
package lemming.test.lemma;

import lemming.lemma.BackupLemmatizerTrainer;
import lemming.lemma.LemmaCandidateGenerator;
import lemming.lemma.LemmaCandidateGeneratorTrainer;
import lemming.lemma.LemmaInstance;
import lemming.lemma.SimpleLemmatizerTrainer;
import lemming.lemma.edit.EditTreeGeneratorTrainer;
import lemming.lemma.toutanova.ToutanovaTrainer;
import org.junit.Test;

public class GeneratorTest {
    private static final String INDEXES = "form-index=4,lemma-index=5,tag-index=2,";

    @Test
    public void testGeneratorTrainer() {
        String train = "trn_mod.tsv";
        String dev = "dev.tsv";
        LemmaCandidateGeneratorTrainer trainer = new EditTreeGeneratorTrainer();
        this.testGeneratorTrainer(trainer, train, dev);
        trainer = new SimpleLemmatizerTrainer();
        this.testGeneratorTrainer(trainer, train, dev);
        trainer = new BackupLemmatizerTrainer();
        BackupLemmatizerTrainer.BackupLemmatizerTrainerOptions options = (BackupLemmatizerTrainer.BackupLemmatizerTrainerOptions)trainer.getOptions();
        options.setOption("lemmatizer-trainer", SimpleLemmatizerTrainer.class.getName());
        options.setOption("backup-trainer", ToutanovaTrainer.class.getName());
        this.testGeneratorTrainer(trainer, train, dev);
    }

    public void testGeneratorTrainer(LemmaCandidateGeneratorTrainer trainer, String trainfile, String testfile) {
        LemmaCandidateGenerator generator = trainer.train(LemmaInstance.getInstances(this.getResourceFile(trainfile)), null);
        this.testGenerator(generator, testfile);
    }

    private void testGenerator(LemmaCandidateGenerator generator, String testfile) {
    }

    protected String getResourceFile(String name) {
        return INDEXES + String.format("res:///%s/%s", "marmot/test/lemma", name);
    }
}

