/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import opennlp.tools.sentdetect.SentenceDetector;
import opennlp.tools.sentdetect.SentenceDetectorEvaluationMonitor;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.Span;
import opennlp.tools.util.eval.Evaluator;
import opennlp.tools.util.eval.FMeasure;

public class SentenceDetectorEvaluator
extends Evaluator<SentenceSample> {
    private final FMeasure fmeasure = new FMeasure();
    private final SentenceDetector sentenceDetector;

    public SentenceDetectorEvaluator(SentenceDetector sentenceDetector, SentenceDetectorEvaluationMonitor ... listeners) {
        super(listeners);
        this.sentenceDetector = sentenceDetector;
    }

    private Span[] trimSpans(String document, Span[] spans) {
        Span[] trimedSpans = new Span[spans.length];
        for (int i = 0; i < spans.length; ++i) {
            trimedSpans[i] = spans[i].trim(document);
        }
        return trimedSpans;
    }

    @Override
    protected SentenceSample processSample(SentenceSample sample2) {
        Object[] predictions = this.trimSpans(sample2.getDocument(), this.sentenceDetector.sentPosDetect(sample2.getDocument()));
        Object[] references = this.trimSpans(sample2.getDocument(), sample2.getSentences());
        this.fmeasure.updateScores(references, predictions);
        return new SentenceSample(sample2.getDocument(), (Span[])predictions);
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }
}

