/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.plkexport;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.ids_mannheim.korap.plkexport.Exporter;
import de.ids_mannheim.korap.plkexport.Match;
import de.ids_mannheim.korap.plkexport.MatchAggregator;
import de.ids_mannheim.korap.plkexport.Snippet;
import java.io.IOException;
import java.io.Writer;

public class CsvExporter
extends MatchAggregator
implements Exporter {
    private static final ObjectMapper mapper = new ObjectMapper();

    @Override
    public String getMimeType() {
        return "text/csv";
    }

    @Override
    public String getSuffix() {
        return "csv";
    }

    @Override
    public void writeHeader(Writer w) throws IOException {
        this.addRecord(w, new String[]{"HasMoreLeft", "leftContext", "Match", "rightContext", "HasMoreRight", "isCutted", "textSigle", "author", "pubDate", "title"});
    }

    @Override
    public void addMatch(JsonNode n, Writer w) throws IOException {
        Match m = mapper.treeToValue((TreeNode)n, Match.class);
        Snippet s = m.getSnippet();
        String left = s.getLeft();
        String mark = s.getMark();
        String right = s.getRight();
        if (left != null) {
            left = left.trim();
        }
        if (mark != null) {
            mark = mark.trim();
        }
        if (right != null) {
            right = right.trim();
        }
        this.addRecord(w, new String[]{s.hasMoreLeft() ? "..." : "", left, mark, right, s.hasMoreRight() ? "..." : "", s.isCutted() ? "!" : "", m.getTextSigle(), m.getAuthor(), m.getPubDate(), m.getTitle()});
    }

    private void addRecord(Writer w, String[] ss) throws IOException {
        this.addCell(w, ss[0]);
        for (int i = 1; i < 10; ++i) {
            w.append(',');
            this.addCell(w, ss[i]);
        }
        w.append("\n");
    }

    private void addCell(Writer w, String s) throws IOException {
        if (s == null) {
            return;
        }
        if (s.startsWith("=") || s.startsWith("-") || s.startsWith("\"") || s.startsWith("+") || s.startsWith("@") || s.contains(",") || s.contains("\"") || s.contains("\n") || s.contains(" ") || s.contains("\t") || s.contains(";")) {
            w.append('\"');
            if (s.startsWith("=") || s.startsWith("-") || s.startsWith("\"") || s.startsWith("+") || s.startsWith("@")) {
                w.append(" ");
            }
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\"') {
                    w.append('\"').append('\"');
                    continue;
                }
                if (c == '\t') {
                    w.append(' ');
                    continue;
                }
                w.append(c);
            }
            w.append('\"');
        } else {
            w.append(s);
        }
    }
}

