/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.plkexport;

import de.ids_mannheim.korap.plkexport.CsvExporter;
import de.ids_mannheim.korap.plkexport.ExWSConf;
import de.ids_mannheim.korap.plkexport.Exporter;
import de.ids_mannheim.korap.plkexport.JsonExporter;
import de.ids_mannheim.korap.plkexport.RtfExporter;
import de.ids_mannheim.korap.plkexport.Util;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.FilenameUtils;
import org.glassfish.jersey.media.sse.EventOutput;
import org.glassfish.jersey.media.sse.OutboundEvent;
import org.glassfish.jersey.media.sse.SseFeature;
import org.glassfish.jersey.server.ContainerRequest;
import org.tinylog.Logger;

@Path(value="/")
public class Service {
    private Properties prop = ExWSConf.properties(null);
    private final ClassLoader cl = Thread.currentThread().getContextClassLoader();
    InputStream is = this.cl.getResourceAsStream("assets/export.js");
    private final String exportJsStr = Util.streamToString(this.is);
    Configuration cfg = new Configuration(Configuration.VERSION_2_3_32);
    private static final String octets = "(?:25[0-5]|2[0-4][0-9]|[0-1]?[0-9]{1,2})";
    private static final String ipre = "(?:25[0-5]|2[0-4][0-9]|[0-1]?[0-9]{1,2})\\.(?:25[0-5]|2[0-4][0-9]|[0-1]?[0-9]{1,2})\\.(?:25[0-5]|2[0-4][0-9]|[0-1]?[0-9]{1,2})\\.(?:25[0-5]|2[0-4][0-9]|[0-1]?[0-9]{1,2})";
    private static Pattern authrep = Pattern.compile("\"auth\":\"([^\"]+?)\"");
    private static final Base64.Decoder b64Dec = Base64.getDecoder();
    @Context
    private HttpServletRequest servletReq;
    @Context
    private ContainerRequest req;

    public Service() {
        this.cfg.setClassForTemplateLoading(Service.class, "/assets/templates");
        this.cfg.setDefaultEncoding("UTF-8");
    }

    private Exporter export(String fname, String format, String q, String cq, String ql, String cutoffStr, int hitc, EventOutput eventOutput) throws WebApplicationException {
        String resp;
        Invocation.Builder reqBuilder;
        WebTarget resource;
        String[][] params = new String[][]{{"format", format}, {"q", q}, {"ql", ql}};
        for (int i = 0; i < params.length; ++i) {
            if (params[i][1] != null && !params[i][1].trim().isEmpty()) continue;
            throw new WebApplicationException(this.responseForm(Response.Status.BAD_REQUEST, "Parameter \"" + params[i][0] + "\" is missing or empty"));
        }
        boolean cutoff = false;
        if (cutoffStr != null && (cutoffStr.equals("true") || cutoffStr.equals("1"))) {
            cutoff = true;
        }
        String scheme = this.prop.getProperty("api.scheme", "https");
        String port = this.prop.getProperty("api.port", "8089");
        String host = this.prop.getProperty("api.host", "localhost");
        String path = this.prop.getProperty("api.path", "");
        String source = this.prop.getProperty("api.source");
        int pageSize = Integer.parseInt(this.prop.getProperty("conf.page_size", "5"));
        int maxResults = Integer.parseInt(this.prop.getProperty("conf.max_exp_limit", "10000"));
        if (hitc > 0 && hitc < maxResults) {
            maxResults = hitc;
        }
        if (maxResults < pageSize) {
            pageSize = maxResults;
        }
        Object builder = null;
        Client client = ClientBuilder.newClient();
        UriBuilder uri = UriBuilder.fromPath("/api/v1.0/search").host(host).port(Integer.parseInt(port)).scheme(scheme).queryParam("q", q).queryParam("context", "40-t,40-t").queryParam("ql", ql).queryParam("count", pageSize);
        if (cq != null && cq.length() > 0) {
            uri = uri.queryParam("cq", cq);
        }
        if (path != "") {
            uri = uri.path(path);
        }
        String xff = "";
        String auth = "";
        if (this.servletReq != null) {
            xff = Service.getClientIP(this.servletReq.getHeader("X-Forwarded-For"));
            if (xff == "") {
                xff = this.servletReq.getRemoteAddr();
            }
            auth = this.authFromCookie(this.servletReq);
        }
        try {
            resource = client.target(uri.build(new Object[0]));
            reqBuilder = resource.request("application/json");
            resp = this.authBuilder(reqBuilder, xff, auth).get(String.class);
        }
        catch (Exception e) {
            throw new WebApplicationException(this.responseForm(Response.Status.BAD_GATEWAY, "Unable to reach Backend"));
        }
        Exporter exp = this.getExporter(format);
        exp.setMaxResults(maxResults);
        exp.setQueryString(q);
        exp.setCorpusQueryString(cq);
        if (source != null) {
            exp.setSource(source);
        } else {
            exp.setSource(host, path);
        }
        if (fname != null) {
            exp.setFileName(fname);
        }
        if (eventOutput != null) {
            exp.setSse(eventOutput);
            exp.forceFile();
        }
        try {
            exp.init(resp);
        }
        catch (Exception e) {
            Logger.error(e);
            String err = e.getMessage();
            if (err == null) {
                err = "Unable to initialize export";
            }
            throw new WebApplicationException(this.responseForm(Response.Status.INTERNAL_SERVER_ERROR, err));
        }
        int fetchCount = exp.getTotalResults();
        if (exp.hasTimeExceeded() || fetchCount > maxResults) {
            fetchCount = maxResults;
        }
        exp.setMaxResults(fetchCount);
        if (cutoff || fetchCount <= pageSize) {
            try {
                exp.finish();
            }
            catch (Exception e) {
                Logger.error(e);
                String err = e.getMessage();
                if (err == null) {
                    err = "Unable to finish export";
                }
                throw new WebApplicationException(this.responseForm(Response.Status.INTERNAL_SERVER_ERROR, err));
            }
            return exp;
        }
        uri.queryParam("cutoff", "true");
        uri.queryParam("offset", "{offset}");
        try {
            for (int i = pageSize; i <= fetchCount && exp.appendMatches(resp = this.authBuilder(reqBuilder = (resource = client.target(uri.build(i))).request("application/json"), xff, auth).get(String.class)); i += pageSize) {
            }
            exp.finish();
        }
        catch (Exception e) {
            Logger.error(e);
            String err = e.getMessage();
            if (err == null) {
                err = "Unable to iterate through results";
            }
            throw new WebApplicationException(this.responseForm(Response.Status.INTERNAL_SERVER_ERROR, err));
        }
        return exp;
    }

    @POST
    @Path(value="export")
    @Produces(value={"application/octet-stream"})
    public Response staticExport(@FormParam(value="fname") String fname, @FormParam(value="format") String format, @FormParam(value="q") String q, @FormParam(value="cq") String cq, @FormParam(value="ql") String ql, @FormParam(value="cutoff") String cutoffStr, @FormParam(value="hitc") int hitc) throws IOException {
        Exporter exp = this.export(fname, format, q, cq, ql, cutoffStr, hitc, null);
        return exp.serve().build();
    }

    @GET
    @Path(value="export")
    @Produces(value={"text/event-stream"})
    @Consumes(value={"text/event-stream"})
    public Response progressExport(final @QueryParam(value="fname") String fname, final @QueryParam(value="format") String format, final @QueryParam(value="q") String q, final @QueryParam(value="cq") String cq, final @QueryParam(value="ql") String ql, final @QueryParam(value="cutoff") String cutoffStr, final @QueryParam(value="hitc") int hitc) throws InterruptedException {
        final EventOutput eventOutput = new EventOutput();
        if (eventOutput.isClosed()) {
            return Response.ok("EventSource closed").build();
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                OutboundEvent.Builder eventBuilder = new OutboundEvent.Builder();
                try {
                    eventBuilder.name("Process");
                    eventBuilder.data("init");
                    eventOutput.write(eventBuilder.build());
                    Exporter exp = Service.this.export(fname, format, q, cq, ql, cutoffStr, hitc, eventOutput);
                    if (eventOutput.isClosed()) {
                        return;
                    }
                    eventBuilder.name("Relocate");
                    eventBuilder.data(exp.getExportID() + ";" + exp.getFileName());
                    eventOutput.write(eventBuilder.build());
                }
                catch (Exception e) {
                    block23: {
                        try {
                            if (!eventOutput.isClosed()) break block23;
                            return;
                        }
                        catch (IOException ioe) {
                            Logger.error(ioe);
                            throw new RuntimeException("Error when writing event output.", ioe);
                        }
                    }
                    eventBuilder.name("Error");
                    eventBuilder.data(e.getMessage());
                    eventOutput.write(eventBuilder.build());
                }
                finally {
                    try {
                        if (eventOutput.isClosed()) {
                            return;
                        }
                        eventBuilder.name("Process");
                        eventBuilder.data("done");
                        eventOutput.write(eventBuilder.build());
                        eventOutput.close();
                    }
                    catch (IOException ioClose) {
                        Logger.error(ioClose);
                        throw new RuntimeException("Error when closing the event output.", ioClose);
                    }
                }
            }
        }).start();
        String origin = this.prop.getProperty("server.origin", "*");
        if (this.servletReq != null) {
            origin = this.servletReq.getHeader("Origin");
        }
        return Response.ok((Object)eventOutput, SseFeature.SERVER_SENT_EVENTS_TYPE).header("Access-Control-Allow-Origin", origin).header("Access-Control-Allow-Credentials", "true").header("Vary", "Origin").build();
    }

    @GET
    @Path(value="export/{file}")
    @Produces(value={"application/octet-stream"})
    public Response fileExport(@PathParam(value="file") String fileStr, @QueryParam(value="fname") String fname) {
        String format = FilenameUtils.getExtension(fileStr);
        Exporter exp = this.getExporter(format);
        if (fname != null) {
            exp.setFileName(fname);
        }
        exp.setFile(fileStr);
        return exp.serve().build();
    }

    @GET
    @Path(value="export")
    @Produces(value={"text/html"})
    public Response exportHTML() {
        return this.responseForm();
    }

    @GET
    @Path(value="export.js")
    @Produces(value={"application/javascript"})
    public Response exportJavascript() {
        return Response.ok((Object)this.exportJsStr, "application/javascript").build();
    }

    private Exporter getExporter(String format) {
        if (format.equals("json")) {
            return new JsonExporter();
        }
        if (format.equals("csv")) {
            return new CsvExporter();
        }
        return new RtfExporter();
    }

    private Invocation.Builder authBuilder(Invocation.Builder reqBuilder, String xff, String auth) {
        if (xff != "") {
            reqBuilder = reqBuilder.header("X-Forwarded-For", xff);
        }
        if (auth != "") {
            reqBuilder = reqBuilder.header("Authorization", auth);
        }
        return reqBuilder;
    }

    private String authFromCookie(HttpServletRequest r) {
        Cookie[] cookies = r.getCookies();
        if (cookies == null) {
            return "";
        }
        String cookieName = this.prop.getProperty("cookie.name", "");
        for (int i = 0; i < cookies.length; ++i) {
            Matcher m;
            String payload;
            if (cookieName != "" ? !cookies[i].getName().equals(cookieName) : !cookies[i].getName().equals("kalamar")) continue;
            String b64 = cookies[i].getValue();
            String[] b64Parts = b64.split("--", 2);
            if (b64Parts.length != 2 || (payload = new String(b64Dec.decode(b64Parts[0]))) == "" || !(m = authrep.matcher(payload)).find()) continue;
            return m.group(1);
        }
        return "";
    }

    private Response responseForm() {
        return this.responseForm(null, null);
    }

    private Response responseForm(Response.Status code, String msg) {
        StringWriter out = new StringWriter();
        HashMap<String, Object> templateData = new HashMap<String, Object>();
        String scheme = this.prop.getProperty("asset.scheme", "https");
        String port = this.prop.getProperty("asset.port", "");
        String host = this.prop.getProperty("asset.host", "korap.ids-mannheim.de");
        String path = this.prop.getProperty("asset.path", "");
        String defaultHitc = this.prop.getProperty("conf.default_hitc", "100");
        int maxHitc = Integer.parseInt(this.prop.getProperty("conf.max_exp_limit", "10000"));
        UriBuilder uri = UriBuilder.fromPath("").host(host).scheme(scheme);
        if (path != "") {
            uri = uri.path(path);
        }
        if (port != "") {
            uri = uri.port(Integer.parseInt(port));
        }
        templateData.put("assetPath", uri.build(new Object[0]));
        templateData.put("defaultHitc", defaultHitc);
        templateData.put("maxHitc", maxHitc);
        if (code != null) {
            templateData.put("code", code.getStatusCode());
            templateData.put("msg", msg);
        }
        try {
            templateData.put("dict", this.getDictionary());
        }
        catch (Exception e) {
            Logger.error(e);
            return Response.ok(new String("Dictionary not found")).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        try {
            Template template = this.cfg.getTemplate("export.ftl");
            template.setLocale(this.getPreferredSupportedLocale());
            template.process(templateData, out);
        }
        catch (Exception e) {
            Logger.error(e);
            return Response.ok(new String("Template not found")).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        Response.ResponseBuilder resp = Response.ok((Object)out.toString(), "text/html");
        if (code != null) {
            resp = resp.status(code);
        }
        return resp.build();
    }

    protected static String getClientIP(String xff) {
        if (xff == null) {
            return "";
        }
        String[] ips = xff.split("\\s*,\\s*");
        for (int i = ips.length - 1; i >= 0; --i) {
            if (!ips[i].matches(ipre)) continue;
            return ips[i];
        }
        return "";
    }

    private ResourceBundle getDictionary() throws IOException {
        return ResourceBundle.getBundle("locales/export", this.getPreferredSupportedLocale());
    }

    private Locale getPreferredSupportedLocale() throws IOException {
        Locale fallback = new Locale("en");
        if (this.req != null) {
            for (Locale l : this.req.getAcceptableLanguages()) {
                switch (l.getLanguage()) {
                    case "de": {
                        return l;
                    }
                    case "en": {
                        return l;
                    }
                }
            }
        }
        return fallback;
    }
}

