/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.surefire.CommonReflector;
import org.apache.maven.plugin.surefire.StartupReportConfiguration;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.surefire.api.suite.RunResult;
import org.apache.maven.surefire.api.testset.TestSetFailedException;
import org.apache.maven.surefire.api.util.DefaultScanResult;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.ProviderFactory;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireExecutionException;

public class InPluginVMSurefireStarter {
    private final StartupConfiguration startupConfig;
    private final StartupReportConfiguration startupReportConfig;
    private final ProviderConfiguration providerConfig;
    private final ConsoleLogger consoleLogger;

    public InPluginVMSurefireStarter(@Nonnull StartupConfiguration startupConfig, @Nonnull ProviderConfiguration providerConfig, @Nonnull StartupReportConfiguration startupReportConfig, @Nonnull ConsoleLogger consoleLogger) {
        this.startupConfig = startupConfig;
        this.startupReportConfig = startupReportConfig;
        this.providerConfig = providerConfig;
        this.consoleLogger = consoleLogger;
    }

    public RunResult runSuitesInProcess(@Nonnull DefaultScanResult scanResult) throws SurefireExecutionException, TestSetFailedException {
        Map<String, String> providerProperties = this.providerConfig.getProviderProperties();
        scanResult.writeTo(providerProperties);
        this.startupConfig.writeSurefireTestClasspathProperty();
        ClassLoader testClassLoader = this.startupConfig.getClasspathConfiguration().toRealPath(ClasspathConfiguration.class).createMergedClassLoader();
        CommonReflector surefireReflector = new CommonReflector(testClassLoader);
        Object factory = surefireReflector.createReportingReporterFactory(this.startupReportConfig, this.consoleLogger);
        try {
            return ProviderFactory.invokeProvider(null, testClassLoader, factory, this.providerConfig, false, this.startupConfig, true);
        }
        catch (InvocationTargetException e) {
            throw new SurefireExecutionException("Exception in provider", e.getTargetException());
        }
    }
}

