/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.surefire.AbstractSurefireMojo;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.SurefireReportParameters;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.surefire.api.suite.RunResult;
import org.apache.maven.surefire.extensions.ForkNodeFactory;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class SurefirePlugin
extends AbstractSurefireMojo
implements SurefireReportParameters {
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classesDirectory;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false")
    private boolean testFailureIgnore;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports")
    private File reportsDirectory;
    @Parameter(property="test")
    private String test;
    @Parameter(property="surefire.printSummary", defaultValue="true")
    private boolean printSummary;
    @Parameter(property="surefire.reportFormat", defaultValue="brief")
    private String reportFormat;
    @Parameter(property="surefire.useFile", defaultValue="true")
    private boolean useFile;
    @Parameter(property="surefire.failIfNoSpecifiedTests")
    private Boolean failIfNoSpecifiedTests;
    @Parameter(property="maven.surefire.debug")
    private String debugForkedProcess;
    @Parameter(property="surefire.timeout")
    private int forkedProcessTimeoutInSeconds;
    @Parameter(property="surefire.exitTimeout", defaultValue="30")
    private int forkedProcessExitTimeoutInSeconds;
    @Parameter(property="surefire.parallel.timeout")
    private double parallelTestsTimeoutInSeconds;
    @Parameter(property="surefire.parallel.forcedTimeout")
    private double parallelTestsTimeoutForcedInSeconds;
    @Parameter
    private List<String> includes;
    @Parameter(property="surefire.useSystemClassLoader", defaultValue="true")
    private boolean useSystemClassLoader;
    @Parameter(property="surefire.useManifestOnlyJar", defaultValue="true")
    private boolean useManifestOnlyJar;
    @Parameter(property="surefire.encoding", defaultValue="${project.reporting.outputEncoding}")
    private String encoding;
    @Parameter(property="surefire.rerunFailingTestsCount", defaultValue="0")
    private int rerunFailingTestsCount;
    @Parameter(property="surefire.suiteXmlFiles")
    private File[] suiteXmlFiles;
    @Parameter(property="surefire.runOrder", defaultValue="filesystem")
    private String runOrder;
    @Parameter(property="surefire.includesFile")
    private File includesFile;
    @Parameter(property="surefire.excludesFile")
    private File excludesFile;
    @Parameter(property="surefire.skipAfterFailureCount", defaultValue="0")
    private int skipAfterFailureCount;
    @Parameter(property="surefire.shutdown", defaultValue="exit")
    private String shutdown;
    @Parameter(property="surefire.useModulePath", defaultValue="true")
    private boolean useModulePath;
    @Parameter(property="surefire.forkNode")
    private ForkNodeFactory forkNode;
    @Parameter(property="surefire.excludedEnvironmentVariables")
    private String[] excludedEnvironmentVariables;
    @Parameter(property="surefire.enableProcessChecker")
    private String enableProcessChecker;
    @Parameter(property="surefire.systemPropertiesFile")
    private File systemPropertiesFile;

    @Override
    protected int getRerunFailingTestsCount() {
        return this.rerunFailingTestsCount;
    }

    @Override
    protected void handleSummary(RunResult summary, Exception firstForkException) throws MojoExecutionException, MojoFailureException {
        SurefireHelper.reportExecution(this, summary, this.getConsoleLogger(), firstForkException);
    }

    @Override
    protected boolean isSkipExecution() {
        return this.isSkip() || this.isSkipTests() || this.isSkipExec();
    }

    @Override
    protected String getPluginName() {
        return "surefire";
    }

    @Override
    protected String[] getDefaultIncludes() {
        return new String[]{"**/Test*.java", "**/*Test.java", "**/*Tests.java", "**/*TestCase.java"};
    }

    @Override
    protected String getReportSchemaLocation() {
        return "https://maven.apache.org/surefire/maven-surefire-plugin/xsd/surefire-test-report-3.0.xsd";
    }

    @Override
    public File getSystemPropertiesFile() {
        return this.systemPropertiesFile;
    }

    @Override
    public void setSystemPropertiesFile(File systemPropertiesFile) {
        this.systemPropertiesFile = systemPropertiesFile;
    }

    @Override
    public boolean isSkipTests() {
        return this.skipTests;
    }

    @Override
    public void setSkipTests(boolean skipTests) {
        this.skipTests = skipTests;
    }

    @Override
    public boolean isSkipExec() {
        return this.skipExec;
    }

    @Override
    public void setSkipExec(boolean skipExec) {
        this.skipExec = skipExec;
    }

    @Override
    public boolean isSkip() {
        return this.skip;
    }

    @Override
    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    @Override
    public boolean isTestFailureIgnore() {
        return this.testFailureIgnore;
    }

    @Override
    public void setTestFailureIgnore(boolean testFailureIgnore) {
        this.testFailureIgnore = testFailureIgnore;
    }

    @Override
    public File getBasedir() {
        return this.basedir;
    }

    @Override
    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    @Override
    public File getTestClassesDirectory() {
        return this.testClassesDirectory;
    }

    @Override
    public void setTestClassesDirectory(File testClassesDirectory) {
        this.testClassesDirectory = testClassesDirectory;
    }

    @Override
    public File getMainBuildPath() {
        return this.classesDirectory;
    }

    @Override
    public void setMainBuildPath(File mainBuildPath) {
        this.classesDirectory = mainBuildPath;
    }

    @Override
    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    @Override
    public void setReportsDirectory(File reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    @Override
    public String getTest() {
        return this.test;
    }

    @Override
    public boolean isUseSystemClassLoader() {
        return this.useSystemClassLoader;
    }

    @Override
    public void setUseSystemClassLoader(boolean useSystemClassLoader) {
        this.useSystemClassLoader = useSystemClassLoader;
    }

    @Override
    public boolean isUseManifestOnlyJar() {
        return this.useManifestOnlyJar;
    }

    @Override
    public void setUseManifestOnlyJar(boolean useManifestOnlyJar) {
        this.useManifestOnlyJar = useManifestOnlyJar;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public Boolean getFailIfNoSpecifiedTests() {
        return this.failIfNoSpecifiedTests;
    }

    @Override
    public void setFailIfNoSpecifiedTests(boolean failIfNoSpecifiedTests) {
        this.failIfNoSpecifiedTests = failIfNoSpecifiedTests;
    }

    @Override
    public int getSkipAfterFailureCount() {
        return this.skipAfterFailureCount;
    }

    @Override
    public String getShutdown() {
        return this.shutdown;
    }

    @Override
    public boolean isPrintSummary() {
        return this.printSummary;
    }

    @Override
    public void setPrintSummary(boolean printSummary) {
        this.printSummary = printSummary;
    }

    @Override
    public String getReportFormat() {
        return this.reportFormat;
    }

    @Override
    public void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    @Override
    public boolean isUseFile() {
        return this.useFile;
    }

    @Override
    public void setUseFile(boolean useFile) {
        this.useFile = useFile;
    }

    @Override
    public String getDebugForkedProcess() {
        return this.debugForkedProcess;
    }

    @Override
    public void setDebugForkedProcess(String debugForkedProcess) {
        this.debugForkedProcess = debugForkedProcess;
    }

    @Override
    public int getForkedProcessTimeoutInSeconds() {
        return this.forkedProcessTimeoutInSeconds;
    }

    @Override
    public void setForkedProcessTimeoutInSeconds(int forkedProcessTimeoutInSeconds) {
        this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
    }

    @Override
    public int getForkedProcessExitTimeoutInSeconds() {
        return this.forkedProcessExitTimeoutInSeconds;
    }

    @Override
    public void setForkedProcessExitTimeoutInSeconds(int forkedProcessExitTimeoutInSeconds) {
        this.forkedProcessExitTimeoutInSeconds = forkedProcessExitTimeoutInSeconds;
    }

    @Override
    public double getParallelTestsTimeoutInSeconds() {
        return this.parallelTestsTimeoutInSeconds;
    }

    @Override
    public void setParallelTestsTimeoutInSeconds(double parallelTestsTimeoutInSeconds) {
        this.parallelTestsTimeoutInSeconds = parallelTestsTimeoutInSeconds;
    }

    @Override
    public double getParallelTestsTimeoutForcedInSeconds() {
        return this.parallelTestsTimeoutForcedInSeconds;
    }

    @Override
    public void setParallelTestsTimeoutForcedInSeconds(double parallelTestsTimeoutForcedInSeconds) {
        this.parallelTestsTimeoutForcedInSeconds = parallelTestsTimeoutForcedInSeconds;
    }

    @Override
    public void setTest(String test) {
        this.test = test;
    }

    @Override
    public List<String> getIncludes() {
        return this.includes;
    }

    @Override
    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    @Override
    public File[] getSuiteXmlFiles() {
        return (File[])this.suiteXmlFiles.clone();
    }

    @Override
    public void setSuiteXmlFiles(File[] suiteXmlFiles) {
        this.suiteXmlFiles = (File[])suiteXmlFiles.clone();
    }

    @Override
    public String getRunOrder() {
        return this.runOrder;
    }

    @Override
    public void setRunOrder(String runOrder) {
        this.runOrder = runOrder;
    }

    @Override
    public File getIncludesFile() {
        return this.includesFile;
    }

    @Override
    public File getExcludesFile() {
        return this.excludesFile;
    }

    @Override
    protected boolean useModulePath() {
        return this.useModulePath;
    }

    @Override
    protected void setUseModulePath(boolean useModulePath) {
        this.useModulePath = useModulePath;
    }

    @Override
    protected final List<File> suiteXmlFiles() {
        return this.hasSuiteXmlFiles() ? Arrays.asList(this.suiteXmlFiles) : Collections.emptyList();
    }

    @Override
    protected final boolean hasSuiteXmlFiles() {
        return this.suiteXmlFiles != null && this.suiteXmlFiles.length != 0;
    }

    @Override
    protected final String[] getExcludedEnvironmentVariables() {
        return this.excludedEnvironmentVariables == null ? new String[]{} : this.excludedEnvironmentVariables;
    }

    void setExcludedEnvironmentVariables(String[] excludedEnvironmentVariables) {
        this.excludedEnvironmentVariables = excludedEnvironmentVariables;
    }

    @Override
    protected final String getEnableProcessChecker() {
        return this.enableProcessChecker;
    }

    @Override
    protected final ForkNodeFactory getForkNode() {
        return this.forkNode;
    }
}

