/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.extensions;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.surefire.booterclient.output.DeserializedStacktraceWriter;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.surefire.api.booter.ForkedProcessEventType;
import org.apache.maven.surefire.api.event.ConsoleDebugEvent;
import org.apache.maven.surefire.api.event.ConsoleErrorEvent;
import org.apache.maven.surefire.api.event.ConsoleInfoEvent;
import org.apache.maven.surefire.api.event.ConsoleWarningEvent;
import org.apache.maven.surefire.api.event.ControlByeEvent;
import org.apache.maven.surefire.api.event.ControlNextTestEvent;
import org.apache.maven.surefire.api.event.ControlStopOnNextTestEvent;
import org.apache.maven.surefire.api.event.Event;
import org.apache.maven.surefire.api.event.JvmExitErrorEvent;
import org.apache.maven.surefire.api.event.StandardStreamErrEvent;
import org.apache.maven.surefire.api.event.StandardStreamErrWithNewLineEvent;
import org.apache.maven.surefire.api.event.StandardStreamOutEvent;
import org.apache.maven.surefire.api.event.StandardStreamOutWithNewLineEvent;
import org.apache.maven.surefire.api.event.SystemPropertyEvent;
import org.apache.maven.surefire.api.event.TestAssumptionFailureEvent;
import org.apache.maven.surefire.api.event.TestErrorEvent;
import org.apache.maven.surefire.api.event.TestFailedEvent;
import org.apache.maven.surefire.api.event.TestSkippedEvent;
import org.apache.maven.surefire.api.event.TestStartingEvent;
import org.apache.maven.surefire.api.event.TestSucceededEvent;
import org.apache.maven.surefire.api.event.TestsetCompletedEvent;
import org.apache.maven.surefire.api.event.TestsetStartingEvent;
import org.apache.maven.surefire.api.report.CategorizedReportEntry;
import org.apache.maven.surefire.api.report.RunMode;
import org.apache.maven.surefire.api.report.StackTraceWriter;
import org.apache.maven.surefire.api.report.TestSetReportEntry;
import org.apache.maven.surefire.extensions.CloseableDaemonThread;
import org.apache.maven.surefire.extensions.EventHandler;
import org.apache.maven.surefire.extensions.ForkNodeArguments;
import org.apache.maven.surefire.extensions.util.CountdownCloseable;
import org.apache.maven.surefire.shared.codec.binary.Base64;

public class EventConsumerThread
extends CloseableDaemonThread {
    private static final String[] JVM_ERROR_PATTERNS = new String[]{"could not create the java virtual machine", "error occurred during initialization", "error:", "could not reserve enough space", "could not allocate", "unable to allocate", "java.lang.module.findexception"};
    private static final String PRINTABLE_JVM_NATIVE_STREAM = "Listening for transport dt_socket at address:";
    private static final Base64 BASE64 = new Base64();
    private final ReadableByteChannel channel;
    private final EventHandler<Event> eventHandler;
    private final CountdownCloseable countdownCloseable;
    private final ForkNodeArguments arguments;
    private volatile boolean disabled;

    public EventConsumerThread(@Nonnull String threadName, @Nonnull ReadableByteChannel channel, @Nonnull EventHandler<Event> eventHandler, @Nonnull CountdownCloseable countdownCloseable, @Nonnull ForkNodeArguments arguments) {
        super(threadName);
        this.channel = channel;
        this.eventHandler = eventHandler;
        this.countdownCloseable = countdownCloseable;
        this.arguments = arguments;
    }

    @Override
    public void run() {
        try (ReadableByteChannel stream = this.channel;
             CountdownCloseable c = this.countdownCloseable;){
            this.decode();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void disable() {
        this.disabled = true;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    private void decode() throws IOException {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder line = new StringBuilder();
        StringBuilder token = new StringBuilder("maven-surefire-event".length());
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        buffer.position(buffer.limit());
        block0: while (true) {
            boolean streamContinues;
            line.setLength(0);
            tokens.clear();
            token.setLength(0);
            FrameCompletion completion = null;
            boolean frameStarted = false;
            while (streamContinues = this.read(buffer)) {
                char c = (char)buffer.get();
                if (c == '\n' || c == '\r') {
                    this.printExistingLine(line);
                    continue block0;
                }
                line.append(c);
                if (!frameStarted) {
                    if (c == ':') {
                        frameStarted = true;
                        token.setLength(0);
                        tokens.clear();
                    }
                } else if (c == ':') {
                    tokens.add(token.toString());
                    token.setLength(0);
                    completion = EventConsumerThread.frameCompleteness(tokens);
                    if (completion == FrameCompletion.COMPLETE) {
                        line.setLength(0);
                        break;
                    }
                    if (completion == FrameCompletion.MALFORMED) {
                        this.printExistingLine(line);
                        continue block0;
                    }
                } else {
                    token.append(c);
                }
                completion = null;
            }
            if (completion == FrameCompletion.COMPLETE) {
                Event event = this.toEvent(tokens);
                if (!this.disabled && event != null) {
                    this.eventHandler.handleEvent(event);
                }
            }
            if (!streamContinues) break;
        }
        this.printExistingLine(line);
    }

    private boolean read(ByteBuffer buffer) throws IOException {
        if (buffer.hasRemaining() && buffer.position() > 0) {
            return true;
        }
        buffer.clear();
        boolean isEndOfStream = this.channel.read(buffer) == -1;
        buffer.flip();
        return !isEndOfStream;
    }

    private void printExistingLine(StringBuilder line) {
        if (line.length() != 0) {
            ConsoleLogger logger = this.arguments.getConsoleLogger();
            String s = line.toString().trim();
            if (s.contains(PRINTABLE_JVM_NATIVE_STREAM)) {
                if (logger.isDebugEnabled()) {
                    logger.debug(s);
                } else if (logger.isInfoEnabled()) {
                    logger.info(s);
                } else {
                    System.out.println(s);
                }
            } else {
                if (EventConsumerThread.isJvmError(s)) {
                    logger.error(s);
                }
                String msg = "Corrupted STDOUT by directly writing to native stream in forked JVM " + this.arguments.getForkChannelId() + ".";
                File dumpFile = this.arguments.dumpStreamText(msg + " Stream '" + s + "'.");
                this.arguments.logWarningAtEnd(msg + " See FAQ web page and the dump file " + dumpFile.getAbsolutePath());
                if (logger.isDebugEnabled()) {
                    logger.debug(s);
                }
            }
        }
    }

    private Event toEvent(List<String> tokensInFrame) {
        Iterator<String> tokens = tokensInFrame.iterator();
        String header = tokens.next();
        assert (header != null);
        ForkedProcessEventType event = ForkedProcessEventType.byOpcode(tokens.next());
        if (event == null) {
            return null;
        }
        if (event.isControlCategory()) {
            switch (event) {
                case BOOTERCODE_BYE: {
                    return new ControlByeEvent();
                }
                case BOOTERCODE_STOP_ON_NEXT_TEST: {
                    return new ControlStopOnNextTestEvent();
                }
                case BOOTERCODE_NEXT_TEST: {
                    return new ControlNextTestEvent();
                }
            }
            throw new IllegalStateException("Unknown enum " + (Object)((Object)event));
        }
        if (event.isConsoleErrorCategory() || event.isJvmExitError()) {
            Charset encoding = Charset.forName(tokens.next());
            StackTraceWriter stackTraceWriter = EventConsumerThread.decodeTrace(encoding, tokens.next(), tokens.next(), tokens.next());
            return event.isConsoleErrorCategory() ? new ConsoleErrorEvent(stackTraceWriter) : new JvmExitErrorEvent(stackTraceWriter);
        }
        if (event.isConsoleCategory()) {
            Charset encoding = Charset.forName(tokens.next());
            String msg = EventConsumerThread.decode(tokens.next(), encoding);
            switch (event) {
                case BOOTERCODE_CONSOLE_INFO: {
                    return new ConsoleInfoEvent(msg);
                }
                case BOOTERCODE_CONSOLE_DEBUG: {
                    return new ConsoleDebugEvent(msg);
                }
                case BOOTERCODE_CONSOLE_WARNING: {
                    return new ConsoleWarningEvent(msg);
                }
            }
            throw new IllegalStateException("Unknown enum " + (Object)((Object)event));
        }
        if (event.isStandardStreamCategory()) {
            RunMode mode = RunMode.MODES.get(tokens.next());
            Charset encoding = Charset.forName(tokens.next());
            String output = EventConsumerThread.decode(tokens.next(), encoding);
            switch (event) {
                case BOOTERCODE_STDOUT: {
                    return new StandardStreamOutEvent(mode, output);
                }
                case BOOTERCODE_STDOUT_NEW_LINE: {
                    return new StandardStreamOutWithNewLineEvent(mode, output);
                }
                case BOOTERCODE_STDERR: {
                    return new StandardStreamErrEvent(mode, output);
                }
                case BOOTERCODE_STDERR_NEW_LINE: {
                    return new StandardStreamErrWithNewLineEvent(mode, output);
                }
            }
            throw new IllegalStateException("Unknown enum " + (Object)((Object)event));
        }
        if (event.isSysPropCategory()) {
            RunMode mode = RunMode.MODES.get(tokens.next());
            Charset encoding = Charset.forName(tokens.next());
            String key = EventConsumerThread.decode(tokens.next(), encoding);
            String value = EventConsumerThread.decode(tokens.next(), encoding);
            return new SystemPropertyEvent(mode, key, value);
        }
        if (event.isTestCategory()) {
            RunMode mode = RunMode.MODES.get(tokens.next());
            Charset encoding = Charset.forName(tokens.next());
            TestSetReportEntry reportEntry = EventConsumerThread.decodeReportEntry(encoding, tokens.next(), tokens.next(), tokens.next(), tokens.next(), tokens.next(), tokens.next(), tokens.next(), tokens.next(), tokens.next(), tokens.next());
            switch (event) {
                case BOOTERCODE_TESTSET_STARTING: {
                    return new TestsetStartingEvent(mode, reportEntry);
                }
                case BOOTERCODE_TESTSET_COMPLETED: {
                    return new TestsetCompletedEvent(mode, reportEntry);
                }
                case BOOTERCODE_TEST_STARTING: {
                    return new TestStartingEvent(mode, reportEntry);
                }
                case BOOTERCODE_TEST_SUCCEEDED: {
                    return new TestSucceededEvent(mode, reportEntry);
                }
                case BOOTERCODE_TEST_FAILED: {
                    return new TestFailedEvent(mode, reportEntry);
                }
                case BOOTERCODE_TEST_SKIPPED: {
                    return new TestSkippedEvent(mode, reportEntry);
                }
                case BOOTERCODE_TEST_ERROR: {
                    return new TestErrorEvent(mode, reportEntry);
                }
                case BOOTERCODE_TEST_ASSUMPTIONFAILURE: {
                    return new TestAssumptionFailureEvent(mode, reportEntry);
                }
            }
            throw new IllegalStateException("Unknown enum " + (Object)((Object)event));
        }
        throw new IllegalStateException("Missing a branch for the event type " + (Object)((Object)event));
    }

    private static FrameCompletion frameCompleteness(List<String> tokens) {
        if (!tokens.isEmpty() && !"maven-surefire-event".equals(tokens.get(0))) {
            return FrameCompletion.MALFORMED;
        }
        if (tokens.size() >= 2) {
            String opcode = tokens.get(1);
            ForkedProcessEventType event = ForkedProcessEventType.byOpcode(opcode);
            if (event == null) {
                return FrameCompletion.MALFORMED;
            }
            if (event.isControlCategory()) {
                return FrameCompletion.COMPLETE;
            }
            if (event.isConsoleErrorCategory()) {
                return tokens.size() == 6 ? FrameCompletion.COMPLETE : FrameCompletion.NOT_COMPLETE;
            }
            if (event.isConsoleCategory()) {
                return tokens.size() == 4 ? FrameCompletion.COMPLETE : FrameCompletion.NOT_COMPLETE;
            }
            if (event.isStandardStreamCategory()) {
                return tokens.size() == 5 ? FrameCompletion.COMPLETE : FrameCompletion.NOT_COMPLETE;
            }
            if (event.isSysPropCategory()) {
                return tokens.size() == 6 ? FrameCompletion.COMPLETE : FrameCompletion.NOT_COMPLETE;
            }
            if (event.isTestCategory()) {
                return tokens.size() == 14 ? FrameCompletion.COMPLETE : FrameCompletion.NOT_COMPLETE;
            }
            if (event.isJvmExitError()) {
                return tokens.size() == 6 ? FrameCompletion.COMPLETE : FrameCompletion.NOT_COMPLETE;
            }
        }
        return FrameCompletion.NOT_COMPLETE;
    }

    static String decode(String line, Charset encoding) {
        return line == null || "-".equals(line) ? null : new String(BASE64.decode(line.getBytes(StandardCharsets.US_ASCII)), encoding);
    }

    private static StackTraceWriter decodeTrace(Charset encoding, String encTraceMessage, String encSmartTrimmedStackTrace, String encStackTrace) {
        String traceMessage = EventConsumerThread.decode(encTraceMessage, encoding);
        String stackTrace = EventConsumerThread.decode(encStackTrace, encoding);
        String smartTrimmedStackTrace = EventConsumerThread.decode(encSmartTrimmedStackTrace, encoding);
        boolean exists = traceMessage != null || stackTrace != null || smartTrimmedStackTrace != null;
        return exists ? new DeserializedStacktraceWriter(traceMessage, smartTrimmedStackTrace, stackTrace) : null;
    }

    static TestSetReportEntry decodeReportEntry(Charset encoding, String encSource, String encSourceText, String encName, String encNameText, String encGroup, String encMessage, String encTimeElapsed, String encTraceMessage, String encSmartTrimmedStackTrace, String encStackTrace) throws NumberFormatException {
        if (encoding == null) {
            return null;
        }
        String source = EventConsumerThread.decode(encSource, encoding);
        String sourceText = EventConsumerThread.decode(encSourceText, encoding);
        String name = EventConsumerThread.decode(encName, encoding);
        String nameText = EventConsumerThread.decode(encNameText, encoding);
        String group = EventConsumerThread.decode(encGroup, encoding);
        StackTraceWriter stackTraceWriter = EventConsumerThread.decodeTrace(encoding, encTraceMessage, encSmartTrimmedStackTrace, encStackTrace);
        Integer elapsed = EventConsumerThread.decodeToInteger(encTimeElapsed);
        String message = EventConsumerThread.decode(encMessage, encoding);
        return CategorizedReportEntry.reportEntry(source, sourceText, name, nameText, group, stackTraceWriter, elapsed, message, Collections.emptyMap());
    }

    static Integer decodeToInteger(String line) {
        return line == null || "-".equals(line) ? null : Integer.decode(line);
    }

    private static boolean isJvmError(String line) {
        String lineLower = line.toLowerCase();
        for (String errorPattern : JVM_ERROR_PATTERNS) {
            if (!lineLower.contains(errorPattern)) continue;
            return true;
        }
        return false;
    }

    private static enum FrameCompletion {
        NOT_COMPLETE,
        COMPLETE,
        MALFORMED;

    }
}

