/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter.spi;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.surefire.log.api.ConsoleLoggerUtils;
import org.apache.maven.surefire.api.booter.DumpErrorSingleton;
import org.apache.maven.surefire.api.booter.ForkedProcessEventType;
import org.apache.maven.surefire.api.booter.MasterProcessChannelEncoder;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.api.report.RunMode;
import org.apache.maven.surefire.api.report.SafeThrowable;
import org.apache.maven.surefire.api.report.StackTraceWriter;
import org.apache.maven.surefire.api.util.internal.WritableBufferedByteChannel;
import org.apache.maven.surefire.shared.codec.binary.Base64;

public class LegacyMasterProcessChannelEncoder
implements MasterProcessChannelEncoder {
    private static final Base64 BASE64 = new Base64();
    private static final Charset STREAM_ENCODING = StandardCharsets.US_ASCII;
    private static final Charset STRING_ENCODING = StandardCharsets.UTF_8;
    private final WritableBufferedByteChannel out;
    private final RunMode runMode;
    private final AtomicBoolean trouble = new AtomicBoolean();
    private volatile boolean onExit;

    public LegacyMasterProcessChannelEncoder(@Nonnull WritableBufferedByteChannel out) {
        this(out, RunMode.NORMAL_RUN);
    }

    protected LegacyMasterProcessChannelEncoder(@Nonnull WritableBufferedByteChannel out, @Nonnull RunMode runMode) {
        this.out = Objects.requireNonNull(out);
        this.runMode = Objects.requireNonNull(runMode);
    }

    @Override
    public MasterProcessChannelEncoder asRerunMode() {
        return new LegacyMasterProcessChannelEncoder(this.out, RunMode.RERUN_TEST_AFTER_FAILURE);
    }

    @Override
    public MasterProcessChannelEncoder asNormalMode() {
        return new LegacyMasterProcessChannelEncoder(this.out, RunMode.NORMAL_RUN);
    }

    @Override
    public boolean checkError() {
        return this.trouble.get();
    }

    @Override
    public void onJvmExit() {
        this.onExit = true;
        this.encodeAndPrintEvent(new StringBuilder("\n"), true);
    }

    @Override
    public void sendSystemProperties(Map<String, String> sysProps) {
        for (Map.Entry<String, String> entry : sysProps.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            StringBuilder event = LegacyMasterProcessChannelEncoder.encode(ForkedProcessEventType.BOOTERCODE_SYSPROPS, this.runMode, key, value);
            this.encodeAndPrintEvent(event, false);
        }
    }

    @Override
    public void testSetStarting(ReportEntry reportEntry, boolean trimStackTraces) {
        this.encode(ForkedProcessEventType.BOOTERCODE_TESTSET_STARTING, this.runMode, reportEntry, trimStackTraces, true);
    }

    @Override
    public void testSetCompleted(ReportEntry reportEntry, boolean trimStackTraces) {
        this.encode(ForkedProcessEventType.BOOTERCODE_TESTSET_COMPLETED, this.runMode, reportEntry, trimStackTraces, true);
    }

    @Override
    public void testStarting(ReportEntry reportEntry, boolean trimStackTraces) {
        this.encode(ForkedProcessEventType.BOOTERCODE_TEST_STARTING, this.runMode, reportEntry, trimStackTraces, true);
    }

    @Override
    public void testSucceeded(ReportEntry reportEntry, boolean trimStackTraces) {
        this.encode(ForkedProcessEventType.BOOTERCODE_TEST_SUCCEEDED, this.runMode, reportEntry, trimStackTraces, true);
    }

    @Override
    public void testFailed(ReportEntry reportEntry, boolean trimStackTraces) {
        this.encode(ForkedProcessEventType.BOOTERCODE_TEST_FAILED, this.runMode, reportEntry, trimStackTraces, true);
    }

    @Override
    public void testSkipped(ReportEntry reportEntry, boolean trimStackTraces) {
        this.encode(ForkedProcessEventType.BOOTERCODE_TEST_SKIPPED, this.runMode, reportEntry, trimStackTraces, true);
    }

    @Override
    public void testError(ReportEntry reportEntry, boolean trimStackTraces) {
        this.encode(ForkedProcessEventType.BOOTERCODE_TEST_ERROR, this.runMode, reportEntry, trimStackTraces, true);
    }

    @Override
    public void testAssumptionFailure(ReportEntry reportEntry, boolean trimStackTraces) {
        this.encode(ForkedProcessEventType.BOOTERCODE_TEST_ASSUMPTIONFAILURE, this.runMode, reportEntry, trimStackTraces, true);
    }

    @Override
    public void stdOut(String msg, boolean newLine) {
        ForkedProcessEventType event = newLine ? ForkedProcessEventType.BOOTERCODE_STDOUT_NEW_LINE : ForkedProcessEventType.BOOTERCODE_STDOUT;
        this.setOutErr(event.getOpcode(), msg);
    }

    @Override
    public void stdErr(String msg, boolean newLine) {
        ForkedProcessEventType event = newLine ? ForkedProcessEventType.BOOTERCODE_STDERR_NEW_LINE : ForkedProcessEventType.BOOTERCODE_STDERR;
        this.setOutErr(event.getOpcode(), msg);
    }

    private void setOutErr(String eventType, String message) {
        String base64Message = LegacyMasterProcessChannelEncoder.toBase64(message);
        StringBuilder event = LegacyMasterProcessChannelEncoder.encodeMessage(eventType, this.runMode.geRunName(), base64Message);
        this.encodeAndPrintEvent(event, false);
    }

    @Override
    public void consoleInfoLog(String msg) {
        StringBuilder event = this.print(ForkedProcessEventType.BOOTERCODE_CONSOLE_INFO.getOpcode(), msg);
        this.encodeAndPrintEvent(event, true);
    }

    @Override
    public void consoleErrorLog(String msg) {
        StringBuilder encoded = LegacyMasterProcessChannelEncoder.encodeHeader(ForkedProcessEventType.BOOTERCODE_CONSOLE_ERROR.getOpcode(), null);
        LegacyMasterProcessChannelEncoder.encode(encoded, msg, null, null);
        this.encodeAndPrintEvent(encoded, true);
    }

    @Override
    public void consoleErrorLog(Throwable t) {
        this.consoleErrorLog(t.getLocalizedMessage(), t);
    }

    @Override
    public void consoleErrorLog(String msg, Throwable t) {
        StringBuilder encoded = LegacyMasterProcessChannelEncoder.encodeHeader(ForkedProcessEventType.BOOTERCODE_CONSOLE_ERROR.getOpcode(), null);
        LegacyMasterProcessChannelEncoder.encode(encoded, msg, null, ConsoleLoggerUtils.toString(t));
        this.encodeAndPrintEvent(encoded, true);
    }

    @Override
    public void consoleErrorLog(StackTraceWriter stackTraceWriter, boolean trimStackTraces) {
        this.error(stackTraceWriter, trimStackTraces, ForkedProcessEventType.BOOTERCODE_CONSOLE_ERROR, true);
    }

    @Override
    public void consoleDebugLog(String msg) {
        StringBuilder event = this.print(ForkedProcessEventType.BOOTERCODE_CONSOLE_DEBUG.getOpcode(), msg);
        this.encodeAndPrintEvent(event, true);
    }

    @Override
    public void consoleWarningLog(String msg) {
        StringBuilder event = this.print(ForkedProcessEventType.BOOTERCODE_CONSOLE_WARNING.getOpcode(), msg);
        this.encodeAndPrintEvent(event, true);
    }

    @Override
    public void bye() {
        this.encodeOpcode(ForkedProcessEventType.BOOTERCODE_BYE, true);
    }

    @Override
    public void stopOnNextTest() {
        this.encodeOpcode(ForkedProcessEventType.BOOTERCODE_STOP_ON_NEXT_TEST, true);
    }

    @Override
    public void acquireNextTest() {
        this.encodeOpcode(ForkedProcessEventType.BOOTERCODE_NEXT_TEST, true);
    }

    @Override
    public void sendExitError(StackTraceWriter stackTraceWriter, boolean trimStackTraces) {
        this.error(stackTraceWriter, trimStackTraces, ForkedProcessEventType.BOOTERCODE_JVM_EXIT_ERROR, true);
    }

    private void error(StackTraceWriter stackTraceWriter, boolean trimStackTraces, ForkedProcessEventType event, boolean sendImmediately) {
        StringBuilder encoded = LegacyMasterProcessChannelEncoder.encodeHeader(event.getOpcode(), null);
        LegacyMasterProcessChannelEncoder.encode(encoded, stackTraceWriter, trimStackTraces);
        this.encodeAndPrintEvent(encoded, sendImmediately);
    }

    private void encode(ForkedProcessEventType operation, RunMode runMode, ReportEntry reportEntry, boolean trimStackTraces, boolean sendImmediately) {
        StringBuilder event = LegacyMasterProcessChannelEncoder.encode(operation.getOpcode(), runMode.geRunName(), reportEntry, trimStackTraces);
        this.encodeAndPrintEvent(event, sendImmediately);
    }

    private void encodeOpcode(ForkedProcessEventType operation, boolean sendImmediately) {
        StringBuilder event = LegacyMasterProcessChannelEncoder.encodeOpcode(operation.getOpcode(), null);
        this.encodeAndPrintEvent(event, sendImmediately);
    }

    private void encodeAndPrintEvent(StringBuilder event, boolean sendImmediately) {
        block6: {
            try {
                Thread.interrupted();
                byte[] array = event.append('\n').toString().getBytes(STREAM_ENCODING);
                ByteBuffer bb = ByteBuffer.wrap(array);
                if (sendImmediately) {
                    this.out.write(bb);
                } else {
                    this.out.writeBuffered(bb);
                }
            }
            catch (ClosedChannelException e) {
                if (!this.onExit) {
                    DumpErrorSingleton.getSingleton().dumpException(e, "Channel closed while writing the event '" + event + "'.");
                }
            }
            catch (IOException e) {
                if (!this.trouble.compareAndSet(false, true)) break block6;
                DumpErrorSingleton.getSingleton().dumpException(e);
            }
        }
    }

    static StringBuilder encode(ForkedProcessEventType operation, RunMode runMode, String ... args) {
        StringBuilder encodedTo = LegacyMasterProcessChannelEncoder.encodeHeader(operation.getOpcode(), runMode.geRunName());
        int i = 0;
        while (i < args.length) {
            String arg = args[i++];
            encodedTo.append(LegacyMasterProcessChannelEncoder.toBase64(arg)).append(':');
        }
        return encodedTo;
    }

    static void encode(StringBuilder encoded, StackTraceWriter stw, boolean trimStackTraces) {
        SafeThrowable throwable = stw == null ? null : stw.getThrowable();
        String message = throwable == null ? null : throwable.getLocalizedMessage();
        String smartStackTrace = stw == null ? null : stw.smartTrimmedStackTrace();
        String stackTrace = stw == null ? null : LegacyMasterProcessChannelEncoder.toStackTrace(stw, trimStackTraces);
        LegacyMasterProcessChannelEncoder.encode(encoded, message, smartStackTrace, stackTrace);
    }

    private static void encode(StringBuilder encoded, String message, String smartStackTrace, String stackTrace) {
        encoded.append(LegacyMasterProcessChannelEncoder.toBase64(message)).append(':').append(LegacyMasterProcessChannelEncoder.toBase64(smartStackTrace)).append(':').append(LegacyMasterProcessChannelEncoder.toBase64(stackTrace)).append(':');
    }

    static StringBuilder encode(String operation, String runMode, ReportEntry reportEntry, boolean trimStackTraces) {
        StringBuilder encodedTo = LegacyMasterProcessChannelEncoder.encodeHeader(operation, runMode).append(LegacyMasterProcessChannelEncoder.toBase64(reportEntry.getSourceName())).append(':').append(LegacyMasterProcessChannelEncoder.toBase64(reportEntry.getSourceText())).append(':').append(LegacyMasterProcessChannelEncoder.toBase64(reportEntry.getName())).append(':').append(LegacyMasterProcessChannelEncoder.toBase64(reportEntry.getNameText())).append(':').append(LegacyMasterProcessChannelEncoder.toBase64(reportEntry.getGroup())).append(':').append(LegacyMasterProcessChannelEncoder.toBase64(reportEntry.getMessage())).append(':').append(reportEntry.getElapsed() == null ? "-" : reportEntry.getElapsed().toString()).append(':');
        LegacyMasterProcessChannelEncoder.encode(encodedTo, reportEntry.getStackTraceWriter(), trimStackTraces);
        return encodedTo;
    }

    StringBuilder print(String operation, String ... msgs) {
        String[] encodedMsgs = new String[msgs.length];
        for (int i = 0; i < encodedMsgs.length; ++i) {
            String msg = msgs[i];
            encodedMsgs[i] = LegacyMasterProcessChannelEncoder.toBase64(msg);
        }
        return LegacyMasterProcessChannelEncoder.encodeMessage(operation, null, encodedMsgs);
    }

    static StringBuilder encodeMessage(String operation, String runMode, String ... encodedMsgs) {
        StringBuilder builder = LegacyMasterProcessChannelEncoder.encodeHeader(operation, runMode);
        for (String encodedMsg : encodedMsgs) {
            builder.append(encodedMsg).append(':');
        }
        return builder;
    }

    static StringBuilder encodeHeader(String operation, String runMode) {
        return LegacyMasterProcessChannelEncoder.encodeOpcode(operation, runMode).append(STRING_ENCODING.name()).append(':');
    }

    static StringBuilder encodeOpcode(String operation, String runMode) {
        StringBuilder s = new StringBuilder(128).append(':').append("maven-surefire-event").append(':').append(operation).append(':');
        return runMode == null ? s : s.append(runMode).append(':');
    }

    private static String toStackTrace(StackTraceWriter stw, boolean trimStackTraces) {
        return trimStackTraces ? stw.writeTrimmedTraceToString() : stw.writeTraceToString();
    }

    static String toBase64(String msg) {
        return msg == null ? "-" : new String(BASE64.encode(msg.getBytes(STRING_ENCODING)), STREAM_ENCODING);
    }
}

