/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.shared.utils.StringUtils;

final class TestClassPath {
    private final Iterable<Artifact> artifacts;
    private final File classesDirectory;
    private final File testClassesDirectory;
    private final String[] additionalClasspathElements;

    TestClassPath(Iterable<Artifact> artifacts, File classesDirectory, File testClassesDirectory, String[] additionalClasspathElements) {
        this.artifacts = artifacts;
        this.classesDirectory = classesDirectory;
        this.testClassesDirectory = testClassesDirectory;
        this.additionalClasspathElements = additionalClasspathElements;
    }

    Map<String, Artifact> getTestDependencies() {
        LinkedHashMap<String, Artifact> artifactMapping = new LinkedHashMap<String, Artifact>();
        for (Artifact artifact : this.artifacts) {
            artifactMapping.put(artifact.getGroupId() + ":" + artifact.getArtifactId(), artifact);
        }
        return artifactMapping;
    }

    Classpath toClasspath() {
        ArrayList<String> classpath = new ArrayList<String>();
        classpath.add(this.testClassesDirectory.getAbsolutePath());
        classpath.add(this.classesDirectory.getAbsolutePath());
        for (Artifact artifact : this.artifacts) {
            File file;
            if (!artifact.getArtifactHandler().isAddedToClasspath() || (file = artifact.getFile()) == null) continue;
            classpath.add(file.getAbsolutePath());
        }
        if (this.additionalClasspathElements != null) {
            for (String additionalClasspathElement : this.additionalClasspathElements) {
                if (additionalClasspathElement == null) continue;
                Collections.addAll(classpath, StringUtils.split(additionalClasspathElement, ","));
            }
        }
        return new Classpath(classpath);
    }
}

