/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient.output;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.NotifiableTestStream;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessEventListener;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessEventNotifier;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessExitErrorListener;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessPropertyEventListener;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessReportEventListener;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessStackTraceEventListener;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessStandardOutErrEventListener;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessStringEventListener;
import org.apache.maven.plugin.surefire.booterclient.output.InPluginProcessDumpSingleton;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.report.DefaultReporterFactory;
import org.apache.maven.surefire.api.booter.Shutdown;
import org.apache.maven.surefire.api.event.Event;
import org.apache.maven.surefire.api.report.CategorizedReportEntry;
import org.apache.maven.surefire.api.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.api.report.RunListener;
import org.apache.maven.surefire.api.report.RunMode;
import org.apache.maven.surefire.api.report.StackTraceWriter;
import org.apache.maven.surefire.api.report.TestSetReportEntry;
import org.apache.maven.surefire.extensions.EventHandler;

public class ForkClient
implements EventHandler<Event> {
    private static final long START_TIME_ZERO = 0L;
    private static final long START_TIME_NEGATIVE_TIMEOUT = -1L;
    private final DefaultReporterFactory defaultReporterFactory;
    private final Map<String, String> testVmSystemProperties = new ConcurrentHashMap<String, String>();
    private final NotifiableTestStream notifiableTestStream;
    private final Queue<String> testsInProgress = new ConcurrentLinkedQueue<String>();
    private final AtomicLong testSetStartedAt = new AtomicLong(0L);
    private final ForkedProcessEventNotifier notifier = new ForkedProcessEventNotifier();
    private final int forkNumber;
    private RunListener testSetReporter;
    private volatile boolean saidGoodBye;
    private volatile StackTraceWriter errorInFork;

    public ForkClient(DefaultReporterFactory defaultReporterFactory, NotifiableTestStream notifiableTestStream, int forkNumber) {
        this.defaultReporterFactory = defaultReporterFactory;
        this.notifiableTestStream = notifiableTestStream;
        this.forkNumber = forkNumber;
        this.notifier.setTestSetStartingListener(new TestSetStartingListener());
        this.notifier.setTestSetCompletedListener(new TestSetCompletedListener());
        this.notifier.setTestStartingListener(new TestStartingListener());
        this.notifier.setTestSucceededListener(new TestSucceededListener());
        this.notifier.setTestFailedListener(new TestFailedListener());
        this.notifier.setTestSkippedListener(new TestSkippedListener());
        this.notifier.setTestErrorListener(new TestErrorListener());
        this.notifier.setTestAssumptionFailureListener(new TestAssumptionFailureListener());
        this.notifier.setSystemPropertiesListener(new SystemPropertiesListener());
        this.notifier.setStdOutListener(new StdOutListener());
        this.notifier.setStdErrListener(new StdErrListener());
        this.notifier.setConsoleInfoListener(new ConsoleListener());
        this.notifier.setAcquireNextTestListener(new AcquireNextTestListener());
        this.notifier.setConsoleErrorListener(new ErrorListener());
        this.notifier.setByeListener(new ByeListener());
        this.notifier.setStopOnNextTestListener(new StopOnNextTestListener());
        this.notifier.setConsoleDebugListener(new DebugListener());
        this.notifier.setConsoleWarningListener(new WarningListener());
        this.notifier.setExitErrorEventListener(new ExitErrorEventListener());
    }

    protected void stopOnNextTest() {
    }

    public void kill() {
        if (!this.saidGoodBye) {
            this.notifiableTestStream.shutdown(Shutdown.KILL);
        }
    }

    public final void tryToTimeout(long currentTimeMillis, int forkedProcessTimeoutInSeconds) {
        if (forkedProcessTimeoutInSeconds > 0) {
            long forkedProcessTimeoutInMillis = 1000 * forkedProcessTimeoutInSeconds;
            long startedAt = this.testSetStartedAt.get();
            if (startedAt > 0L && currentTimeMillis - startedAt >= forkedProcessTimeoutInMillis) {
                this.testSetStartedAt.set(-1L);
                this.notifiableTestStream.shutdown(Shutdown.KILL);
            }
        }
    }

    public final DefaultReporterFactory getDefaultReporterFactory() {
        return this.defaultReporterFactory;
    }

    @Override
    public final void handleEvent(@Nonnull Event event) {
        this.notifier.notifyEvent(event);
    }

    private void setCurrentStartTime() {
        if (this.testSetStartedAt.get() == 0L) {
            this.testSetStartedAt.compareAndSet(0L, System.currentTimeMillis());
        }
    }

    public final boolean hadTimeout() {
        return this.testSetStartedAt.get() == -1L;
    }

    private RunListener getTestSetReporter() {
        if (this.testSetReporter == null) {
            this.testSetReporter = this.defaultReporterFactory.createReporter();
        }
        return this.testSetReporter;
    }

    void dumpToLoFile(String msg) {
        File reportsDir = this.defaultReporterFactory.getReportsDirectory();
        InPluginProcessDumpSingleton util = InPluginProcessDumpSingleton.getSingleton();
        util.dumpStreamText(msg, reportsDir, this.forkNumber);
    }

    private void writeTestOutput(String output, boolean newLine, boolean isStdout) {
        this.getOrCreateConsoleOutputReceiver().writeTestOutput(output, newLine, isStdout);
    }

    public final Map<String, String> getTestVmSystemProperties() {
        return Collections.unmodifiableMap(this.testVmSystemProperties);
    }

    public final RunListener getReporter() {
        return this.getTestSetReporter();
    }

    private ConsoleOutputReceiver getOrCreateConsoleOutputReceiver() {
        return (ConsoleOutputReceiver)((Object)this.getTestSetReporter());
    }

    private ConsoleLogger getOrCreateConsoleLogger() {
        return (ConsoleLogger)((Object)this.getTestSetReporter());
    }

    public void close(boolean hadTimeout) {
    }

    public final boolean isSaidGoodBye() {
        return this.saidGoodBye;
    }

    public final StackTraceWriter getErrorInFork() {
        return this.errorInFork;
    }

    public final boolean isErrorInFork() {
        return this.errorInFork != null;
    }

    public Set<String> testsInProgress() {
        return new TreeSet<String>(this.testsInProgress);
    }

    public boolean hasTestsInProgress() {
        return !this.testsInProgress.isEmpty();
    }

    private final class ExitErrorEventListener
    implements ForkedProcessExitErrorListener {
        private ExitErrorEventListener() {
        }

        @Override
        public void handle(StackTraceWriter stackTrace) {
            ForkClient.this.getOrCreateConsoleLogger().error("System Exit has timed out in the forked process " + ForkClient.this.forkNumber);
        }
    }

    private final class WarningListener
    implements ForkedProcessStringEventListener {
        private WarningListener() {
        }

        @Override
        public void handle(String msg) {
            ForkClient.this.getOrCreateConsoleLogger().warning(msg);
        }
    }

    private final class DebugListener
    implements ForkedProcessStringEventListener {
        private DebugListener() {
        }

        @Override
        public void handle(String msg) {
            ForkClient.this.getOrCreateConsoleLogger().debug(msg);
        }
    }

    private final class StopOnNextTestListener
    implements ForkedProcessEventListener {
        private StopOnNextTestListener() {
        }

        @Override
        public void handle() {
            ForkClient.this.stopOnNextTest();
        }
    }

    private final class ByeListener
    implements ForkedProcessEventListener {
        private ByeListener() {
        }

        @Override
        public void handle() {
            ForkClient.this.saidGoodBye = true;
            ForkClient.this.notifiableTestStream.acknowledgeByeEventReceived();
        }
    }

    private class ErrorListener
    implements ForkedProcessStackTraceEventListener {
        private ErrorListener() {
        }

        @Override
        public void handle(@Nonnull StackTraceWriter stackTrace) {
            String msg = stackTrace.getThrowable().getMessage();
            if (ForkClient.this.errorInFork == null) {
                ForkClient.this.errorInFork = stackTrace.writeTraceToString() != null ? stackTrace : null;
                if (msg != null) {
                    ForkClient.this.getOrCreateConsoleLogger().error(msg);
                }
            }
            ForkClient.this.dumpToLoFile(msg);
        }
    }

    private final class AcquireNextTestListener
    implements ForkedProcessEventListener {
        private AcquireNextTestListener() {
        }

        @Override
        public void handle() {
            ForkClient.this.notifiableTestStream.provideNewTest();
        }
    }

    private final class ConsoleListener
    implements ForkedProcessStringEventListener {
        private ConsoleListener() {
        }

        @Override
        public void handle(String msg) {
            ForkClient.this.getOrCreateConsoleLogger().info(msg);
        }
    }

    private final class StdErrListener
    implements ForkedProcessStandardOutErrEventListener {
        private StdErrListener() {
        }

        @Override
        public void handle(RunMode runMode, String output, boolean newLine) {
            ForkClient.this.writeTestOutput(output, newLine, false);
        }
    }

    private final class StdOutListener
    implements ForkedProcessStandardOutErrEventListener {
        private StdOutListener() {
        }

        @Override
        public void handle(RunMode runMode, String output, boolean newLine) {
            ForkClient.this.writeTestOutput(output, newLine, true);
        }
    }

    private final class SystemPropertiesListener
    implements ForkedProcessPropertyEventListener {
        private SystemPropertiesListener() {
        }

        @Override
        public void handle(RunMode runMode, String key, String value) {
            ForkClient.this.testVmSystemProperties.put(key, value);
        }
    }

    private final class TestAssumptionFailureListener
    implements ForkedProcessReportEventListener<ReportEntry> {
        private TestAssumptionFailureListener() {
        }

        @Override
        public void handle(RunMode runMode, ReportEntry reportEntry) {
            ForkClient.this.testsInProgress.remove(reportEntry.getSourceName());
            ForkClient.this.getTestSetReporter().testAssumptionFailure(reportEntry);
        }
    }

    private final class TestErrorListener
    implements ForkedProcessReportEventListener<ReportEntry> {
        private TestErrorListener() {
        }

        @Override
        public void handle(RunMode runMode, ReportEntry reportEntry) {
            ForkClient.this.testsInProgress.remove(reportEntry.getSourceName());
            ForkClient.this.getTestSetReporter().testError(reportEntry);
        }
    }

    private final class TestSkippedListener
    implements ForkedProcessReportEventListener<ReportEntry> {
        private TestSkippedListener() {
        }

        @Override
        public void handle(RunMode runMode, ReportEntry reportEntry) {
            ForkClient.this.testsInProgress.remove(reportEntry.getSourceName());
            ForkClient.this.getTestSetReporter().testSkipped(reportEntry);
        }
    }

    private final class TestFailedListener
    implements ForkedProcessReportEventListener<ReportEntry> {
        private TestFailedListener() {
        }

        @Override
        public void handle(RunMode runMode, ReportEntry reportEntry) {
            ForkClient.this.testsInProgress.remove(reportEntry.getSourceName());
            ForkClient.this.getTestSetReporter().testFailed(reportEntry);
        }
    }

    private final class TestSucceededListener
    implements ForkedProcessReportEventListener<ReportEntry> {
        private TestSucceededListener() {
        }

        @Override
        public void handle(RunMode runMode, ReportEntry reportEntry) {
            ForkClient.this.testsInProgress.remove(reportEntry.getSourceName());
            ForkClient.this.getTestSetReporter().testSucceeded(reportEntry);
        }
    }

    private final class TestStartingListener
    implements ForkedProcessReportEventListener<ReportEntry> {
        private TestStartingListener() {
        }

        @Override
        public void handle(RunMode runMode, ReportEntry reportEntry) {
            ForkClient.this.testsInProgress.offer(reportEntry.getSourceName());
            ForkClient.this.getTestSetReporter().testStarting(reportEntry);
        }
    }

    private final class TestSetCompletedListener
    implements ForkedProcessReportEventListener<TestSetReportEntry> {
        private TestSetCompletedListener() {
        }

        @Override
        public void handle(RunMode runMode, TestSetReportEntry reportEntry) {
            ForkClient.this.testsInProgress.clear();
            TestSetReportEntry entry = CategorizedReportEntry.reportEntry(reportEntry.getSourceName(), reportEntry.getSourceText(), reportEntry.getName(), reportEntry.getNameText(), reportEntry.getGroup(), reportEntry.getStackTraceWriter(), reportEntry.getElapsed(), reportEntry.getMessage(), ForkClient.this.getTestVmSystemProperties());
            ForkClient.this.getTestSetReporter().testSetCompleted(entry);
        }
    }

    private final class TestSetStartingListener
    implements ForkedProcessReportEventListener<TestSetReportEntry> {
        private TestSetStartingListener() {
        }

        @Override
        public void handle(RunMode runMode, TestSetReportEntry reportEntry) {
            ForkClient.this.getTestSetReporter().testSetStarting(reportEntry);
            ForkClient.this.setCurrentStartTime();
        }
    }
}

