/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient.output;

import java.io.File;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.surefire.api.util.internal.DumpFileUtils;

public final class InPluginProcessDumpSingleton {
    private static final InPluginProcessDumpSingleton SINGLETON = new InPluginProcessDumpSingleton();

    private InPluginProcessDumpSingleton() {
    }

    public static InPluginProcessDumpSingleton getSingleton() {
        return SINGLETON;
    }

    public synchronized File dumpStreamException(Throwable t, String msg, File reportsDirectory, int jvmRun) {
        File dump = InPluginProcessDumpSingleton.newDumpStreamFile(reportsDirectory, jvmRun);
        DumpFileUtils.dumpException(t, msg == null ? "null" : msg, dump);
        return dump;
    }

    public synchronized void dumpStreamException(Throwable t, String msg, File reportsDirectory) {
        DumpFileUtils.dumpException(t, msg == null ? "null" : msg, this.newDumpStreamFile(reportsDirectory));
    }

    public synchronized File dumpStreamText(String msg, File reportsDirectory, int jvmRun) {
        File dump = InPluginProcessDumpSingleton.newDumpStreamFile(reportsDirectory, jvmRun);
        DumpFileUtils.dumpText(msg == null ? "null" : msg, dump);
        return dump;
    }

    public synchronized void dumpStreamText(String msg, File reportsDirectory) {
        DumpFileUtils.dumpText(msg == null ? "null" : msg, this.newDumpStreamFile(reportsDirectory));
    }

    public synchronized void dumpException(Throwable t, String msg, File reportsDirectory, int jvmRun) {
        File dump = InPluginProcessDumpSingleton.newDumpFile(reportsDirectory, jvmRun);
        DumpFileUtils.dumpException(t, msg == null ? "null" : msg, dump);
    }

    public synchronized void dumpException(Throwable t, String msg, File reportsDirectory) {
        File dump = InPluginProcessDumpSingleton.newDumpFile(reportsDirectory);
        DumpFileUtils.dumpException(t, msg == null ? "null" : msg, dump);
    }

    private File newDumpStreamFile(File reportsDirectory) {
        return new File(reportsDirectory, SurefireHelper.DUMPSTREAM_FILENAME);
    }

    private static File newDumpStreamFile(File reportsDirectory, int jvmRun) {
        return new File(reportsDirectory, String.format(SurefireHelper.DUMPSTREAM_FILENAME_FORMATTER, jvmRun));
    }

    private static File newDumpFile(File reportsDirectory, int jvmRun) {
        return new File(reportsDirectory, String.format(SurefireHelper.DUMP_FILENAME_FORMATTER, jvmRun));
    }

    private static File newDumpFile(File reportsDirectory) {
        return new File(reportsDirectory, SurefireHelper.DUMP_FILENAME);
    }
}

