/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicStampedReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.maven.plugin.surefire.booterclient.output.InPluginProcessDumpSingleton;
import org.apache.maven.plugin.surefire.report.FileReporter;
import org.apache.maven.plugin.surefire.report.TestcycleConsoleOutputReceiver;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.api.report.TestSetReportEntry;
import org.apache.maven.surefire.api.util.internal.StringUtils;

public class ConsoleOutputFileReporter
implements TestcycleConsoleOutputReceiver {
    private static final int STREAM_BUFFER_SIZE = 65536;
    private static final int OPEN = 0;
    private static final int CLOSED_TO_REOPEN = 1;
    private static final int CLOSED = 2;
    private final File reportsDirectory;
    private final String reportNameSuffix;
    private final boolean usePhrasedFileName;
    private final Integer forkNumber;
    private final String encoding;
    private final AtomicStampedReference<FilterOutputStream> fileOutputStream = new AtomicStampedReference<Object>(null, 0);
    private final ReentrantLock lock = new ReentrantLock();
    private volatile String reportEntryName;

    public ConsoleOutputFileReporter(File reportsDirectory, String reportNameSuffix, boolean usePhrasedFileName, Integer forkNumber, String encoding) {
        this.reportsDirectory = reportsDirectory;
        this.reportNameSuffix = reportNameSuffix;
        this.usePhrasedFileName = usePhrasedFileName;
        this.forkNumber = forkNumber;
        this.encoding = encoding;
    }

    @Override
    public void testSetStarting(TestSetReportEntry reportEntry) {
        this.lock.lock();
        try {
            this.closeNullReportFile(reportEntry);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void testSetCompleted(TestSetReportEntry report) {
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            this.closeReportFile();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void writeTestOutput(String output, boolean newLine, boolean stdout) {
        this.lock.lock();
        try {
            int[] status = new int[1];
            FilterOutputStream os = this.fileOutputStream.get(status);
            if (status[0] != 2) {
                if (os == null) {
                    if (!this.reportsDirectory.exists()) {
                        this.reportsDirectory.mkdirs();
                    }
                    File file = FileReporter.getReportFile(this.reportsDirectory, this.reportEntryName, this.reportNameSuffix, "-output.txt");
                    os = new BufferedOutputStream(new FileOutputStream(file), 65536);
                    this.fileOutputStream.set(os, 0);
                }
                if (output == null) {
                    output = "null";
                }
                Charset charset = Charset.forName(this.encoding);
                os.write(output.getBytes(charset));
                if (newLine) {
                    os.write(StringUtils.NL.getBytes(charset));
                }
            }
        }
        catch (IOException e) {
            this.dumpException(e);
            throw new RuntimeException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void closeNullReportFile(ReportEntry reportEntry) {
        try {
            this.close(true);
            this.reportEntryName = this.usePhrasedFileName ? reportEntry.getSourceText() : reportEntry.getSourceName();
        }
        catch (IOException e) {
            try {
                this.dumpException(e);
                this.reportEntryName = this.usePhrasedFileName ? reportEntry.getSourceText() : reportEntry.getSourceName();
            }
            catch (Throwable throwable) {
                this.reportEntryName = this.usePhrasedFileName ? reportEntry.getSourceText() : reportEntry.getSourceName();
                throw throwable;
            }
        }
    }

    private void closeReportFile() {
        try {
            this.close(false);
        }
        catch (IOException e) {
            this.dumpException(e);
        }
    }

    private void close(boolean closeReattempt) throws IOException {
        int[] status = new int[1];
        FilterOutputStream os = this.fileOutputStream.get(status);
        if (status[0] != 2) {
            this.fileOutputStream.set(null, closeReattempt ? 1 : 2);
            if (os != null && status[0] == 0) {
                os.close();
            }
        }
    }

    private void dumpException(IOException e) {
        if (this.forkNumber == null) {
            InPluginProcessDumpSingleton.getSingleton().dumpException(e, e.getLocalizedMessage(), this.reportsDirectory);
        } else {
            InPluginProcessDumpSingleton.getSingleton().dumpException(e, e.getLocalizedMessage(), this.reportsDirectory, this.forkNumber);
        }
    }
}

