/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ServiceLoader;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.surefire.api.booter.BaseProviderFactory;
import org.apache.maven.surefire.api.booter.Command;
import org.apache.maven.surefire.api.booter.DumpErrorSingleton;
import org.apache.maven.surefire.api.booter.ForkingReporterFactory;
import org.apache.maven.surefire.api.booter.MasterProcessChannelDecoder;
import org.apache.maven.surefire.api.booter.MasterProcessChannelEncoder;
import org.apache.maven.surefire.api.booter.Shutdown;
import org.apache.maven.surefire.api.provider.CommandListener;
import org.apache.maven.surefire.api.provider.ProviderParameters;
import org.apache.maven.surefire.api.provider.SurefireProvider;
import org.apache.maven.surefire.api.report.LegacyPojoStackTraceWriter;
import org.apache.maven.surefire.api.testset.TestSetFailedException;
import org.apache.maven.surefire.api.util.ReflectionUtils;
import org.apache.maven.surefire.api.util.internal.DaemonThreadFactory;
import org.apache.maven.surefire.api.util.internal.StringUtils;
import org.apache.maven.surefire.booter.AbstractPathConfiguration;
import org.apache.maven.surefire.booter.BooterDeserializer;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.CommandReader;
import org.apache.maven.surefire.booter.LazyTestsToRun;
import org.apache.maven.surefire.booter.PpidChecker;
import org.apache.maven.surefire.booter.ProcessCheckerType;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SystemPropertyManager;
import org.apache.maven.surefire.booter.TypeEncodedValue;
import org.apache.maven.surefire.booter.spi.LegacyMasterProcessChannelProcessorFactory;
import org.apache.maven.surefire.booter.spi.SurefireMasterProcessChannelProcessorFactory;
import org.apache.maven.surefire.shared.utils.cli.ShutdownHookUtils;
import org.apache.maven.surefire.spi.MasterProcessChannelProcessorFactory;

public final class ForkedBooter {
    private static final long DEFAULT_SYSTEM_EXIT_TIMEOUT_IN_SECONDS = 30L;
    private static final long PING_TIMEOUT_IN_SECONDS = 30L;
    private static final long ONE_SECOND_IN_MILLIS = 1000L;
    private static final String LAST_DITCH_SHUTDOWN_THREAD = "surefire-forkedjvm-last-ditch-daemon-shutdown-thread-";
    private static final String PING_THREAD = "surefire-forkedjvm-ping-";
    private final Semaphore exitBarrier = new Semaphore(0);
    private volatile MasterProcessChannelEncoder eventChannel;
    private volatile MasterProcessChannelProcessorFactory channelProcessorFactory;
    private volatile CommandReader commandReader;
    private volatile long systemExitTimeoutInSeconds = 30L;
    private volatile PingScheduler pingScheduler;
    private ScheduledThreadPoolExecutor jvmTerminator;
    private ProviderConfiguration providerConfiguration;
    private ForkingReporterFactory forkingReporterFactory;
    private StartupConfiguration startupConfiguration;
    private Object testSet;

    private void setupBooter(String tmpDir, String dumpFileName, String surefirePropsFileName, String effectiveSystemPropertiesFileName) throws IOException {
        BooterDeserializer booterDeserializer = new BooterDeserializer(ForkedBooter.createSurefirePropertiesIfFileExists(tmpDir, surefirePropsFileName));
        SystemPropertyManager.setSystemProperties(new File(tmpDir, effectiveSystemPropertiesFileName));
        this.providerConfiguration = booterDeserializer.deserialize();
        DumpErrorSingleton.getSingleton().init(this.providerConfiguration.getReporterConfiguration().getReportsDirectory(), dumpFileName);
        if (ForkedBooter.isDebugging()) {
            DumpErrorSingleton.getSingleton().dumpText("Found Maven process ID " + booterDeserializer.getPluginPid());
        }
        this.startupConfiguration = booterDeserializer.getStartupConfiguration();
        String channelConfig = booterDeserializer.getConnectionString();
        this.channelProcessorFactory = ForkedBooter.lookupDecoderFactory(channelConfig);
        this.channelProcessorFactory.connect(channelConfig);
        this.eventChannel = this.channelProcessorFactory.createEncoder();
        MasterProcessChannelDecoder decoder = this.channelProcessorFactory.createDecoder();
        this.flushEventChannelOnExit();
        this.forkingReporterFactory = this.createForkingReporterFactory();
        ConsoleLogger logger = (ConsoleLogger)((Object)this.forkingReporterFactory.createReporter());
        this.commandReader = new CommandReader(decoder, this.providerConfiguration.getShutdown(), logger);
        this.pingScheduler = ForkedBooter.isDebugging() ? null : this.listenToShutdownCommands(booterDeserializer.getPluginPid(), logger);
        this.systemExitTimeoutInSeconds = this.providerConfiguration.systemExitTimeout(30L);
        AbstractPathConfiguration classpathConfiguration = this.startupConfiguration.getClasspathConfiguration();
        if (classpathConfiguration.isClassPathConfig()) {
            if (this.startupConfiguration.isManifestOnlyJarRequestedAndUsable()) {
                classpathConfiguration.toRealPath(ClasspathConfiguration.class).trickClassPathWhenManifestOnlyClasspath();
            }
            this.startupConfiguration.writeSurefireTestClasspathProperty();
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        classLoader.setDefaultAssertionStatus(classpathConfiguration.isEnableAssertions());
        boolean readTestsFromCommandReader = this.providerConfiguration.isReadTestsFromInStream();
        this.testSet = this.createTestSet(this.providerConfiguration.getTestForFork(), readTestsFromCommandReader, classLoader);
    }

    private void execute() {
        try {
            this.runSuitesInProcess();
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            DumpErrorSingleton.getSingleton().dumpException(t);
            this.eventChannel.consoleErrorLog(new LegacyPojoStackTraceWriter("test subsystem", "no method", t), false);
        }
        catch (Throwable t) {
            DumpErrorSingleton.getSingleton().dumpException(t);
            this.eventChannel.consoleErrorLog(new LegacyPojoStackTraceWriter("test subsystem", "no method", t), false);
        }
        finally {
            Thread.interrupted();
            if (this.eventChannel.checkError()) {
                DumpErrorSingleton.getSingleton().dumpText("The channel (std/out or TCP/IP) failed to send a stream from this subprocess.");
            }
            this.acknowledgedExit();
        }
    }

    private Object createTestSet(TypeEncodedValue forkedTestSet, boolean readTestsFromCommandReader, ClassLoader cl) {
        if (forkedTestSet != null) {
            return forkedTestSet.getDecodedValue(cl);
        }
        if (readTestsFromCommandReader) {
            return new LazyTestsToRun(this.eventChannel, this.commandReader);
        }
        return null;
    }

    private void cancelPingScheduler() {
        if (this.pingScheduler != null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        ForkedBooter.this.pingScheduler.shutdown();
                        return null;
                    }
                });
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
    }

    private void closeForkChannel() {
        if (this.channelProcessorFactory != null) {
            try {
                this.channelProcessorFactory.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private PingScheduler listenToShutdownCommands(String ppid, ConsoleLogger logger) {
        PpidChecker ppidChecker = ppid == null ? null : new PpidChecker(ppid);
        this.commandReader.addShutdownListener(this.createExitHandler(ppidChecker));
        AtomicBoolean pingDone = new AtomicBoolean(true);
        this.commandReader.addNoopListener(this.createPingHandler(pingDone));
        PingScheduler pingMechanisms = new PingScheduler(ForkedBooter.createPingScheduler(), ppidChecker);
        ProcessCheckerType checkerType = this.startupConfiguration.getProcessChecker();
        if ((checkerType == ProcessCheckerType.ALL || checkerType == ProcessCheckerType.NATIVE) && pingMechanisms.pluginProcessChecker != null) {
            logger.debug(pingMechanisms.pluginProcessChecker.toString());
            Runnable checkerJob = this.processCheckerJob(pingMechanisms);
            pingMechanisms.pingScheduler.scheduleWithFixedDelay(checkerJob, 0L, 1L, TimeUnit.SECONDS);
        }
        if (checkerType == ProcessCheckerType.ALL || checkerType == ProcessCheckerType.PING) {
            Runnable pingJob = this.createPingJob(pingDone, pingMechanisms.pluginProcessChecker);
            pingMechanisms.pingScheduler.scheduleWithFixedDelay(pingJob, 0L, 30L, TimeUnit.SECONDS);
        }
        return pingMechanisms;
    }

    private Runnable processCheckerJob(final PingScheduler pingMechanism) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (pingMechanism.pluginProcessChecker.canUse() && !pingMechanism.pluginProcessChecker.isProcessAlive() && !pingMechanism.pingScheduler.isShutdown()) {
                        DumpErrorSingleton.getSingleton().dumpText("Killing self fork JVM. Maven process died." + StringUtils.NL + "Thread dump before killing the process (" + ForkedBooter.getProcessName() + "):" + StringUtils.NL + ForkedBooter.generateThreadDump());
                        ForkedBooter.this.kill();
                    }
                }
                catch (RuntimeException e) {
                    DumpErrorSingleton.getSingleton().dumpException(e, "System.exit() or native command error interrupted process checker.");
                }
            }
        };
    }

    private CommandListener createPingHandler(final AtomicBoolean pingDone) {
        return new CommandListener(){

            @Override
            public void update(Command command) {
                pingDone.set(true);
            }
        };
    }

    private CommandListener createExitHandler(final PpidChecker ppidChecker) {
        return new CommandListener(){

            @Override
            public void update(Command command) {
                Shutdown shutdown = command.toShutdownData();
                if (shutdown.isKill()) {
                    ppidChecker.stop();
                    DumpErrorSingleton.getSingleton().dumpText("Killing self fork JVM. Received SHUTDOWN command from Maven shutdown hook." + StringUtils.NL + "Thread dump before killing the process (" + ForkedBooter.getProcessName() + "):" + StringUtils.NL + ForkedBooter.generateThreadDump());
                    ForkedBooter.this.kill();
                } else if (shutdown.isExit()) {
                    ppidChecker.stop();
                    ForkedBooter.this.cancelPingScheduler();
                    DumpErrorSingleton.getSingleton().dumpText("Exiting self fork JVM. Received SHUTDOWN command from Maven shutdown hook." + StringUtils.NL + "Thread dump before exiting the process (" + ForkedBooter.getProcessName() + "):" + StringUtils.NL + ForkedBooter.generateThreadDump());
                    ForkedBooter.this.exitBarrier.release();
                    ForkedBooter.this.exit1();
                } else {
                    DumpErrorSingleton.getSingleton().dumpText("Thread dump for process (" + ForkedBooter.getProcessName() + "):" + StringUtils.NL + ForkedBooter.generateThreadDump());
                }
            }
        };
    }

    private Runnable createPingJob(final AtomicBoolean pingDone, final PpidChecker pluginProcessChecker) {
        return new Runnable(){

            @Override
            public void run() {
                boolean hasPing;
                if (!ForkedBooter.canUseNewPingMechanism(pluginProcessChecker) && !(hasPing = pingDone.getAndSet(false))) {
                    DumpErrorSingleton.getSingleton().dumpText("Killing self fork JVM. PING timeout elapsed." + StringUtils.NL + "Thread dump before killing the process (" + ForkedBooter.getProcessName() + "):" + StringUtils.NL + ForkedBooter.generateThreadDump());
                    ForkedBooter.this.kill();
                }
            }
        };
    }

    private void kill() {
        this.kill(1);
    }

    private void kill(int returnCode) {
        this.commandReader.stop();
        this.closeForkChannel();
        Runtime.getRuntime().halt(returnCode);
    }

    private void exit1() {
        this.launchLastDitchDaemonShutdownThread(1);
        System.exit(1);
    }

    private void acknowledgedExit() {
        boolean timeoutElapsed;
        this.commandReader.addByeAckListener(new CommandListener(){

            @Override
            public void update(Command command) {
                ForkedBooter.this.exitBarrier.release();
            }
        });
        this.eventChannel.bye();
        this.launchLastDitchDaemonShutdownThread(0);
        long timeoutMillis = Math.max(this.systemExitTimeoutInSeconds * 1000L, 1000L);
        boolean bl = timeoutElapsed = !ForkedBooter.acquireOnePermit(this.exitBarrier, timeoutMillis);
        if (timeoutElapsed && !this.eventChannel.checkError()) {
            this.eventChannel.sendExitError(null, false);
        }
        this.cancelPingScheduler();
        this.commandReader.stop();
        this.closeForkChannel();
        System.exit(0);
    }

    private void runSuitesInProcess() throws TestSetFailedException, InvocationTargetException {
        this.createProviderInCurrentClassloader(this.forkingReporterFactory).invoke(this.testSet);
    }

    private ForkingReporterFactory createForkingReporterFactory() {
        boolean trimStackTrace = this.providerConfiguration.getReporterConfiguration().isTrimStackTrace();
        return new ForkingReporterFactory(trimStackTrace, this.eventChannel);
    }

    private synchronized ScheduledThreadPoolExecutor getJvmTerminator() {
        if (this.jvmTerminator == null) {
            ThreadFactory threadFactory = DaemonThreadFactory.newDaemonThreadFactory(LAST_DITCH_SHUTDOWN_THREAD + this.systemExitTimeoutInSeconds + "s");
            this.jvmTerminator = new ScheduledThreadPoolExecutor(1, threadFactory);
            this.jvmTerminator.setMaximumPoolSize(1);
        }
        return this.jvmTerminator;
    }

    private void launchLastDitchDaemonShutdownThread(final int returnCode) {
        this.getJvmTerminator().schedule(new Runnable(){

            @Override
            public void run() {
                DumpErrorSingleton.getSingleton().dumpText("Thread dump for process (" + ForkedBooter.getProcessName() + ") after " + ForkedBooter.this.systemExitTimeoutInSeconds + " seconds shutdown timeout:" + StringUtils.NL + ForkedBooter.generateThreadDump());
                ForkedBooter.this.kill(returnCode);
            }
        }, this.systemExitTimeoutInSeconds, TimeUnit.SECONDS);
    }

    private SurefireProvider createProviderInCurrentClassloader(ForkingReporterFactory reporterManagerFactory) {
        BaseProviderFactory bpf = new BaseProviderFactory(true);
        bpf.setReporterFactory(reporterManagerFactory);
        bpf.setCommandReader(this.commandReader);
        bpf.setTestRequest(this.providerConfiguration.getTestSuiteDefinition());
        bpf.setReporterConfiguration(this.providerConfiguration.getReporterConfiguration());
        bpf.setForkedChannelEncoder(this.eventChannel);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        bpf.setClassLoaders(classLoader);
        bpf.setTestArtifactInfo(this.providerConfiguration.getTestArtifact());
        bpf.setProviderProperties(this.providerConfiguration.getProviderProperties());
        bpf.setRunOrderParameters(this.providerConfiguration.getRunOrderParameters());
        bpf.setDirectoryScannerParameters(this.providerConfiguration.getDirScannerParams());
        bpf.setMainCliOptions(this.providerConfiguration.getMainCliOptions());
        bpf.setSkipAfterFailureCount(this.providerConfiguration.getSkipAfterFailureCount());
        bpf.setSystemExitTimeout(this.providerConfiguration.getSystemExitTimeout());
        String providerClass = this.startupConfiguration.getActualClassName();
        return (SurefireProvider)ReflectionUtils.instantiateOneArg(classLoader, providerClass, ProviderParameters.class, bpf);
    }

    private void flushEventChannelOnExit() {
        Runnable target = new Runnable(){

            @Override
            public void run() {
                ForkedBooter.this.eventChannel.onJvmExit();
            }
        };
        Thread t = new Thread(target);
        t.setDaemon(true);
        ShutdownHookUtils.addShutDownHook(t);
    }

    private static MasterProcessChannelProcessorFactory lookupDecoderFactory(String channelConfig) {
        MasterProcessChannelProcessorFactory defaultFactory = null;
        MasterProcessChannelProcessorFactory customFactory = null;
        for (MasterProcessChannelProcessorFactory factory : ServiceLoader.load(MasterProcessChannelProcessorFactory.class)) {
            boolean isSurefireFactory;
            Class<?> cls = factory.getClass();
            boolean bl = isSurefireFactory = cls == LegacyMasterProcessChannelProcessorFactory.class || cls == SurefireMasterProcessChannelProcessorFactory.class;
            if (isSurefireFactory) {
                if (!factory.canUse(channelConfig)) continue;
                defaultFactory = factory;
                continue;
            }
            customFactory = factory;
        }
        return customFactory != null ? customFactory : defaultFactory;
    }

    public static void main(String[] args) {
        ForkedBooter booter = new ForkedBooter();
        ForkedBooter.run(booter, args);
    }

    private static void run(ForkedBooter booter, String[] args) {
        try {
            booter.setupBooter(args[0], args[1], args[2], args.length > 3 ? args[3] : null);
            booter.execute();
        }
        catch (Throwable t) {
            DumpErrorSingleton.getSingleton().dumpException(t);
            t.printStackTrace();
            if (booter.eventChannel != null) {
                LegacyPojoStackTraceWriter stack = new LegacyPojoStackTraceWriter("test subsystem", "no method", t);
                booter.eventChannel.consoleErrorLog(stack, false);
            }
            booter.cancelPingScheduler();
            booter.exit1();
        }
    }

    private static boolean canUseNewPingMechanism(PpidChecker pluginProcessChecker) {
        return pluginProcessChecker != null && pluginProcessChecker.canUse();
    }

    private static boolean acquireOnePermit(Semaphore barrier, long timeoutMillis) {
        try {
            return barrier.tryAcquire(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return true;
        }
    }

    private static ScheduledExecutorService createPingScheduler() {
        ThreadFactory threadFactory = DaemonThreadFactory.newDaemonThreadFactory("surefire-forkedjvm-ping-30s");
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, threadFactory);
        executor.setKeepAliveTime(3L, TimeUnit.SECONDS);
        executor.setMaximumPoolSize(2);
        return executor;
    }

    private static InputStream createSurefirePropertiesIfFileExists(String tmpDir, String propFileName) throws FileNotFoundException {
        File surefirePropertiesFile = new File(tmpDir, propFileName);
        return surefirePropertiesFile.exists() ? new FileInputStream(surefirePropertiesFile) : null;
    }

    private static boolean isDebugging() {
        for (String argument : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            if (!"-Xdebug".equals(argument) && !argument.startsWith("-agentlib:jdwp")) continue;
            return true;
        }
        return false;
    }

    private static String generateThreadDump() {
        ThreadInfo[] threadInfos;
        StringBuilder dump = new StringBuilder();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : threadInfos = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), 100)) {
            StackTraceElement[] stackTraceElements;
            dump.append('\"');
            dump.append(threadInfo.getThreadName());
            dump.append("\" ");
            Thread.State state = threadInfo.getThreadState();
            dump.append("\n   java.lang.Thread.State: ");
            dump.append((Object)state);
            for (StackTraceElement stackTraceElement : stackTraceElements = threadInfo.getStackTrace()) {
                dump.append("\n        at ");
                dump.append(stackTraceElement);
            }
            dump.append("\n\n");
        }
        return dump.toString();
    }

    private static String getProcessName() {
        return ManagementFactory.getRuntimeMXBean().getName();
    }

    private static class PingScheduler {
        private final ScheduledExecutorService pingScheduler;
        private final PpidChecker pluginProcessChecker;

        PingScheduler(ScheduledExecutorService pingScheduler, PpidChecker pluginProcessChecker) {
            this.pingScheduler = pingScheduler;
            this.pluginProcessChecker = pluginProcessChecker;
        }

        void shutdown() {
            this.pingScheduler.shutdown();
            if (this.pluginProcessChecker != null) {
                this.pluginProcessChecker.destroyActiveCommands();
            }
        }
    }
}

