/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.writers;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.tinylog.Level;
import org.tinylog.core.ConfigurationParser;
import org.tinylog.core.LogEntry;
import org.tinylog.core.LogEntryValue;
import org.tinylog.provider.InternalLogger;
import org.tinylog.writers.AbstractFormatPatternWriter;

public final class ConsoleWriter
extends AbstractFormatPatternWriter {
    private final Level errorLevel;

    public ConsoleWriter() {
        this(Collections.emptyMap());
    }

    public ConsoleWriter(Map<String, String> properties) {
        super(properties);
        String[] streams;
        Level levelStream = Level.WARN;
        String stream = this.getStringValue("stream");
        if (stream != null && (streams = stream.split("@", 2)).length == 2) {
            levelStream = ConfigurationParser.parse(streams[1], levelStream);
            if (!streams[0].equals("err")) {
                InternalLogger.log(Level.ERROR, "Stream with level must be \"err\", \"" + streams[0] + "\" is an invalid name");
            }
            stream = null;
        }
        if (stream == null) {
            this.errorLevel = levelStream;
        } else if ("err".equalsIgnoreCase(stream)) {
            this.errorLevel = Level.TRACE;
        } else if ("out".equalsIgnoreCase(stream)) {
            this.errorLevel = Level.OFF;
        } else {
            InternalLogger.log(Level.ERROR, "Stream must be \"out\" or \"err\", \"" + stream + "\" is an invalid stream name");
            this.errorLevel = levelStream;
        }
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        Collection<LogEntryValue> logEntryValues = super.getRequiredLogEntryValues();
        logEntryValues.add(LogEntryValue.LEVEL);
        return logEntryValues;
    }

    @Override
    public void write(LogEntry logEntry) {
        if (logEntry.getLevel().ordinal() < this.errorLevel.ordinal()) {
            System.out.print(this.render(logEntry));
        } else {
            System.err.print(this.render(logEntry));
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

