/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.surefire.AbstractSurefireMojo;
import org.apache.maven.plugin.surefire.CommonReflector;
import org.apache.maven.plugin.surefire.StartupReportConfiguration;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.SurefireProperties;
import org.apache.maven.plugin.surefire.booterclient.BooterSerializer;
import org.apache.maven.plugin.surefire.booterclient.ForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.ForkNumberBucket;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.AbstractCommandReader;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.NotifiableTestStream;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.OutputStreamFlushableCommandline;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.TestLessInputStream;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.TestProvidingInputStream;
import org.apache.maven.plugin.surefire.booterclient.output.ForkClient;
import org.apache.maven.plugin.surefire.booterclient.output.InPluginProcessDumpSingleton;
import org.apache.maven.plugin.surefire.booterclient.output.NativeStdErrStreamConsumer;
import org.apache.maven.plugin.surefire.booterclient.output.ThreadedStreamConsumer;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.report.DefaultReporterFactory;
import org.apache.maven.surefire.api.booter.Shutdown;
import org.apache.maven.surefire.api.cli.CommandLineOption;
import org.apache.maven.surefire.api.provider.SurefireProvider;
import org.apache.maven.surefire.api.report.StackTraceWriter;
import org.apache.maven.surefire.api.suite.RunResult;
import org.apache.maven.surefire.api.testset.TestRequest;
import org.apache.maven.surefire.api.util.DefaultScanResult;
import org.apache.maven.surefire.api.util.internal.ConcurrencyUtils;
import org.apache.maven.surefire.api.util.internal.DaemonThreadFactory;
import org.apache.maven.surefire.api.util.internal.StringUtils;
import org.apache.maven.surefire.booter.AbstractPathConfiguration;
import org.apache.maven.surefire.booter.PropertiesWrapper;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.ProviderFactory;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.booter.SystemPropertyManager;
import org.apache.maven.surefire.extensions.CloseableDaemonThread;
import org.apache.maven.surefire.extensions.ForkChannel;
import org.apache.maven.surefire.extensions.ForkNodeArguments;
import org.apache.maven.surefire.extensions.ForkNodeFactory;
import org.apache.maven.surefire.extensions.util.CommandlineExecutor;
import org.apache.maven.surefire.extensions.util.CommandlineStreams;
import org.apache.maven.surefire.extensions.util.CountdownCloseable;
import org.apache.maven.surefire.extensions.util.LineConsumerThread;
import org.apache.maven.surefire.shared.utils.cli.ShutdownHookUtils;

public class ForkStarter {
    private static final String EXECUTION_EXCEPTION = "ExecutionException";
    private static final long PING_IN_SECONDS = 10L;
    private static final int TIMEOUT_CHECK_PERIOD_MILLIS = 100;
    private static final ThreadFactory FORKED_JVM_DAEMON_THREAD_FACTORY = DaemonThreadFactory.newDaemonThreadFactory("surefire-fork-starter");
    private static final ThreadFactory SHUTDOWN_HOOK_THREAD_FACTORY = DaemonThreadFactory.newDaemonThreadFactory("surefire-jvm-killer-shutdownhook");
    private static final AtomicInteger SYSTEM_PROPERTIES_FILE_COUNTER = new AtomicInteger();
    private final Set<String> logsAtEnd = new ConcurrentSkipListSet<String>();
    private final ScheduledExecutorService pingThreadScheduler = ForkStarter.createPingScheduler();
    private final ScheduledExecutorService timeoutCheckScheduler;
    private final Queue<ForkClient> currentForkClients;
    private final int forkedProcessTimeoutInSeconds;
    private final ProviderConfiguration providerConfiguration;
    private final StartupConfiguration startupConfiguration;
    private final ForkConfiguration forkConfiguration;
    private final StartupReportConfiguration startupReportConfiguration;
    private final ConsoleLogger log;
    private final DefaultReporterFactory defaultReporterFactory;
    private final Collection<DefaultReporterFactory> defaultReporterFactories;

    public ForkStarter(ProviderConfiguration providerConfiguration, StartupConfiguration startupConfiguration, ForkConfiguration forkConfiguration, int forkedProcessTimeoutInSeconds, StartupReportConfiguration startupReportConfiguration, ConsoleLogger log) {
        this.forkConfiguration = forkConfiguration;
        this.providerConfiguration = providerConfiguration;
        this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
        this.startupConfiguration = startupConfiguration;
        this.startupReportConfiguration = startupReportConfiguration;
        this.log = log;
        this.defaultReporterFactory = new DefaultReporterFactory(startupReportConfiguration, log);
        this.defaultReporterFactory.runStarting();
        this.defaultReporterFactories = new ConcurrentLinkedQueue<DefaultReporterFactory>();
        this.currentForkClients = new ConcurrentLinkedQueue<ForkClient>();
        this.timeoutCheckScheduler = ForkStarter.createTimeoutCheckScheduler();
        this.triggerTimeoutCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunResult run(@Nonnull SurefireProperties effectiveSystemProperties, @Nonnull DefaultScanResult scanResult) throws SurefireBooterForkException {
        try {
            Map<String, String> providerProperties = this.providerConfiguration.getProviderProperties();
            scanResult.writeTo(providerProperties);
            RunResult runResult = this.isForkOnce() ? this.run(effectiveSystemProperties, providerProperties) : this.run(effectiveSystemProperties);
            return runResult;
        }
        finally {
            this.defaultReporterFactory.mergeFromOtherFactories(this.defaultReporterFactories);
            this.defaultReporterFactory.close();
            this.pingThreadScheduler.shutdownNow();
            this.timeoutCheckScheduler.shutdownNow();
            for (String line : this.logsAtEnd) {
                this.log.warning(line);
            }
        }
    }

    public void killOrphanForks() {
        for (ForkClient fork : this.currentForkClients) {
            fork.kill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunResult run(SurefireProperties effectiveSystemProperties, Map<String, String> providerProperties) throws SurefireBooterForkException {
        TestLessInputStream.TestLessInputStreamBuilder builder = new TestLessInputStream.TestLessInputStreamBuilder();
        PropertiesWrapper props = new PropertiesWrapper(providerProperties);
        TestLessInputStream stream = builder.build();
        Thread shutdown = ForkStarter.createImmediateShutdownHookThread(builder, this.providerConfiguration.getShutdown());
        ScheduledFuture<?> ping = this.triggerPingTimerForShutdown(builder);
        int forkNumber = ForkNumberBucket.drawNumber();
        try {
            ShutdownHookUtils.addShutDownHook(shutdown);
            DefaultReporterFactory forkedReporterFactory = new DefaultReporterFactory(this.startupReportConfiguration, this.log, forkNumber);
            this.defaultReporterFactories.add(forkedReporterFactory);
            ForkClient forkClient = new ForkClient(forkedReporterFactory, stream, forkNumber);
            RunResult runResult = this.fork(null, props, forkClient, effectiveSystemProperties, forkNumber, stream, this.forkConfiguration.getForkNodeFactory(), false);
            return runResult;
        }
        finally {
            ForkNumberBucket.returnNumber(forkNumber);
            ShutdownHookUtils.removeShutdownHook(shutdown);
            ping.cancel(true);
            builder.removeStream(stream);
        }
    }

    private RunResult run(SurefireProperties effectiveSystemProperties) throws SurefireBooterForkException {
        return this.forkConfiguration.isReuseForks() ? this.runSuitesForkOnceMultiple(effectiveSystemProperties, this.forkConfiguration.getForkCount()) : this.runSuitesForkPerTestSet(effectiveSystemProperties, this.forkConfiguration.getForkCount());
    }

    private boolean isForkOnce() {
        return this.forkConfiguration.isReuseForks() && (this.forkConfiguration.getForkCount() == 1 || this.hasSuiteXmlFiles());
    }

    private boolean hasSuiteXmlFiles() {
        TestRequest testSuiteDefinition = this.providerConfiguration.getTestSuiteDefinition();
        return testSuiteDefinition != null && !testSuiteDefinition.getSuiteXmlFiles().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunResult runSuitesForkOnceMultiple(final SurefireProperties effectiveSystemProperties, int forkCount) throws SurefireBooterForkException {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(forkCount, forkCount, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(forkCount));
        executorService.setThreadFactory(FORKED_JVM_DAEMON_THREAD_FACTORY);
        ConcurrentLinkedQueue<String> tests = new ConcurrentLinkedQueue<String>();
        for (Class<?> clazz : this.getSuitesIterator()) {
            tests.add(clazz.getName());
        }
        final ConcurrentLinkedQueue<TestProvidingInputStream> testStreams = new ConcurrentLinkedQueue<TestProvidingInputStream>();
        int total = StrictMath.min(forkCount, tests.size());
        for (int forkNum = 0; forkNum < total; ++forkNum) {
            testStreams.add(new TestProvidingInputStream(tests));
        }
        ScheduledFuture<?> ping = this.triggerPingTimerForShutdown(testStreams);
        Thread shutdown = ForkStarter.createShutdownHookThread(testStreams, this.providerConfiguration.getShutdown());
        try {
            ShutdownHookUtils.addShutDownHook(shutdown);
            int failFastCount = this.providerConfiguration.getSkipAfterFailureCount();
            final AtomicInteger notifyStreamsToSkipTestsJustNow = new AtomicInteger(failFastCount);
            ArrayList<Future<RunResult>> results = new ArrayList<Future<RunResult>>(forkCount);
            for (final TestProvidingInputStream testProvidingInputStream : testStreams) {
                Callable<RunResult> pf = new Callable<RunResult>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public RunResult call() throws Exception {
                        int forkNumber = ForkNumberBucket.drawNumber();
                        DefaultReporterFactory reporter = new DefaultReporterFactory(ForkStarter.this.startupReportConfiguration, ForkStarter.this.log, forkNumber);
                        ForkStarter.this.defaultReporterFactories.add(reporter);
                        ForkClient forkClient = new ForkClient(reporter, testProvidingInputStream, forkNumber){

                            @Override
                            protected void stopOnNextTest() {
                                if (ConcurrencyUtils.countDownToZero(notifyStreamsToSkipTestsJustNow)) {
                                    ForkStarter.notifyStreamsToSkipTests(testStreams);
                                }
                            }
                        };
                        Map<String, String> providerProperties = ForkStarter.this.providerConfiguration.getProviderProperties();
                        try {
                            RunResult runResult = ForkStarter.this.fork(null, new PropertiesWrapper(providerProperties), forkClient, effectiveSystemProperties, forkNumber, testProvidingInputStream, ForkStarter.this.forkConfiguration.getForkNodeFactory(), true);
                            return runResult;
                        }
                        finally {
                            ForkNumberBucket.returnNumber(forkNumber);
                        }
                    }
                };
                results.add(executorService.submit(pf));
            }
            RunResult runResult = ForkStarter.awaitResultsDone(results, executorService);
            return runResult;
        }
        finally {
            ShutdownHookUtils.removeShutdownHook(shutdown);
            ping.cancel(true);
            this.closeExecutor(executorService);
        }
    }

    private static void notifyStreamsToSkipTests(Collection<? extends NotifiableTestStream> notifiableTestStreams) {
        for (NotifiableTestStream notifiableTestStream : notifiableTestStreams) {
            notifiableTestStream.skipSinceNextTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunResult runSuitesForkPerTestSet(final SurefireProperties effectiveSystemProperties, int forkCount) throws SurefireBooterForkException {
        ArrayList<Future<RunResult>> results = new ArrayList<Future<RunResult>>(500);
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(forkCount, forkCount, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        executorService.setThreadFactory(FORKED_JVM_DAEMON_THREAD_FACTORY);
        final TestLessInputStream.TestLessInputStreamBuilder builder = new TestLessInputStream.TestLessInputStreamBuilder();
        ScheduledFuture<?> ping = this.triggerPingTimerForShutdown(builder);
        Thread shutdown = ForkStarter.createCachableShutdownHookThread(builder, this.providerConfiguration.getShutdown());
        try {
            ShutdownHookUtils.addShutDownHook(shutdown);
            int failFastCount = this.providerConfiguration.getSkipAfterFailureCount();
            final AtomicInteger notifyStreamsToSkipTestsJustNow = new AtomicInteger(failFastCount);
            for (final Class<?> testSet : this.getSuitesIterator()) {
                Callable<RunResult> pf = new Callable<RunResult>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public RunResult call() throws Exception {
                        int forkNumber = ForkNumberBucket.drawNumber();
                        DefaultReporterFactory forkedReporterFactory = new DefaultReporterFactory(ForkStarter.this.startupReportConfiguration, ForkStarter.this.log, forkNumber);
                        ForkStarter.this.defaultReporterFactories.add(forkedReporterFactory);
                        TestLessInputStream stream = builder.build();
                        ForkClient forkClient = new ForkClient(forkedReporterFactory, stream, forkNumber){

                            @Override
                            protected void stopOnNextTest() {
                                if (ConcurrencyUtils.countDownToZero(notifyStreamsToSkipTestsJustNow)) {
                                    builder.getCachableCommands().skipSinceNextTest();
                                }
                            }
                        };
                        try {
                            RunResult runResult = ForkStarter.this.fork(testSet, new PropertiesWrapper(ForkStarter.this.providerConfiguration.getProviderProperties()), forkClient, effectiveSystemProperties, forkNumber, stream, ForkStarter.this.forkConfiguration.getForkNodeFactory(), false);
                            return runResult;
                        }
                        finally {
                            ForkNumberBucket.returnNumber(forkNumber);
                            builder.removeStream(stream);
                        }
                    }
                };
                results.add(executorService.submit(pf));
            }
            RunResult runResult = ForkStarter.awaitResultsDone(results, executorService);
            return runResult;
        }
        finally {
            ShutdownHookUtils.removeShutdownHook(shutdown);
            ping.cancel(true);
            this.closeExecutor(executorService);
        }
    }

    private static RunResult awaitResultsDone(Collection<Future<RunResult>> results, ExecutorService executorService) throws SurefireBooterForkException {
        RunResult globalResult = new RunResult(0, 0, 0, 0);
        SurefireBooterForkException exception = null;
        for (Future<RunResult> result : results) {
            try {
                RunResult cur = result.get();
                if (cur != null) {
                    globalResult = globalResult.aggregate(cur);
                    continue;
                }
                throw new SurefireBooterForkException("No results for " + result.toString());
            }
            catch (InterruptedException e) {
                executorService.shutdownNow();
                Thread.currentThread().interrupt();
                throw new SurefireBooterForkException("Interrupted", e);
            }
            catch (ExecutionException e) {
                Throwable realException = e.getCause();
                if (realException == null) {
                    if (exception != null) continue;
                    exception = new SurefireBooterForkException(EXECUTION_EXCEPTION);
                    continue;
                }
                String previousError = "";
                if (exception != null && !EXECUTION_EXCEPTION.equals(exception.getLocalizedMessage().trim())) {
                    previousError = exception.getLocalizedMessage() + "\n";
                }
                String error = previousError + EXECUTION_EXCEPTION + " " + realException.getLocalizedMessage();
                exception = new SurefireBooterForkException(error, realException);
            }
        }
        if (exception != null) {
            throw exception;
        }
        return globalResult;
    }

    private void closeExecutor(ExecutorService executorService) throws SurefireBooterForkException {
        executorService.shutdown();
        try {
            executorService.awaitTermination(3600L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SurefireBooterForkException("Interrupted", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private RunResult fork(Object testSet, PropertiesWrapper providerProperties, ForkClient forkClient, SurefireProperties effectiveSystemProperties, int forkNumber, AbstractCommandReader commandReader, ForkNodeFactory forkNodeFactory, boolean readTestsFromInStream) throws SurefireBooterForkException {
        RunResult runResult;
        block63: {
            File systPropsFile;
            File surefireProperties;
            String tempDir;
            ForkChannel forkChannel;
            CloseableCloser closer = new CloseableCloser(forkNumber, commandReader);
            File dumpLogDir = SurefireHelper.replaceForkThreadsInPath(this.startupReportConfiguration.getReportsDirectory(), forkNumber);
            try {
                forkChannel = forkNodeFactory.createForkChannel(new ForkedNodeArg(forkNumber, dumpLogDir));
                closer.addCloseable(forkChannel);
                tempDir = this.forkConfiguration.getTempDirectory().getCanonicalPath();
                BooterSerializer booterSerializer = new BooterSerializer(this.forkConfiguration);
                Long pluginPid = this.forkConfiguration.getPluginPlatform().getPluginPid();
                this.log.debug("Determined Maven Process ID " + pluginPid);
                String connectionString = forkChannel.getForkNodeConnectionString();
                this.log.debug("Fork Channel [" + forkNumber + "] connection string '" + connectionString + "' for the implementation " + forkChannel.getClass());
                surefireProperties = booterSerializer.serialize(providerProperties, this.providerConfiguration, this.startupConfiguration, testSet, readTestsFromInStream, pluginPid, forkNumber, connectionString);
                if (effectiveSystemProperties != null) {
                    SurefireProperties filteredProperties = AbstractSurefireMojo.createCopyAndReplaceForkNumPlaceholder(effectiveSystemProperties, forkNumber);
                    systPropsFile = SystemPropertyManager.writePropertiesFile(filteredProperties, this.forkConfiguration.getTempDirectory(), "surefire_" + SYSTEM_PROPERTIES_FILE_COUNTER.getAndIncrement(), this.forkConfiguration.isDebug());
                } else {
                    systPropsFile = null;
                }
            }
            catch (IOException e) {
                throw new SurefireBooterForkException("Error creating properties files for forking", e);
            }
            OutputStreamFlushableCommandline cli = this.forkConfiguration.createCommandLine(this.startupConfiguration, forkNumber, dumpLogDir);
            commandReader.setFlushReceiverProvider(cli);
            cli.createArg().setValue(tempDir);
            cli.createArg().setValue(SurefireHelper.DUMP_FILE_PREFIX + forkNumber);
            cli.createArg().setValue(surefireProperties.getName());
            if (systPropsFile != null) {
                cli.createArg().setValue(systPropsFile.getName());
            }
            ThreadedStreamConsumer eventConsumer = new ThreadedStreamConsumer(forkClient);
            closer.addCloseable(eventConsumer);
            this.log.debug("Forking command line: " + cli);
            Integer result = null;
            runResult = null;
            SurefireBooterForkException booterForkException = null;
            CloseableDaemonThread in = null;
            CloseableDaemonThread out = null;
            CloseableDaemonThread err = null;
            DefaultReporterFactory reporter = forkClient.getDefaultReporterFactory();
            this.currentForkClients.add(forkClient);
            CountdownCloseable countdownCloseable = new CountdownCloseable(eventConsumer, forkChannel.getCountdownCloseablePermits());
            try (CommandlineExecutor exec = new CommandlineExecutor(cli, countdownCloseable);){
                CommandlineStreams streams = exec.execute();
                closer.addCloseable(streams);
                forkChannel.connectToClient();
                this.log.debug("Fork Channel [" + forkNumber + "] connected to the client.");
                in = forkChannel.bindCommandReader(commandReader, streams.getStdInChannel());
                in.start();
                out = forkChannel.bindEventHandler(eventConsumer, countdownCloseable, streams.getStdOutChannel());
                out.start();
                NativeStdErrStreamConsumer errConsumer = new NativeStdErrStreamConsumer(this.log);
                err = new LineConsumerThread("fork-" + forkNumber + "-err-thread", streams.getStdErrChannel(), errConsumer, countdownCloseable);
                err.start();
                result = exec.awaitExit();
                if (forkClient.hadTimeout()) {
                    runResult = RunResult.timeout(reporter.getGlobalRunStatistics().getRunResult());
                } else if (result != 0) {
                    booterForkException = new SurefireBooterForkException("Error occurred in starting fork, check output in log");
                }
            }
            this.log.debug("Closing the fork " + forkNumber + " after " + (forkClient.isSaidGoodBye() ? "saying GoodBye." : "not saying Good Bye."));
            this.currentForkClients.remove(forkClient);
            try {
                Closeable c = forkClient.isSaidGoodBye() ? closer : commandReader;
                c.close();
            }
            catch (IOException e) {
                InPluginProcessDumpSingleton.getSingleton().dumpException(e, e.getLocalizedMessage(), dumpLogDir, forkNumber);
            }
            if (runResult == null) {
                runResult = reporter.getGlobalRunStatistics().getRunResult();
            }
            forkClient.close(runResult.isTimeout());
            if (!runResult.isTimeout()) {
                String detail;
                Throwable cause = booterForkException == null ? null : booterForkException.getCause();
                String string = detail = booterForkException == null ? "" : "\n" + booterForkException.getMessage();
                if (forkClient.isErrorInFork()) {
                    StackTraceWriter errorInFork = forkClient.getErrorInFork();
                    String errorInForkMessage = errorInFork == null ? null : errorInFork.getThrowable().getLocalizedMessage();
                    boolean showStackTrace = this.providerConfiguration.getMainCliOptions().contains((Object)CommandLineOption.SHOW_ERRORS);
                    String stackTrace = errorInForkMessage;
                    if (showStackTrace && errorInFork != null) {
                        stackTrace = stackTrace == null ? "" : stackTrace + StringUtils.NL;
                        stackTrace = stackTrace + errorInFork.writeTrimmedTraceToString();
                    }
                    throw new SurefireBooterForkException("There was an error in the forked process" + detail + (stackTrace == null ? "" : "\n" + stackTrace), cause);
                }
                if (!forkClient.isSaidGoodBye()) {
                    String errorCode = result == null ? "" : "\nProcess Exit Code: " + result;
                    String testsInProgress = forkClient.hasTestsInProgress() ? "\nCrashed tests:" : "";
                    for (String test : forkClient.testsInProgress()) {
                        testsInProgress = testsInProgress + "\n" + test;
                    }
                    throw new SurefireBooterForkException("The forked VM terminated without properly saying goodbye. VM crash or System.exit called?\nCommand was " + cli.toString() + detail + errorCode + testsInProgress, cause);
                }
            }
            if (booterForkException != null) {
                throw booterForkException;
            }
            break block63;
            catch (InterruptedException e) {
                this.log.error("Closing the streams after (InterruptedException) '" + e.getLocalizedMessage() + "'");
                in.disable();
                out.disable();
                err.disable();
                this.log.debug("Closing the fork " + forkNumber + " after " + (forkClient.isSaidGoodBye() ? "saying GoodBye." : "not saying Good Bye."));
                this.currentForkClients.remove(forkClient);
                try {
                    Closeable c = forkClient.isSaidGoodBye() ? closer : commandReader;
                    c.close();
                }
                catch (IOException e2) {
                    InPluginProcessDumpSingleton.getSingleton().dumpException(e2, e2.getLocalizedMessage(), dumpLogDir, forkNumber);
                }
                if (runResult == null) {
                    runResult = reporter.getGlobalRunStatistics().getRunResult();
                }
                forkClient.close(runResult.isTimeout());
                if (!runResult.isTimeout()) {
                    String detail;
                    Throwable cause = booterForkException == null ? null : booterForkException.getCause();
                    String string = detail = booterForkException == null ? "" : "\n" + booterForkException.getMessage();
                    if (forkClient.isErrorInFork()) {
                        StackTraceWriter errorInFork = forkClient.getErrorInFork();
                        String errorInForkMessage = errorInFork == null ? null : errorInFork.getThrowable().getLocalizedMessage();
                        boolean showStackTrace = this.providerConfiguration.getMainCliOptions().contains((Object)CommandLineOption.SHOW_ERRORS);
                        String stackTrace = errorInForkMessage;
                        if (showStackTrace && errorInFork != null) {
                            stackTrace = stackTrace == null ? "" : stackTrace + StringUtils.NL;
                            stackTrace = stackTrace + errorInFork.writeTrimmedTraceToString();
                        }
                        throw new SurefireBooterForkException("There was an error in the forked process" + detail + (stackTrace == null ? "" : "\n" + stackTrace), cause);
                    }
                    if (!forkClient.isSaidGoodBye()) {
                        String errorCode = result == null ? "" : "\nProcess Exit Code: " + result;
                        String testsInProgress = forkClient.hasTestsInProgress() ? "\nCrashed tests:" : "";
                        for (String test : forkClient.testsInProgress()) {
                            testsInProgress = testsInProgress + "\n" + test;
                        }
                        throw new SurefireBooterForkException("The forked VM terminated without properly saying goodbye. VM crash or System.exit called?\nCommand was " + cli.toString() + detail + errorCode + testsInProgress, cause);
                    }
                }
                if (booterForkException != null) {
                    throw booterForkException;
                }
            }
            catch (Exception e2) {
                runResult = RunResult.failure(reporter.getGlobalRunStatistics().getRunResult(), e2);
                String cliErr = e2.getLocalizedMessage();
                Throwable cause = e2.getCause();
                booterForkException = new SurefireBooterForkException("Error while executing forked tests.", cliErr, cause, runResult);
                this.log.debug("Closing the fork " + forkNumber + " after " + (forkClient.isSaidGoodBye() ? "saying GoodBye." : "not saying Good Bye."));
                this.currentForkClients.remove(forkClient);
                try {
                    Closeable c = forkClient.isSaidGoodBye() ? closer : commandReader;
                    c.close();
                }
                catch (IOException e3) {
                    InPluginProcessDumpSingleton.getSingleton().dumpException(e3, e3.getLocalizedMessage(), dumpLogDir, forkNumber);
                }
                if (runResult == null) {
                    runResult = reporter.getGlobalRunStatistics().getRunResult();
                }
                forkClient.close(runResult.isTimeout());
                if (!runResult.isTimeout()) {
                    String detail;
                    Throwable cause2 = booterForkException == null ? null : booterForkException.getCause();
                    String string = detail = booterForkException == null ? "" : "\n" + booterForkException.getMessage();
                    if (forkClient.isErrorInFork()) {
                        StackTraceWriter errorInFork = forkClient.getErrorInFork();
                        String errorInForkMessage = errorInFork == null ? null : errorInFork.getThrowable().getLocalizedMessage();
                        boolean showStackTrace = this.providerConfiguration.getMainCliOptions().contains((Object)CommandLineOption.SHOW_ERRORS);
                        String stackTrace = errorInForkMessage;
                        if (showStackTrace && errorInFork != null) {
                            stackTrace = stackTrace == null ? "" : stackTrace + StringUtils.NL;
                            stackTrace = stackTrace + errorInFork.writeTrimmedTraceToString();
                        }
                        throw new SurefireBooterForkException("There was an error in the forked process" + detail + (stackTrace == null ? "" : "\n" + stackTrace), cause2);
                    }
                    if (!forkClient.isSaidGoodBye()) {
                        String errorCode = result == null ? "" : "\nProcess Exit Code: " + result;
                        String testsInProgress = forkClient.hasTestsInProgress() ? "\nCrashed tests:" : "";
                        for (String test : forkClient.testsInProgress()) {
                            testsInProgress = testsInProgress + "\n" + test;
                        }
                        throw new SurefireBooterForkException("The forked VM terminated without properly saying goodbye. VM crash or System.exit called?\nCommand was " + cli.toString() + detail + errorCode + testsInProgress, cause2);
                    }
                }
                if (booterForkException != null) {
                    throw booterForkException;
                }
                {
                    catch (Throwable throwable) {
                        this.log.debug("Closing the fork " + forkNumber + " after " + (forkClient.isSaidGoodBye() ? "saying GoodBye." : "not saying Good Bye."));
                        this.currentForkClients.remove(forkClient);
                        try {
                            Closeable c = forkClient.isSaidGoodBye() ? closer : commandReader;
                            c.close();
                        }
                        catch (IOException e4) {
                            InPluginProcessDumpSingleton.getSingleton().dumpException(e4, e4.getLocalizedMessage(), dumpLogDir, forkNumber);
                        }
                        if (runResult == null) {
                            runResult = reporter.getGlobalRunStatistics().getRunResult();
                        }
                        forkClient.close(runResult.isTimeout());
                        if (!runResult.isTimeout()) {
                            String detail;
                            Throwable cause3 = booterForkException == null ? null : booterForkException.getCause();
                            String string = detail = booterForkException == null ? "" : "\n" + booterForkException.getMessage();
                            if (forkClient.isErrorInFork()) {
                                StackTraceWriter errorInFork = forkClient.getErrorInFork();
                                String errorInForkMessage = errorInFork == null ? null : errorInFork.getThrowable().getLocalizedMessage();
                                boolean showStackTrace = this.providerConfiguration.getMainCliOptions().contains((Object)CommandLineOption.SHOW_ERRORS);
                                String stackTrace = errorInForkMessage;
                                if (showStackTrace && errorInFork != null) {
                                    stackTrace = stackTrace == null ? "" : stackTrace + StringUtils.NL;
                                    stackTrace = stackTrace + errorInFork.writeTrimmedTraceToString();
                                }
                                throw new SurefireBooterForkException("There was an error in the forked process" + detail + (stackTrace == null ? "" : "\n" + stackTrace), cause3);
                            }
                            if (!forkClient.isSaidGoodBye()) {
                                String errorCode = result == null ? "" : "\nProcess Exit Code: " + result;
                                String testsInProgress = forkClient.hasTestsInProgress() ? "\nCrashed tests:" : "";
                                for (String test : forkClient.testsInProgress()) {
                                    testsInProgress = testsInProgress + "\n" + test;
                                }
                                throw new SurefireBooterForkException("The forked VM terminated without properly saying goodbye. VM crash or System.exit called?\nCommand was " + cli.toString() + detail + errorCode + testsInProgress, cause3);
                            }
                        }
                        if (booterForkException != null) {
                            throw booterForkException;
                        }
                        throw throwable;
                    }
                }
            }
        }
        return runResult;
    }

    private Iterable<Class<?>> getSuitesIterator() throws SurefireBooterForkException {
        try {
            AbstractPathConfiguration classpathConfiguration = this.startupConfiguration.getClasspathConfiguration();
            ClassLoader unifiedClassLoader = classpathConfiguration.createMergedClassLoader();
            CommonReflector commonReflector = new CommonReflector(unifiedClassLoader);
            Object reporterFactory = commonReflector.createReportingReporterFactory(this.startupReportConfiguration, this.log);
            ProviderFactory providerFactory = new ProviderFactory(this.startupConfiguration, this.providerConfiguration, unifiedClassLoader, reporterFactory);
            SurefireProvider surefireProvider = providerFactory.createProvider(false);
            return surefireProvider.getSuites();
        }
        catch (SurefireExecutionException e) {
            throw new SurefireBooterForkException("Unable to create classloader to find test suites", e);
        }
    }

    private static Thread createImmediateShutdownHookThread(final TestLessInputStream.TestLessInputStreamBuilder builder, final Shutdown shutdownType) {
        return SHUTDOWN_HOOK_THREAD_FACTORY.newThread(new Runnable(){

            @Override
            public void run() {
                builder.getImmediateCommands().shutdown(shutdownType);
            }
        });
    }

    private static Thread createCachableShutdownHookThread(final TestLessInputStream.TestLessInputStreamBuilder builder, final Shutdown shutdownType) {
        return SHUTDOWN_HOOK_THREAD_FACTORY.newThread(new Runnable(){

            @Override
            public void run() {
                builder.getCachableCommands().shutdown(shutdownType);
            }
        });
    }

    private static Thread createShutdownHookThread(final Iterable<TestProvidingInputStream> streams, final Shutdown shutdownType) {
        return SHUTDOWN_HOOK_THREAD_FACTORY.newThread(new Runnable(){

            @Override
            public void run() {
                for (TestProvidingInputStream stream : streams) {
                    stream.shutdown(shutdownType);
                }
            }
        });
    }

    private static ScheduledExecutorService createPingScheduler() {
        ThreadFactory threadFactory = DaemonThreadFactory.newDaemonThreadFactory("ping-timer-10s");
        return Executors.newScheduledThreadPool(1, threadFactory);
    }

    private static ScheduledExecutorService createTimeoutCheckScheduler() {
        ThreadFactory threadFactory = DaemonThreadFactory.newDaemonThreadFactory("timeout-check-timer");
        return Executors.newScheduledThreadPool(1, threadFactory);
    }

    private ScheduledFuture<?> triggerPingTimerForShutdown(final TestLessInputStream.TestLessInputStreamBuilder builder) {
        return this.pingThreadScheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                builder.getImmediateCommands().noop();
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    private ScheduledFuture<?> triggerPingTimerForShutdown(final Iterable<TestProvidingInputStream> streams) {
        return this.pingThreadScheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                for (TestProvidingInputStream stream : streams) {
                    stream.noop();
                }
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    private ScheduledFuture<?> triggerTimeoutCheck() {
        return this.timeoutCheckScheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                long systemTime = System.currentTimeMillis();
                for (ForkClient forkClient : ForkStarter.this.currentForkClients) {
                    forkClient.tryToTimeout(systemTime, ForkStarter.this.forkedProcessTimeoutInSeconds);
                }
            }
        }, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    private final class ForkedNodeArg
    implements ForkNodeArguments {
        private final int forkChannelId;
        private final File dumpLogDir;

        ForkedNodeArg(int forkChannelId, File dumpLogDir) {
            this.forkChannelId = forkChannelId;
            this.dumpLogDir = dumpLogDir;
        }

        @Override
        public int getForkChannelId() {
            return this.forkChannelId;
        }

        @Override
        @Nonnull
        public File dumpStreamText(@Nonnull String text) {
            return InPluginProcessDumpSingleton.getSingleton().dumpStreamText(text, this.dumpLogDir, this.forkChannelId);
        }

        @Override
        public void logWarningAtEnd(@Nonnull String text) {
            ForkStarter.this.logsAtEnd.add(text);
        }

        @Override
        @Nonnull
        public ConsoleLogger getConsoleLogger() {
            return ForkStarter.this.log;
        }
    }

    private final class CloseableCloser
    implements Runnable,
    Closeable {
        private final int jvmRun;
        private final Queue<Closeable> testProvidingInputStream;
        private final Thread inputStreamCloserHook;

        CloseableCloser(int jvmRun, Closeable ... testProvidingInputStream) {
            this.jvmRun = jvmRun;
            this.testProvidingInputStream = new ConcurrentLinkedQueue<Closeable>();
            Collections.addAll(this.testProvidingInputStream, testProvidingInputStream);
            if (this.testProvidingInputStream.isEmpty()) {
                this.inputStreamCloserHook = null;
            } else {
                this.inputStreamCloserHook = DaemonThreadFactory.newDaemonThread(this, "closer-shutdown-hook");
                ShutdownHookUtils.addShutDownHook(this.inputStreamCloserHook);
            }
        }

        @Override
        public void run() {
            Closeable closeable;
            while ((closeable = this.testProvidingInputStream.poll()) != null) {
                try {
                    closeable.close();
                }
                catch (IOException | RuntimeException e) {
                    String msg = "ForkStarter IOException: " + e.getLocalizedMessage() + ".";
                    File reportsDir = ForkStarter.this.defaultReporterFactory.getReportsDirectory();
                    File dump = InPluginProcessDumpSingleton.getSingleton().dumpStreamException(e, msg, reportsDir, this.jvmRun);
                    ForkStarter.this.log.warning(msg + " See the dump file " + dump.getAbsolutePath());
                }
            }
        }

        @Override
        public void close() {
            try {
                this.run();
            }
            finally {
                this.testProvidingInputStream.clear();
                if (this.inputStreamCloserHook != null) {
                    ShutdownHookUtils.removeShutdownHook(this.inputStreamCloserHook);
                }
            }
        }

        void addCloseable(Closeable closeable) {
            this.testProvidingInputStream.add(closeable);
        }
    }
}

