/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.extensions;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.surefire.booterclient.output.NativeStdOutStreamConsumer;
import org.apache.maven.plugin.surefire.extensions.EventConsumerThread;
import org.apache.maven.plugin.surefire.extensions.StreamFeeder;
import org.apache.maven.surefire.api.event.Event;
import org.apache.maven.surefire.api.util.internal.Channels;
import org.apache.maven.surefire.api.util.internal.DaemonThreadFactory;
import org.apache.maven.surefire.extensions.CloseableDaemonThread;
import org.apache.maven.surefire.extensions.CommandReader;
import org.apache.maven.surefire.extensions.EventHandler;
import org.apache.maven.surefire.extensions.ForkChannel;
import org.apache.maven.surefire.extensions.ForkNodeArguments;
import org.apache.maven.surefire.extensions.util.CountdownCloseable;
import org.apache.maven.surefire.extensions.util.LineConsumerThread;

final class SurefireForkChannel
extends ForkChannel {
    private static final ExecutorService THREAD_POOL = Executors.newCachedThreadPool(DaemonThreadFactory.newDaemonThreadFactory());
    private final AsynchronousServerSocketChannel server = AsynchronousServerSocketChannel.open(AsynchronousChannelGroup.withThreadPool(THREAD_POOL));
    private final String localHost;
    private final int localPort;
    private volatile AsynchronousSocketChannel worker;
    private volatile LineConsumerThread out;

    SurefireForkChannel(@Nonnull ForkNodeArguments arguments) throws IOException {
        super(arguments);
        this.setTrueOptions(StandardSocketOptions.SO_REUSEADDR, StandardSocketOptions.TCP_NODELAY, StandardSocketOptions.SO_KEEPALIVE);
        InetAddress ip = Inet4Address.getLocalHost();
        this.server.bind(new InetSocketAddress(ip, 0), 1);
        InetSocketAddress localAddress = (InetSocketAddress)this.server.getLocalAddress();
        this.localHost = localAddress.getHostString();
        this.localPort = localAddress.getPort();
    }

    @Override
    public void connectToClient() throws IOException {
        if (this.worker != null) {
            throw new IllegalStateException("already accepted TCP client connection");
        }
        try {
            this.worker = this.server.accept().get();
        }
        catch (InterruptedException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getLocalizedMessage(), e.getCause());
        }
    }

    @SafeVarargs
    private final void setTrueOptions(SocketOption<Boolean> ... options) throws IOException {
        for (SocketOption<Boolean> option : options) {
            if (!this.server.supportedOptions().contains(option)) continue;
            this.server.setOption((SocketOption)option, (Object)true);
        }
    }

    @Override
    public String getForkNodeConnectionString() {
        return "tcp://" + this.localHost + ":" + this.localPort;
    }

    @Override
    public int getCountdownCloseablePermits() {
        return 3;
    }

    @Override
    public CloseableDaemonThread bindCommandReader(@Nonnull CommandReader commands, WritableByteChannel stdIn) {
        WritableByteChannel channel = Channels.newChannel(Channels.newOutputStream(this.worker));
        return new StreamFeeder("commands-fork-" + this.getArguments().getForkChannelId(), channel, commands, this.getArguments().getConsoleLogger());
    }

    @Override
    public CloseableDaemonThread bindEventHandler(@Nonnull EventHandler<Event> eventHandler, @Nonnull CountdownCloseable countdownCloseable, ReadableByteChannel stdOut) {
        this.out = new LineConsumerThread("fork-" + this.getArguments().getForkChannelId() + "-out-thread", stdOut, new NativeStdOutStreamConsumer(this.getArguments().getConsoleLogger()), countdownCloseable);
        this.out.start();
        ReadableByteChannel channel = Channels.newBufferedChannel(Channels.newInputStream(this.worker));
        return new EventConsumerThread("fork-" + this.getArguments().getForkChannelId() + "-event-thread", channel, eventHandler, countdownCloseable, this.getArguments());
    }

    @Override
    public void close() throws IOException {
        try (AsynchronousSocketChannel c1 = this.worker;
             AsynchronousServerSocketChannel c2 = this.server;){
            LineConsumerThread c3 = this.out;
            Throwable throwable = null;
            if (c3 != null) {
                if (throwable != null) {
                    try {
                        c3.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    c3.close();
                }
            }
        }
    }
}

