/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.surefire.util.ScannerUtil;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.apache.maven.surefire.api.testset.TestFilter;
import org.apache.maven.surefire.api.testset.TestListResolver;
import org.apache.maven.surefire.api.util.DefaultScanResult;

public class DependencyScanner {
    private final List<File> dependenciesToScan;
    private final TestListResolver filter;

    public DependencyScanner(List<File> dependenciesToScan, TestListResolver filter) {
        this.dependenciesToScan = dependenciesToScan;
        this.filter = filter;
    }

    public DefaultScanResult scan() throws MojoExecutionException {
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        for (File artifact : this.dependenciesToScan) {
            if (artifact == null || !artifact.isFile() || !artifact.getName().endsWith(".jar")) continue;
            try {
                DependencyScanner.scanArtifact(artifact, this.filter, classes);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not scan dependency " + artifact.toString(), e);
            }
        }
        return new DefaultScanResult(new ArrayList<String>(classes));
    }

    private static void scanArtifact(File artifact, TestFilter<String, String> filter, Set<String> classes) throws IOException {
        try (JarFile jar = new JarFile(artifact);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String path = entry.getName();
                if (entry.isDirectory() || !ScannerUtil.isJavaClassFile(path) || !filter.shouldRun(path, null)) continue;
                classes.add(ScannerUtil.convertJarFileResourceToJavaClassName(path));
            }
        }
    }

    public static List<Artifact> filter(List<Artifact> artifacts, List<String> artifactPatterns) {
        if (artifactPatterns == null || artifacts == null || artifacts.isEmpty()) {
            return Collections.emptyList();
        }
        PatternIncludesArtifactFilter artifactFilter = new PatternIncludesArtifactFilter(artifactPatterns);
        ArrayList<Artifact> matches = new ArrayList<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!artifactFilter.include(artifact)) continue;
            matches.add(artifact);
        }
        return matches;
    }
}

