/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.artifact.resolve.internal;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

@Component(role=ArtifactResolver.class, hint="default")
class DefaultArtifactResolver
implements ArtifactResolver,
Contextualizable {
    private PlexusContainer container;

    DefaultArtifactResolver() {
    }

    @Override
    public ArtifactResult resolveArtifact(ProjectBuildingRequest buildingRequest, Artifact mavenArtifact) throws ArtifactResolverException, IllegalArgumentException {
        this.validateParameters(buildingRequest, mavenArtifact);
        try {
            String hint = this.isMaven31() ? "maven31" : "maven3";
            ArtifactResolver effectiveArtifactResolver = this.container.lookup(ArtifactResolver.class, hint);
            return effectiveArtifactResolver.resolveArtifact(buildingRequest, mavenArtifact);
        }
        catch (ComponentLookupException e) {
            throw new ArtifactResolverException(e.getMessage(), e);
        }
    }

    @Override
    public ArtifactResult resolveArtifact(ProjectBuildingRequest buildingRequest, ArtifactCoordinate coordinate) throws ArtifactResolverException, IllegalArgumentException {
        this.validateParameters(buildingRequest, coordinate);
        try {
            String hint = this.isMaven31() ? "maven31" : "maven3";
            ArtifactResolver effectiveArtifactResolver = this.container.lookup(ArtifactResolver.class, hint);
            return effectiveArtifactResolver.resolveArtifact(buildingRequest, coordinate);
        }
        catch (ComponentLookupException e) {
            throw new ArtifactResolverException(e.getMessage(), e);
        }
    }

    private void validateParameters(ProjectBuildingRequest buildingRequest, Artifact mavenArtifact) {
        if (buildingRequest == null) {
            throw new IllegalArgumentException("The parameter buildingRequest is not allowed to be null.");
        }
        if (mavenArtifact == null) {
            throw new IllegalArgumentException("The parameter mavenArtifact is not allowed to be null.");
        }
    }

    private void validateParameters(ProjectBuildingRequest buildingRequest, ArtifactCoordinate coordinate) {
        if (buildingRequest == null) {
            throw new IllegalArgumentException("The parameter buildingRequest is not allowed to be null.");
        }
        if (coordinate == null) {
            throw new IllegalArgumentException("The parameter coordinate is not allowed to be null.");
        }
    }

    private boolean isMaven31() {
        return this.canFindCoreClass("org.eclipse.aether.artifact.Artifact");
    }

    private boolean canFindCoreClass(String className) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get("plexus");
    }
}

