/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter.spi;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.ExecutionException;
import org.apache.maven.surefire.api.booter.MasterProcessChannelDecoder;
import org.apache.maven.surefire.api.booter.MasterProcessChannelEncoder;
import org.apache.maven.surefire.api.util.internal.Channels;
import org.apache.maven.surefire.api.util.internal.DaemonThreadFactory;
import org.apache.maven.surefire.booter.spi.LegacyMasterProcessChannelDecoder;
import org.apache.maven.surefire.booter.spi.LegacyMasterProcessChannelEncoder;
import org.apache.maven.surefire.spi.MasterProcessChannelProcessorFactory;

public class SurefireMasterProcessChannelProcessorFactory
implements MasterProcessChannelProcessorFactory {
    private volatile AsynchronousSocketChannel clientSocketChannel;

    @Override
    public boolean canUse(String channelConfig) {
        return channelConfig.startsWith("tcp://");
    }

    @Override
    public void connect(String channelConfig) throws IOException {
        if (!this.canUse(channelConfig)) {
            throw new MalformedURLException("Unknown chanel string " + channelConfig);
        }
        try {
            URI uri = new URI(channelConfig);
            InetSocketAddress hostAddress = new InetSocketAddress(uri.getHost(), uri.getPort());
            this.clientSocketChannel = AsynchronousSocketChannel.open(AsynchronousChannelGroup.withFixedThreadPool(2, DaemonThreadFactory.newDaemonThreadFactory()));
            this.setTrueOptions(StandardSocketOptions.SO_REUSEADDR, StandardSocketOptions.TCP_NODELAY, StandardSocketOptions.SO_KEEPALIVE);
            this.clientSocketChannel.connect(hostAddress).get();
        }
        catch (InterruptedException | URISyntaxException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getLocalizedMessage(), e.getCause());
        }
    }

    @Override
    public MasterProcessChannelDecoder createDecoder() {
        return new LegacyMasterProcessChannelDecoder(Channels.newBufferedChannel(Channels.newInputStream(this.clientSocketChannel)));
    }

    @Override
    public MasterProcessChannelEncoder createEncoder() {
        return new LegacyMasterProcessChannelEncoder(Channels.newBufferedChannel(Channels.newOutputStream(this.clientSocketChannel)));
    }

    @Override
    public void close() throws IOException {
        if (this.clientSocketChannel != null && this.clientSocketChannel.isOpen()) {
            this.clientSocketChannel.close();
        }
    }

    @SafeVarargs
    private final void setTrueOptions(SocketOption<Boolean> ... options) throws IOException {
        for (SocketOption<Boolean> option : options) {
            if (!this.clientSocketChannel.supportedOptions().contains(option)) continue;
            this.clientSocketChannel.setOption((SocketOption)option, (Object)true);
        }
    }
}

