/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korapxmltools;

import de.ids_mannheim.korapxmltools.AnnotationToolBridgeFactory;
import de.ids_mannheim.korapxmltools.AnnotationWorkerPool;
import de.ids_mannheim.korapxmltools.ColoredFormatter;
import de.ids_mannheim.korapxmltools.KorapXmlToolKt;
import de.ids_mannheim.korapxmltools.NonBmpString;
import de.ids_mannheim.korapxmltools.OutputFormat;
import de.ids_mannheim.korapxmltools.ParserToolBridge;
import de.ids_mannheim.korapxmltools.TaggerToolBridge;
import de.ids_mannheim.korapxmltools.XMLCommentFilterReader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import picocli.CommandLine;

@CommandLine.Command(name="KorapXmlTool", version={"KorapXmlTool 2.0-beta-01"}, mixinStandardHelpOptions=true, description={"Converts KorAP-XML <https://github.com/KorAP/KorAP-XML-Krill#about-korap-xml> base or morpho zips to (annotated) CoNLL(-U) format with all information necessary for reconstruction in comment lines."})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0006\u00c0\u0001\u00c1\u0001\u00c2\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0006H\u0007J\u000e\u0010I\u001a\u0002022\u0006\u0010J\u001a\u00020\u0002J\u0010\u0010P\u001a\u0002022\u0006\u0010Q\u001a\u00020\u0011H\u0007J\u0010\u0010T\u001a\u0002022\u0006\u0010U\u001a\u00020\u0011H\u0007J\r\u0010V\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010WJ\u000b\u0010\u008c\u0001\u001a\u00020\u0006*\u00020\u0011J\r\u0010\u008d\u0001\u001a\u0004\u0018\u00010\u0011*\u00020\u0011J\u001b\u0010\u008e\u0001\u001a\u0002022\r\u0010\u008f\u0001\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\u0010\u0015J)\u0010\u0090\u0001\u001a\b\u0012\u0004\u0012\u00020b0\u00102\u0012\u0010f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020h0gH\u0002\u00a2\u0006\u0003\u0010\u0091\u0001J\u0012\u0010\u0092\u0001\u001a\u00020\u00112\u0007\u0010\u0093\u0001\u001a\u00020\u0011H\u0002J\u001d\u0010\u0094\u0001\u001a\u00020\u00112\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a2\u0006\u0003\u0010\u0095\u0001J\u001d\u0010\u0096\u0001\u001a\u0002022\u0007\u0010\u0097\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u0098\u0001\u001a\u00020\u0011H\u0002J\u001d\u0010\u0099\u0001\u001a\u0002022\u0007\u0010\u0097\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u0098\u0001\u001a\u00020\u0011H\u0002J-\u0010\u009a\u0001\u001a\u0002022\b\u0010\u009b\u0001\u001a\u00030\u009c\u00012\u0007\u0010\u009d\u0001\u001a\u00020\u00112\b\u0010\u009e\u0001\u001a\u00030\u009f\u00012\u0007\u0010\u00a0\u0001\u001a\u00020\u0006J\u001b\u0010\u00a1\u0001\u001a\u0002022\u0007\u0010\u00a2\u0001\u001a\u00020\u00112\u0007\u0010\u0098\u0001\u001a\u00020\u0011H\u0002J\t\u0010\u00a3\u0001\u001a\u00020\u0011H\u0002J!\u0010\u00a4\u0001\u001a\b0\u00a5\u0001j\u0003`\u00a6\u00012\u0007\u0010\u0098\u0001\u001a\u00020\u00112\u0007\u0010\u00a2\u0001\u001a\u00020\u0011H\u0002J!\u0010\u00a7\u0001\u001a\b0\u00a5\u0001j\u0003`\u00a6\u00012\u0007\u0010\u0098\u0001\u001a\u00020\u00112\u0007\u0010\u00a2\u0001\u001a\u00020\u0011H\u0002J!\u0010\u00a8\u0001\u001a\b0\u00a5\u0001j\u0003`\u00a6\u00012\u0007\u0010\u0098\u0001\u001a\u00020\u00112\u0007\u0010\u00a2\u0001\u001a\u00020\u0011H\u0002J!\u0010\u00a9\u0001\u001a\b0\u00a5\u0001j\u0003`\u00a6\u00012\u0007\u0010\u0098\u0001\u001a\u00020\u00112\u0007\u0010\u00a2\u0001\u001a\u00020\u0011H\u0002J\u0018\u0010\u00aa\u0001\u001a\b0\u00a5\u0001j\u0003`\u00a6\u00012\u0007\u0010\u00a2\u0001\u001a\u00020\u0011H\u0002J}\u0010\u00ab\u0001\u001a\u00020\u00112\u0007\u0010\u00ac\u0001\u001a\u00020\u00022\u0007\u0010\u00ad\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u00ae\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u00af\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u00b0\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u00b1\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u00b2\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u00b3\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u00b4\u0001\u001a\u00020\u00112\t\b\u0002\u0010\u00b5\u0001\u001a\u00020\u00112\b\b\u0002\u0010,\u001a\u00020\u0002H\u0002JX\u0010\u00b6\u0001\u001a\u00020\u00112\u0018\u0010a\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020b0\u00100]2\u0007\u0010\u00a2\u0001\u001a\u00020\u00112\u0007\u0010\u00b7\u0001\u001a\u00020\u00022\u0007\u0010\u00ac\u0001\u001a\u00020\u00022\u0018\u0010d\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020b0\u00100]H\u0002J\u001f\u0010\u00b8\u0001\u001a\b\u0012\u0004\u0012\u00020b0\u00102\b\u0010\u00b9\u0001\u001a\u00030\u00ba\u0001H\u0002\u00a2\u0006\u0003\u0010\u00bb\u0001J\u001f\u0010\u00bc\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020h0g2\b\u0010\u00bd\u0001\u001a\u00030\u00ba\u0001H\u0002J\u001f\u0010\u00be\u0001\u001a\b\u0012\u0004\u0012\u00020b0\u00102\b\u0010\u00b9\u0001\u001a\u00030\u00ba\u0001H\u0002\u00a2\u0006\u0003\u0010\u00bb\u0001J\u001f\u0010\u00bf\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110g2\b\u0010\u00b9\u0001\u001a\u00030\u00ba\u0001H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR(\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0017\u001a\u00020\u00188\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR \u0010\u001d\u001a\u0004\u0018\u00010\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001e\u0010\"\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R\u001e\u0010%\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\b\"\u0004\b'\u0010(R\u001e\u0010)\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u001f\"\u0004\b+\u0010!R\u001e\u0010,\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001e\u00104\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u001f\"\u0004\b6\u0010!R\u001e\u00107\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\b\"\u0004\b9\u0010(R\u001e\u0010:\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\b\"\u0004\b<\u0010(R$\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00110>8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u001e\u0010C\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010\u001f\"\u0004\bE\u0010!R\u001e\u0010F\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010.\"\u0004\bH\u00100R\u001e\u0010K\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010\b\"\u0004\bM\u0010(R\u0010\u0010N\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010O\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010R\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010S\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010X\u001a\u00020YX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010Z\u001a\u0004\u0018\u00010[X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020^0]\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010`R#\u0010a\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020b0\u00100]\u00a2\u0006\b\n\u0000\u001a\u0004\bc\u0010`R#\u0010d\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020b0\u00100]\u00a2\u0006\b\n\u0000\u001a\u0004\be\u0010`R)\u0010f\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020h0g0]\u00a2\u0006\b\n\u0000\u001a\u0004\bi\u0010`R\u001d\u0010j\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110]\u00a2\u0006\b\n\u0000\u001a\u0004\bk\u0010`R#\u0010l\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100]\u00a2\u0006\b\n\u0000\u001a\u0004\bm\u0010`R)\u0010n\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110g0]\u00a2\u0006\b\n\u0000\u001a\u0004\bo\u0010`R(\u0010p\u001a\u0010\u0012\u0004\u0012\u00020q\u0012\u0006\u0012\u0004\u0018\u00010r0]X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bs\u0010`\"\u0004\bt\u0010uR(\u0010v\u001a\u0010\u0012\u0004\u0012\u00020q\u0012\u0006\u0012\u0004\u0018\u00010w0]X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bx\u0010`\"\u0004\by\u0010uR\u001c\u0010z\u001a\u0004\u0018\u00010{X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b|\u0010}\"\u0004\b~\u0010\u007fR\"\u0010\u0080\u0001\u001a\u0005\u0018\u00010\u0081\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0082\u0001\u0010\u0083\u0001\"\u0006\b\u0084\u0001\u0010\u0085\u0001R\"\u0010\u0086\u0001\u001a\u0005\u0018\u00010\u0087\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0088\u0001\u0010\u0089\u0001\"\u0006\b\u008a\u0001\u0010\u008b\u0001\u00a8\u0006\u00c3\u0001"}, d2={"Lde/ids_mannheim/korapxmltools/KorapXmlTool;", "Ljava/util/concurrent/Callable;", "", "<init>", "()V", "COMPATIBILITY_MODE", "", "getCOMPATIBILITY_MODE", "()Z", "spec", "Lpicocli/CommandLine$Model$CommandSpec;", "getSpec", "()Lpicocli/CommandLine$Model$CommandSpec;", "setSpec", "(Lpicocli/CommandLine$Model$CommandSpec;)V", "zipFileNames", "", "", "getZipFileNames", "()[Ljava/lang/String;", "setZipFileNames", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "outputFormat", "Lde/ids_mannheim/korapxmltools/OutputFormat;", "getOutputFormat", "()Lde/ids_mannheim/korapxmltools/OutputFormat;", "setOutputFormat", "(Lde/ids_mannheim/korapxmltools/OutputFormat;)V", "siglePattern", "getSiglePattern", "()Ljava/lang/String;", "setSiglePattern", "(Ljava/lang/String;)V", "extractAttributesRegex", "getExtractAttributesRegex", "setExtractAttributesRegex", "sBoundsFromMorpho", "getSBoundsFromMorpho", "setSBoundsFromMorpho", "(Z)V", "logLevel", "getLogLevel", "setLogLevel", "columns", "getColumns", "()I", "setColumns", "(I)V", "setWord2Vec", "", "word2vec", "tokenSeparator", "getTokenSeparator", "setTokenSeparator", "offsets", "getOffsets", "setOffsets", "comments", "getComments", "setComments", "extractMetadataRegex", "", "getExtractMetadataRegex", "()Ljava/util/List;", "setExtractMetadataRegex", "(Ljava/util/List;)V", "annotateWith", "getAnnotateWith", "setAnnotateWith", "maxThreads", "getMaxThreads", "setMaxThreads", "setThreads", "threads", "overwrite", "getOverwrite", "setOverwrite", "taggerName", "taggerModel", "setTagWith", "tagWith", "parserName", "parserModel", "setParseWith", "parseWith", "call", "()Ljava/lang/Integer;", "LOGGER", "Ljava/util/logging/Logger;", "annotationWorkerPool", "Lde/ids_mannheim/korapxmltools/AnnotationWorkerPool;", "texts", "Ljava/util/concurrent/ConcurrentHashMap;", "Lde/ids_mannheim/korapxmltools/NonBmpString;", "getTexts", "()Ljava/util/concurrent/ConcurrentHashMap;", "sentences", "Lde/ids_mannheim/korapxmltools/KorapXmlTool$Span;", "getSentences", "tokens", "getTokens", "morpho", "", "Lde/ids_mannheim/korapxmltools/KorapXmlTool$MorphoSpan;", "getMorpho", "fnames", "getFnames", "metadata", "getMetadata", "extraFeatures", "getExtraFeatures", "taggerToolBridges", "", "Lde/ids_mannheim/korapxmltools/TaggerToolBridge;", "getTaggerToolBridges", "setTaggerToolBridges", "(Ljava/util/concurrent/ConcurrentHashMap;)V", "parserToolBridges", "Lde/ids_mannheim/korapxmltools/ParserToolBridge;", "getParserToolBridges", "setParserToolBridges", "dbFactory", "Ljavax/xml/parsers/DocumentBuilderFactory;", "getDbFactory", "()Ljavax/xml/parsers/DocumentBuilderFactory;", "setDbFactory", "(Ljavax/xml/parsers/DocumentBuilderFactory;)V", "dBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "getDBuilder", "()Ljavax/xml/parsers/DocumentBuilder;", "setDBuilder", "(Ljavax/xml/parsers/DocumentBuilder;)V", "morphoZipOutputStream", "Lorg/apache/commons/compress/archivers/zip/ZipArchiveOutputStream;", "getMorphoZipOutputStream", "()Lorg/apache/commons/compress/archivers/zip/ZipArchiveOutputStream;", "setMorphoZipOutputStream", "(Lorg/apache/commons/compress/archivers/zip/ZipArchiveOutputStream;)V", "hasCorrespondingBaseZip", "correspondingBaseZip", "korapxml2conllu", "args", "getTokenSpansFromMorho", "(Ljava/util/Map;)[Lde/ids_mannheim/korapxmltools/KorapXmlTool$Span;", "getFoundryFromZipFileName", "zipFileName", "getFoundryFromZipFileNames", "([Ljava/lang/String;)Ljava/lang/String;", "processZipFile", "zipFilePath", "foundry", "processZipFileSequentially", "processZipEntry", "zipFile", "Ljava/util/zip/ZipFile;", "_foundry", "zipEntry", "Ljava/util/zip/ZipEntry;", "passedWaitForMorpho", "processText", "docId", "getMorphoFoundry", "korapXmlDependencyOutput", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "korapXmlOutput", "korapXmlMorphoOutput", "conlluOutput", "lmTrainingOutput", "printConlluToken", "token_index", "token", "lemma", "upos", "xpos", "feats", "head", "deprel", "deps", "misc", "tokenOffsetsInSentence", "sentence_index", "extractSpans", "spans", "Lorg/w3c/dom/NodeList;", "(Lorg/w3c/dom/NodeList;)[Lde/ids_mannheim/korapxmltools/KorapXmlTool$Span;", "extractMorphoSpans", "fsSpans", "extractSentenceSpans", "extractMiscSpans", "OutputFormatConverter", "Span", "MorphoSpan", "app"})
@SourceDebugExtension(value={"SMAP\nKorapXmlTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KorapXmlTool.kt\nde/ids_mannheim/korapxmltools/KorapXmlTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,1056:1\n1557#2:1057\n1628#2,3:1058\n1053#2:1061\n1863#2,2:1067\n1053#2:1075\n1863#2,2:1076\n37#3:1062\n36#3,3:1063\n37#3:1069\n36#3,3:1070\n1#4:1066\n13402#5,2:1073\n13402#5,2:1080\n13402#5,2:1082\n216#6,2:1078\n*S KotlinDebug\n*F\n+ 1 KorapXmlTool.kt\nde/ids_mannheim/korapxmltools/KorapXmlTool\n*L\n312#1:1057\n312#1:1058,3\n315#1:1061\n501#1:1067,2\n608#1:1075\n610#1:1076,2\n317#1:1062\n317#1:1063,3\n508#1:1069\n508#1:1070,3\n571#1:1073,2\n772#1:1080,2\n845#1:1082,2\n690#1:1078,2\n*E\n"})
public final class KorapXmlTool
implements Callable<Integer> {
    private final boolean COMPATIBILITY_MODE = System.getenv("COMPATIBILITY_MODE") != null;
    @CommandLine.Spec
    public CommandLine.Model.CommandSpec spec;
    @CommandLine.Parameters(description={"At least one zip file name"}, arity="1..*")
    @Nullable
    private String[] zipFileNames;
    @CommandLine.Option(names={"-f", "--output-format"}, description={"Output format: conllu, word2vec, korapxml", "conllu: CoNLL-U format", "korapxml, xml, zip: KorAP-XML format zip", "word2vec, w2v: Print text in LM training format: tokens separated by space, sentences separated by newlines"}, converter={OutputFormatConverter.class})
    @NotNull
    private OutputFormat outputFormat = OutputFormat.CONLLU;
    @CommandLine.Option(names={"--sigle-pattern", "-p"}, description={"Extract only documents with sigle matching the pattern (regex)"}, paramLabel="PATTERN")
    @Nullable
    private String siglePattern;
    @CommandLine.Option(names={"--extract-attributes-regex", "-e"}, description={"Extract additional attribute values from structure.xml and writes them as comment line in front of the first covered token.", "Example: -e '(posting/id|div/id)'"}, paramLabel="REGEX")
    @NotNull
    private String extractAttributesRegex = "";
    @CommandLine.Option(names={"--s-bounds-from-morpho"}, description={"Not yet implemented: s bounds from morpho"})
    private boolean sBoundsFromMorpho;
    @CommandLine.Option(names={"--log", "-l"}, description={"Log level: one of SEVERE, WARNING, INFO, FINE, FINER, FINEST. Default: ${DEFAULT-VALUE}])"}, paramLabel="LEVEL")
    @NotNull
    private String logLevel = "WARNING";
    @CommandLine.Option(names={"--columns", "-c"}, description={"Number of columns. 1 means just the token. Default: ${DEFAULT-VALUE}", "Possible values: 1-10"}, paramLabel="NUMBER")
    private int columns = 10;
    @CommandLine.Option(names={"--token-separator", "-s"}, description={"Token separator. Default: new-line for CoNLL-U, space for word2vec format."}, paramLabel="STRING", defaultValue="\n")
    @NotNull
    private String tokenSeparator = this.outputFormat == OutputFormat.WORD2VEC ? " " : "\n";
    @CommandLine.Option(names={"--offsets"}, description={"Not yet implemented: offsets"})
    private boolean offsets;
    @CommandLine.Option(names={"--comments", "-C"}, description={"Not yet implemented: comments"})
    private boolean comments;
    @CommandLine.Option(names={"--extract-metadata-regex", "-m"}, description={"Extract metadata regexes.\nExample: -m '<textSigle>([^<]+)' -m '<creatDate>([^<]+)'"}, paramLabel="REGEX")
    @NotNull
    private List<String> extractMetadataRegex = new ArrayList();
    @CommandLine.Option(names={"--annotate-with", "-A"}, description={"Pipe output through command"}, paramLabel="COMMAND")
    @NotNull
    private String annotateWith = "";
    @CommandLine.Option(names={"--threads", "-T"}, description={"Maximum number of threads to use. Default: ${DEFAULT-VALUE}"}, paramLabel="THREADS")
    private int maxThreads = Runtime.getRuntime().availableProcessors() / 2;
    @CommandLine.Option(names={"--overwrite", "-o"}, description={"Overwrite existing files"})
    private boolean overwrite;
    @Nullable
    private String taggerName;
    @Nullable
    private String taggerModel;
    @Nullable
    private String parserName;
    @Nullable
    private String parserModel;
    @NotNull
    private final Logger LOGGER;
    @Nullable
    private AnnotationWorkerPool annotationWorkerPool;
    @NotNull
    private final ConcurrentHashMap<String, NonBmpString> texts;
    @NotNull
    private final ConcurrentHashMap<String, Span[]> sentences;
    @NotNull
    private final ConcurrentHashMap<String, Span[]> tokens;
    @NotNull
    private final ConcurrentHashMap<String, Map<String, MorphoSpan>> morpho;
    @NotNull
    private final ConcurrentHashMap<String, String> fnames;
    @NotNull
    private final ConcurrentHashMap<String, String[]> metadata;
    @NotNull
    private final ConcurrentHashMap<String, Map<String, String>> extraFeatures;
    @NotNull
    private ConcurrentHashMap<Long, TaggerToolBridge> taggerToolBridges;
    @NotNull
    private ConcurrentHashMap<Long, ParserToolBridge> parserToolBridges;
    @Nullable
    private DocumentBuilderFactory dbFactory;
    @Nullable
    private DocumentBuilder dBuilder;
    @Nullable
    private ZipArchiveOutputStream morphoZipOutputStream;

    public KorapXmlTool() {
        Logger logger = Logger.getLogger(KorapXmlTool.class.getName());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        this.LOGGER = logger;
        this.texts = new ConcurrentHashMap();
        this.sentences = new ConcurrentHashMap();
        this.tokens = new ConcurrentHashMap();
        this.morpho = new ConcurrentHashMap();
        this.fnames = new ConcurrentHashMap();
        this.metadata = new ConcurrentHashMap();
        this.extraFeatures = new ConcurrentHashMap();
        this.taggerToolBridges = new ConcurrentHashMap();
        this.parserToolBridges = new ConcurrentHashMap();
    }

    public final boolean getCOMPATIBILITY_MODE() {
        return this.COMPATIBILITY_MODE;
    }

    @NotNull
    public final CommandLine.Model.CommandSpec getSpec() {
        CommandLine.Model.CommandSpec commandSpec = this.spec;
        if (commandSpec != null) {
            return commandSpec;
        }
        Intrinsics.throwUninitializedPropertyAccessException("spec");
        return null;
    }

    public final void setSpec(@NotNull CommandLine.Model.CommandSpec commandSpec) {
        Intrinsics.checkNotNullParameter(commandSpec, "<set-?>");
        this.spec = commandSpec;
    }

    @Nullable
    public final String[] getZipFileNames() {
        return this.zipFileNames;
    }

    public final void setZipFileNames(@Nullable String[] stringArray) {
        this.zipFileNames = stringArray;
    }

    @NotNull
    public final OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    public final void setOutputFormat(@NotNull OutputFormat outputFormat) {
        Intrinsics.checkNotNullParameter((Object)outputFormat, "<set-?>");
        this.outputFormat = outputFormat;
    }

    @Nullable
    public final String getSiglePattern() {
        return this.siglePattern;
    }

    public final void setSiglePattern(@Nullable String string) {
        this.siglePattern = string;
    }

    @NotNull
    public final String getExtractAttributesRegex() {
        return this.extractAttributesRegex;
    }

    public final void setExtractAttributesRegex(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.extractAttributesRegex = string;
    }

    public final boolean getSBoundsFromMorpho() {
        return this.sBoundsFromMorpho;
    }

    public final void setSBoundsFromMorpho(boolean bl) {
        this.sBoundsFromMorpho = bl;
    }

    @NotNull
    public final String getLogLevel() {
        return this.logLevel;
    }

    public final void setLogLevel(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.logLevel = string;
    }

    public final int getColumns() {
        return this.columns;
    }

    public final void setColumns(int n) {
        this.columns = n;
    }

    @CommandLine.Option(names={"--word2vec", "-w"}, description={"Print text in LM training format: tokens separated by space, sentences separated by newline", "Deprecated: use -f word2vec"})
    public final void setWord2Vec(boolean word2vec) {
        if (word2vec) {
            this.outputFormat = OutputFormat.WORD2VEC;
        }
    }

    @NotNull
    public final String getTokenSeparator() {
        return this.tokenSeparator;
    }

    public final void setTokenSeparator(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.tokenSeparator = string;
    }

    public final boolean getOffsets() {
        return this.offsets;
    }

    public final void setOffsets(boolean bl) {
        this.offsets = bl;
    }

    public final boolean getComments() {
        return this.comments;
    }

    public final void setComments(boolean bl) {
        this.comments = bl;
    }

    @NotNull
    public final List<String> getExtractMetadataRegex() {
        return this.extractMetadataRegex;
    }

    public final void setExtractMetadataRegex(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.extractMetadataRegex = list;
    }

    @NotNull
    public final String getAnnotateWith() {
        return this.annotateWith;
    }

    public final void setAnnotateWith(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.annotateWith = string;
    }

    public final int getMaxThreads() {
        return this.maxThreads;
    }

    public final void setMaxThreads(int n) {
        this.maxThreads = n;
    }

    public final void setThreads(int threads) {
        if (threads < 1) {
            CommandLine commandLine = this.getSpec().commandLine();
            String string = "Invalid value `%d' for option '--threads': must be at least 1";
            Object[] objectArray = new Object[]{threads};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            throw new CommandLine.ParameterException(commandLine, string2);
        }
        this.maxThreads = threads;
        System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", String.valueOf(threads));
    }

    public final boolean getOverwrite() {
        return this.overwrite;
    }

    public final void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    @CommandLine.Option(names={"--tag-with", "-t"}, description={"Specify a tagger and a model: marmot|opennlp:<path/to/model>."}, paramLabel="TAGGER:MODEL")
    public final void setTagWith(@NotNull String tagWith) {
        Intrinsics.checkNotNullParameter(tagWith, "tagWith");
        Pattern pattern = Pattern.compile("(marmot|opennlp):(.+)");
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        Pattern pattern2 = pattern;
        Matcher matcher = pattern2.matcher(tagWith);
        Intrinsics.checkNotNullExpressionValue(matcher, "matcher(...)");
        Matcher matcher2 = matcher;
        if (!matcher2.matches()) {
            CommandLine commandLine = this.getSpec().commandLine();
            String string = "Invalid value `%s' for option '--tag-with': value does not match the expected pattern marmot|opennlp:<path/to/model>";
            Object[] objectArray = new Object[]{tagWith};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            throw new CommandLine.ParameterException(commandLine, string2);
        }
        this.taggerName = matcher2.group(1);
        this.taggerModel = matcher2.group(2);
        if (!new File(this.taggerModel).exists()) {
            CommandLine commandLine = this.getSpec().commandLine();
            String string = "Invalid value for option '--tag-with':model file '%s' does not exist";
            Object[] objectArray = new Object[]{this.taggerModel, this.taggerModel};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            throw new CommandLine.ParameterException(commandLine, string3);
        }
    }

    @CommandLine.Option(names={"--parse-with", "-P"}, description={"Specify a parser and a model: malt:<path/to/model>."}, paramLabel="parser:MODEL")
    public final void setParseWith(@NotNull String parseWith) {
        Intrinsics.checkNotNullParameter(parseWith, "parseWith");
        Pattern pattern = Pattern.compile("(malt):(.+)");
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        Pattern pattern2 = pattern;
        Matcher matcher = pattern2.matcher(parseWith);
        Intrinsics.checkNotNullExpressionValue(matcher, "matcher(...)");
        Matcher matcher2 = matcher;
        if (!matcher2.matches()) {
            CommandLine commandLine = this.getSpec().commandLine();
            String string = "Invalid value `%s' for option '--parse-with': value does not match the expected pattern (malt):<path/to/model>";
            Object[] objectArray = new Object[]{parseWith};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            throw new CommandLine.ParameterException(commandLine, string2);
        }
        this.parserName = matcher2.group(1);
        this.parserModel = matcher2.group(2);
        if (!new File(this.parserModel).exists()) {
            CommandLine commandLine = this.getSpec().commandLine();
            String string = "Invalid value for option '--parse-with':model file '%s' does not exist";
            Object[] objectArray = new Object[]{this.parserModel, this.parserModel};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            throw new CommandLine.ParameterException(commandLine, string3);
        }
    }

    @Override
    @NotNull
    public Integer call() {
        Logger logger;
        ConsoleHandler handler = new ConsoleHandler();
        LogManager.getLogManager().reset();
        handler.setFormatter(new ColoredFormatter());
        Object object = ArrayIteratorKt.iterator(this.LOGGER.getHandlers());
        while (object.hasNext()) {
            Handler handler2 = object.next();
            this.LOGGER.removeHandler(handler2);
        }
        this.LOGGER.addHandler(handler);
        Logger logger2 = this.LOGGER;
        try {
            logger = logger2;
            object = this.logLevel;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string = ((String)object).toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
            object = Level.parse(string);
        }
        catch (IllegalArgumentException handler2) {
            logger = logger2;
            this.LOGGER.warning("Invalid log level: " + this.logLevel + ". Defaulting to WARNING.");
            object = Level.WARNING;
        }
        logger.setLevel((Level)object);
        Intrinsics.checkNotNull(this.zipFileNames);
        this.LOGGER.info("Processing zip files: " + ArraysKt.joinToString$default(this.zipFileNames, (CharSequence)", ", null, null, 0, null, null, 62, null));
        Intrinsics.checkNotNull(this.zipFileNames);
        this.korapxml2conllu(this.zipFileNames);
        return 0;
    }

    @NotNull
    public final ConcurrentHashMap<String, NonBmpString> getTexts() {
        return this.texts;
    }

    @NotNull
    public final ConcurrentHashMap<String, Span[]> getSentences() {
        return this.sentences;
    }

    @NotNull
    public final ConcurrentHashMap<String, Span[]> getTokens() {
        return this.tokens;
    }

    @NotNull
    public final ConcurrentHashMap<String, Map<String, MorphoSpan>> getMorpho() {
        return this.morpho;
    }

    @NotNull
    public final ConcurrentHashMap<String, String> getFnames() {
        return this.fnames;
    }

    @NotNull
    public final ConcurrentHashMap<String, String[]> getMetadata() {
        return this.metadata;
    }

    @NotNull
    public final ConcurrentHashMap<String, Map<String, String>> getExtraFeatures() {
        return this.extraFeatures;
    }

    @NotNull
    public final ConcurrentHashMap<Long, TaggerToolBridge> getTaggerToolBridges() {
        return this.taggerToolBridges;
    }

    public final void setTaggerToolBridges(@NotNull ConcurrentHashMap<Long, TaggerToolBridge> concurrentHashMap) {
        Intrinsics.checkNotNullParameter(concurrentHashMap, "<set-?>");
        this.taggerToolBridges = concurrentHashMap;
    }

    @NotNull
    public final ConcurrentHashMap<Long, ParserToolBridge> getParserToolBridges() {
        return this.parserToolBridges;
    }

    public final void setParserToolBridges(@NotNull ConcurrentHashMap<Long, ParserToolBridge> concurrentHashMap) {
        Intrinsics.checkNotNullParameter(concurrentHashMap, "<set-?>");
        this.parserToolBridges = concurrentHashMap;
    }

    @Nullable
    public final DocumentBuilderFactory getDbFactory() {
        return this.dbFactory;
    }

    public final void setDbFactory(@Nullable DocumentBuilderFactory documentBuilderFactory) {
        this.dbFactory = documentBuilderFactory;
    }

    @Nullable
    public final DocumentBuilder getDBuilder() {
        return this.dBuilder;
    }

    public final void setDBuilder(@Nullable DocumentBuilder documentBuilder) {
        this.dBuilder = documentBuilder;
    }

    @Nullable
    public final ZipArchiveOutputStream getMorphoZipOutputStream() {
        return this.morphoZipOutputStream;
    }

    public final void setMorphoZipOutputStream(@Nullable ZipArchiveOutputStream zipArchiveOutputStream) {
        this.morphoZipOutputStream = zipArchiveOutputStream;
    }

    public final boolean hasCorrespondingBaseZip(@NotNull String $this$hasCorrespondingBaseZip) {
        Intrinsics.checkNotNullParameter($this$hasCorrespondingBaseZip, "<this>");
        CharSequence charSequence = $this$hasCorrespondingBaseZip;
        if (!new Regex(".*\\.([^/.]+)\\.zip$").matches(charSequence)) {
            return false;
        }
        CharSequence charSequence2 = $this$hasCorrespondingBaseZip;
        Regex regex = new Regex("\\.([^/.]+)\\.zip$");
        String string = ".zip";
        String baseZip = regex.replace(charSequence2, string);
        return new File(baseZip).exists();
    }

    @Nullable
    public final String correspondingBaseZip(@NotNull String $this$correspondingBaseZip) {
        Intrinsics.checkNotNullParameter($this$correspondingBaseZip, "<this>");
        CharSequence charSequence = $this$correspondingBaseZip;
        if (!new Regex(".*\\.([^/.]+)\\.zip$").matches(charSequence)) {
            return null;
        }
        Regex regex = new Regex("\\.([^/.]+)\\.zip$");
        CharSequence charSequence2 = $this$correspondingBaseZip;
        String string = ".zip";
        String baseZip = regex.replace(charSequence2, string);
        return new File(baseZip).exists() ? baseZip : null;
    }

    public final void korapxml2conllu(@NotNull String[] args) {
        block5: {
            Intrinsics.checkNotNullParameter(args, "args");
            if (this.outputFormat == OutputFormat.KORAPXML && ((CharSequence)this.annotateWith).length() > 0) {
                this.LOGGER.severe("Shell command annotation is not yet supported with output format " + this.outputFormat);
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            Executors.newFixedThreadPool(this.maxThreads);
            if (((CharSequence)this.annotateWith).length() > 0) {
                this.annotationWorkerPool = new AnnotationWorkerPool(this.annotateWith, this.maxThreads, this.LOGGER);
            }
            Ref.ObjectRef zips = new Ref.ObjectRef();
            zips.element = args;
            if (this.maxThreads > 1) {
                this.LOGGER.info("Processing zip files in parallel with " + this.maxThreads + " threads");
                ((Stream)Arrays.stream((Object[])zips.element).parallel()).forEach(arg_0 -> KorapXmlTool.korapxml2conllu$lambda$1(arg_0 -> KorapXmlTool.korapxml2conllu$lambda$0(this, zips, arg_0), arg_0));
            } else {
                this.LOGGER.info("Processing zip files sequentially");
                Arrays.stream((Object[])zips.element).forEachOrdered(arg_0 -> KorapXmlTool.korapxml2conllu$lambda$3(arg_0 -> KorapXmlTool.korapxml2conllu$lambda$2(this, zips, arg_0), arg_0));
            }
            if (this.annotationWorkerPool == null) break block5;
            this.LOGGER.info("closing worker pool");
            AnnotationWorkerPool annotationWorkerPool = this.annotationWorkerPool;
            if (annotationWorkerPool != null) {
                annotationWorkerPool.close();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Span[] getTokenSpansFromMorho(Map<String, MorphoSpan> morpho) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = morpho.keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void key;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"-"};
            List fromTo = StringsKt.split$default((CharSequence)key, stringArray, false, 0, 6, null);
            collection.add(new Span(Integer.parseInt((String)fromTo.get(0)), Integer.parseInt((String)fromTo.get(1))));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        Collection $this$toTypedArray$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Span it = (Span)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getFrom());
                it = (Span)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getFrom());
            }
        });
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Span[0]);
    }

    private final String getFoundryFromZipFileName(String zipFileName) {
        CharSequence charSequence = zipFileName;
        if (!new Regex(".*\\.([^/.]+)\\.zip$").matches(charSequence)) {
            return "base";
        }
        charSequence = zipFileName;
        Regex regex = new Regex(".*\\.([^/.]+)\\.zip$");
        String string = "$1";
        return regex.replace(charSequence, string);
    }

    private final String getFoundryFromZipFileNames(String[] zipFileNames) {
        for (String zipFileName : zipFileNames) {
            String foundry = this.getFoundryFromZipFileName(zipFileName);
            if (Intrinsics.areEqual(foundry, "base")) continue;
            return foundry;
        }
        return "base";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void processZipFile(String zipFilePath, String foundry) {
        Object object;
        this.LOGGER.info("Processing " + zipFilePath + " in thread " + Thread.currentThread().getId());
        this.LOGGER.info("Foundry: " + foundry + " " + this.dbFactory);
        if (this.outputFormat == OutputFormat.KORAPXML && this.dbFactory == null) {
            void $this$processZipFile_u24lambda_u246;
            String outputMorphoZipFileName;
            Object object2;
            Object object3;
            String targetFoundry = "base";
            if (this.taggerName != null) {
                String string = this.taggerName;
                Intrinsics.checkNotNull(string);
                String string2 = this.taggerModel;
                Intrinsics.checkNotNull(string2);
                TaggerToolBridge tagger = (TaggerToolBridge)AnnotationToolBridgeFactory.Companion.getAnnotationToolBridge(string, string2, this.LOGGER);
                if (tagger != null) {
                    targetFoundry = tagger.getFoundry();
                }
            } else if (this.parserName != null) {
                String string = this.parserName;
                Intrinsics.checkNotNull(string);
                targetFoundry = string;
            }
            DocumentBuilderFactory documentBuilderFactory = this.dbFactory = DocumentBuilderFactory.newInstance();
            Intrinsics.checkNotNull(documentBuilderFactory);
            this.dBuilder = documentBuilderFactory.newDocumentBuilder();
            if (this.parserName != null) {
                object = zipFilePath;
                object3 = new Regex("(\\.(opennlp|marmot|tree_tagger|corenlp|spacy))?\\.zip$");
                object2 = "." + this.parserName + ".zip";
                v4 = ((Regex)object3).replace((CharSequence)object, (String)object2);
            } else {
                object = zipFilePath;
                object3 = new Regex("\\.zip$");
                object2 = "." + targetFoundry + ".zip";
                v4 = outputMorphoZipFileName = ((Regex)object3).replace((CharSequence)object, (String)object2);
            }
            if (new File(outputMorphoZipFileName).exists() && !this.overwrite) {
                this.LOGGER.severe("Output file " + outputMorphoZipFileName + " already exists. Use --overwrite to overwrite.");
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            FileOutputStream fileOutputStream = new FileOutputStream(outputMorphoZipFileName);
            object2 = object3 = new ZipArchiveOutputStream(fileOutputStream);
            KorapXmlTool korapXmlTool = this;
            boolean bl = false;
            $this$processZipFile_u24lambda_u246.setUseZip64(Zip64Mode.Always);
            korapXmlTool.morphoZipOutputStream = object3;
        }
        if (this.hasCorrespondingBaseZip(zipFilePath)) {
            var4_4 = new String[2];
            var4_4[0] = zipFilePath;
            Intrinsics.checkNotNull(this.correspondingBaseZip(zipFilePath));
            Object zips = var4_4;
            ((Stream)Arrays.stream(zips).parallel()).forEach(arg_0 -> KorapXmlTool.processZipFile$lambda$11(arg_0 -> KorapXmlTool.processZipFile$lambda$10(this, foundry, arg_0), arg_0));
        } else {
            Closeable closeable = new ZipFile(zipFilePath);
            var4_4 = null;
            try {
                ZipFile zipFile = (ZipFile)closeable;
                boolean bl = false;
                ((Stream)zipFile.stream().filter(arg_0 -> KorapXmlTool.processZipFile$lambda$14$lambda$12(new Function1(this){
                    final /* synthetic */ KorapXmlTool this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final Boolean invoke(ZipEntry it) {
                        boolean bl;
                        if (!(!((Collection)this.this$0.getExtractMetadataRegex()).isEmpty())) {
                            String string = it.getName();
                            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                            if (StringsKt.contains$default((CharSequence)string, "header.xml", false, 2, null)) {
                                bl = false;
                                return bl;
                            }
                        }
                        bl = true;
                        return bl;
                    }
                }, arg_0)).parallel()).forEach(arg_0 -> KorapXmlTool.processZipFile$lambda$14$lambda$13(new Function1(this, zipFile, foundry){
                    final /* synthetic */ KorapXmlTool this$0;
                    final /* synthetic */ ZipFile $zipFile;
                    final /* synthetic */ String $foundry;
                    {
                        this.this$0 = $receiver;
                        this.$zipFile = $zipFile;
                        this.$foundry = $foundry;
                    }

                    public final void invoke(ZipEntry zipEntry) {
                        Intrinsics.checkNotNull(zipEntry);
                        this.this$0.processZipEntry(this.$zipFile, this.$foundry, zipEntry, false);
                    }
                }, arg_0));
                object = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                var4_4 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally(closeable, (Throwable)var4_4);
            }
        }
        if (this.outputFormat == OutputFormat.KORAPXML) {
            ZipArchiveOutputStream zipArchiveOutputStream = this.morphoZipOutputStream;
            Intrinsics.checkNotNull(zipArchiveOutputStream);
            zipArchiveOutputStream.close();
        }
    }

    static /* synthetic */ void processZipFile$default(KorapXmlTool korapXmlTool, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "base";
        }
        korapXmlTool.processZipFile(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processZipFileSequentially(String zipFilePath, String foundry) {
        this.LOGGER.info("Processing " + zipFilePath + " in thread " + Thread.currentThread().getId());
        if (this.hasCorrespondingBaseZip(zipFilePath)) {
            String[] stringArray = new String[2];
            stringArray[0] = zipFilePath;
            Intrinsics.checkNotNull(this.correspondingBaseZip(zipFilePath));
            String[] zips = stringArray;
            ((Stream)Arrays.stream(zips).parallel()).forEach(arg_0 -> KorapXmlTool.processZipFileSequentially$lambda$19(arg_0 -> KorapXmlTool.processZipFileSequentially$lambda$18(this, foundry, arg_0), arg_0));
        } else {
            Closeable closeable = new ZipFile(zipFilePath);
            Throwable throwable = null;
            try {
                ZipFile zipFile = (ZipFile)closeable;
                boolean bl = false;
                zipFile.stream().filter(arg_0 -> KorapXmlTool.processZipFileSequentially$lambda$22$lambda$20(new Function1(this){
                    final /* synthetic */ KorapXmlTool this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final Boolean invoke(ZipEntry it) {
                        boolean bl;
                        if (!(!((Collection)this.this$0.getExtractMetadataRegex()).isEmpty())) {
                            String string = it.getName();
                            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                            if (StringsKt.contains$default((CharSequence)string, "header.xml", false, 2, null)) {
                                bl = false;
                                return bl;
                            }
                        }
                        bl = true;
                        return bl;
                    }
                }, arg_0)).forEachOrdered(arg_0 -> KorapXmlTool.processZipFileSequentially$lambda$22$lambda$21(new Function1(this, zipFile, foundry){
                    final /* synthetic */ KorapXmlTool this$0;
                    final /* synthetic */ ZipFile $zipFile;
                    final /* synthetic */ String $foundry;
                    {
                        this.this$0 = $receiver;
                        this.$zipFile = $zipFile;
                        this.$foundry = $foundry;
                    }

                    public final void invoke(ZipEntry zipEntry) {
                        Intrinsics.checkNotNull(zipEntry);
                        this.this$0.processZipEntry(this.$zipFile, this.$foundry, zipEntry, false);
                    }
                }, arg_0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
    }

    static /* synthetic */ void processZipFileSequentially$default(KorapXmlTool korapXmlTool, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "base";
        }
        korapXmlTool.processZipFileSequentially(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processZipEntry(@NotNull ZipFile zipFile, @NotNull String _foundry, @NotNull ZipEntry zipEntry, boolean passedWaitForMorpho) {
        block39: {
            Object parser;
            Intrinsics.checkNotNullParameter(zipFile, "zipFile");
            Intrinsics.checkNotNullParameter(_foundry, "_foundry");
            Intrinsics.checkNotNullParameter(zipEntry, "zipEntry");
            Object foundry = _foundry;
            boolean waitForMorpho = passedWaitForMorpho;
            this.LOGGER.finer("Processing " + zipEntry.getName() + " in thread " + Thread.currentThread().getId());
            if (this.taggerName != null && !this.taggerToolBridges.containsKey(Thread.currentThread().getId())) {
                String string = this.taggerName;
                Intrinsics.checkNotNull(string);
                String string2 = this.taggerModel;
                Intrinsics.checkNotNull(string2);
                TaggerToolBridge tagger = (TaggerToolBridge)AnnotationToolBridgeFactory.Companion.getAnnotationToolBridge(string, string2, this.LOGGER);
                ((Map)this.taggerToolBridges).put(Thread.currentThread().getId(), tagger);
                if (tagger != null) {
                    foundry = tagger.getFoundry();
                }
            }
            if (this.parserName != null && !this.parserToolBridges.containsKey(Thread.currentThread().getId())) {
                String string = this.parserName;
                Intrinsics.checkNotNull(string);
                String string3 = this.parserModel;
                Intrinsics.checkNotNull(string3);
                parser = (ParserToolBridge)AnnotationToolBridgeFactory.Companion.getAnnotationToolBridge(string, string3, this.LOGGER);
                ((Map)this.parserToolBridges).put(Thread.currentThread().getId(), parser);
                if (parser != null) {
                    foundry = (String)foundry + " dependency:" + parser.getFoundry();
                    this.LOGGER.fine("Initialized parser " + this.parserName + " with foundry " + (String)foundry + " in thread " + Thread.currentThread().getId());
                }
            }
            try {
                String string;
                Object it;
                Object inputStream;
                block41: {
                    Document document;
                    String string4 = zipEntry.getName();
                    Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
                    parser = string4;
                    if (!new Regex(".*(data|tokens|structure|morpho)\\.xml$").matches((CharSequence)parser)) break block41;
                    InputStream inputStream2 = zipFile.getInputStream(zipEntry);
                    Intrinsics.checkNotNullExpressionValue(inputStream2, "getInputStream(...)");
                    inputStream = inputStream2;
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    Intrinsics.checkNotNullExpressionValue(documentBuilderFactory, "newInstance(...)");
                    DocumentBuilderFactory dbFactory = documentBuilderFactory;
                    DocumentBuilder documentBuilder = dbFactory.newDocumentBuilder();
                    Intrinsics.checkNotNullExpressionValue(documentBuilder, "newDocumentBuilder(...)");
                    DocumentBuilder dBuilder = documentBuilder;
                    try {
                        document = dBuilder.parse(new InputSource(new XMLCommentFilterReader((InputStream)inputStream, "UTF-8")));
                        Intrinsics.checkNotNull(document);
                    }
                    catch (SAXParseException e) {
                        this.LOGGER.warning("Error parsing file: " + zipEntry.getName() + " " + e.getMessage());
                        return;
                    }
                    Document doc = document;
                    doc.getDocumentElement().normalize();
                    String string5 = doc.getDocumentElement().getAttribute("docid");
                    Intrinsics.checkNotNullExpressionValue(string5, "getAttribute(...)");
                    String docId = string5;
                    if (this.siglePattern != null) {
                        String string6 = this.siglePattern;
                        Intrinsics.checkNotNull(string6);
                        if (!new Regex(string6).containsMatchIn(docId)) {
                            return;
                        }
                    }
                    String string7 = zipEntry.getName();
                    Intrinsics.checkNotNullExpressionValue(string7, "getName(...)");
                    CharSequence charSequence = string7;
                    Regex regex = new Regex(".*?/([^/]+\\.xml)$");
                    Object object = "$1";
                    String fileName = regex.replace(charSequence, (String)object);
                    switch (fileName) {
                        case "data.xml": {
                            NodeList nodeList = doc.getElementsByTagName("text");
                            Intrinsics.checkNotNullExpressionValue(nodeList, "getElementsByTagName(...)");
                            NodeList textsList = nodeList;
                            if (textsList.getLength() <= 0) break;
                            object = this.texts;
                            String string8 = textsList.item(0).getTextContent();
                            Intrinsics.checkNotNullExpressionValue(string8, "getTextContent(...)");
                            NonBmpString nonBmpString = new NonBmpString(string8);
                            object.put(docId, nonBmpString);
                            break;
                        }
                        case "structure.xml": {
                            NodeList nodeList = doc.getElementsByTagName("span");
                            Intrinsics.checkNotNullExpressionValue(nodeList, "getElementsByTagName(...)");
                            NodeList spans = nodeList;
                            if (((CharSequence)this.extractAttributesRegex).length() > 0) {
                                ((Map)this.extraFeatures).put(docId, this.extractMiscSpans(spans));
                            }
                            ((Map)this.sentences).put(docId, this.extractSentenceSpans(spans));
                            break;
                        }
                        case "tokens.xml": {
                            if (!this.fnames.contains(docId)) {
                                ((Map)this.fnames).put(docId, zipEntry.getName());
                            }
                            NodeList nodeList = doc.getElementsByTagName("span");
                            Intrinsics.checkNotNullExpressionValue(nodeList, "getElementsByTagName(...)");
                            NodeList tokenSpans = nodeList;
                            ((Map)this.tokens).put(docId, this.extractSpans(tokenSpans));
                            break;
                        }
                        case "morpho.xml": {
                            waitForMorpho = true;
                            ((Map)this.fnames).put(docId, zipEntry.getName());
                            NodeList nodeList = doc.getElementsByTagName("span");
                            Intrinsics.checkNotNullExpressionValue(nodeList, "getElementsByTagName(...)");
                            NodeList fsSpans = nodeList;
                            ((Map)this.morpho).put(docId, this.extractMorphoSpans(fsSpans));
                            ((Map)this.tokens).put(docId, this.extractSpans(fsSpans));
                        }
                    }
                    if (!(this.texts.get(docId) == null || this.sentences.get(docId) == null || this.tokens.get(docId) == null || waitForMorpho && this.morpho.get(docId) == null || !this.extractMetadataRegex.isEmpty() && this.metadata.get(docId) == null)) {
                        this.LOGGER.info("Processing text: " + docId + " in thread " + Thread.currentThread().getId());
                        this.processText(docId, (String)foundry);
                    }
                    break block39;
                }
                if (!(!((Collection)this.extractMetadataRegex).isEmpty())) break block39;
                String string9 = zipEntry.getName();
                Intrinsics.checkNotNullExpressionValue(string9, "getName(...)");
                inputStream = string9;
                if (!new Regex(".*/header\\.xml$").matches((CharSequence)inputStream)) break block39;
                InputStream inputStream3 = zipFile.getInputStream(zipEntry);
                Intrinsics.checkNotNullExpressionValue(inputStream3, "getInputStream(...)");
                Closeable dbFactory = inputStream3;
                Object dBuilder = Charsets.UTF_8;
                Reader doc = new InputStreamReader((InputStream)dbFactory, (Charset)dBuilder);
                int docId = 8192;
                dbFactory = doc instanceof BufferedReader ? (BufferedReader)doc : new BufferedReader(doc, docId);
                dBuilder = null;
                try {
                    it = (BufferedReader)dbFactory;
                    boolean bl = false;
                    it = TextStreamsKt.readText((Reader)it);
                }
                catch (Throwable bl) {
                    dBuilder = bl;
                    throw bl;
                }
                finally {
                    CloseableKt.closeFinally(dbFactory, (Throwable)dBuilder);
                }
                Object text = it;
                dBuilder = Regex.find$default(new Regex("<textSigle>([^<]+)</textSigle>"), (CharSequence)text, 0, 2, null);
                if (dBuilder != null && (it = dBuilder.getDestructured()) != null && (bl = ((MatchResult.Destructured)it).getMatch().getGroupValues().get(1)) != null) {
                    CharSequence fileName = bl;
                    Regex regex = new Regex("/");
                    String fsSpans = "_";
                    string = regex.replace(fileName, fsSpans);
                } else {
                    string = null;
                }
                String docId2 = string;
                this.LOGGER.info("Processing header file: " + zipEntry.getName() + " docId: " + docId2);
                ArrayList<String> meta = new ArrayList<String>();
                Iterable $this$forEach$iv = this.extractMetadataRegex;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String regex = (String)element$iv;
                    boolean bl = false;
                    MatchResult match = Regex.find$default(new Regex(regex), (CharSequence)text, 0, 2, null);
                    if (match == null) continue;
                    meta.add(match.getDestructured().getMatch().getGroupValues().get(1));
                }
                if (!((Collection)meta).isEmpty() && docId2 != null) {
                    Map map2 = this.metadata;
                    Collection $this$toTypedArray$iv = meta;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    map2.put(docId2, stringArray);
                    if (!(this.texts.get(docId2) == null || this.sentences.get(docId2) == null || this.tokens.get(docId2) == null || waitForMorpho && this.morpho.get(docId2) == null)) {
                        this.processText(docId2, (String)foundry);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processText(String docId, String foundry) {
        StringBuilder output;
        this.LOGGER.fine("Processing text: " + docId + " in thread " + Thread.currentThread().getId());
        String morphoFoundry = this.getMorphoFoundry();
        if (this.outputFormat == OutputFormat.WORD2VEC) {
            v0 = this.lmTrainingOutput(docId);
        } else {
            if (this.taggerToolBridges.get(Thread.currentThread().getId()) != null) {
                Map map2 = this.morpho;
                TaggerToolBridge taggerToolBridge = this.taggerToolBridges.get(Thread.currentThread().getId());
                Intrinsics.checkNotNull(taggerToolBridge);
                Span[] spanArray = this.tokens.get(docId);
                Intrinsics.checkNotNull(spanArray);
                NonBmpString nonBmpString = this.texts.get(docId);
                Intrinsics.checkNotNull(nonBmpString);
                map2.put(docId, taggerToolBridge.tagText(spanArray, this.sentences.get(docId), nonBmpString));
            }
            if (this.parserToolBridges.get(Thread.currentThread().getId()) != null) {
                if (this.morpho.get(docId) == null) {
                    this.LOGGER.severe("No morpho data for " + docId);
                }
                this.LOGGER.finer("Parsing text: " + docId + " in thread " + Thread.currentThread().getId());
                Map map3 = this.morpho;
                ParserToolBridge parserToolBridge = this.parserToolBridges.get(Thread.currentThread().getId());
                Intrinsics.checkNotNull(parserToolBridge);
                Span[] spanArray = this.tokens.get(docId);
                Intrinsics.checkNotNull(spanArray);
                NonBmpString nonBmpString = this.texts.get(docId);
                Intrinsics.checkNotNull(nonBmpString);
                map3.put(docId, parserToolBridge.parseText(spanArray, this.morpho.get(docId), this.sentences.get(docId), nonBmpString));
                this.LOGGER.finer("Parsed text: " + docId + " in thread " + Thread.currentThread().getId());
            }
            v0 = output = this.outputFormat == OutputFormat.KORAPXML && this.annotationWorkerPool == null ? this.korapXmlOutput(this.getMorphoFoundry(), docId) : this.conlluOutput(foundry, docId);
        }
        if (this.annotationWorkerPool != null) {
            AnnotationWorkerPool annotationWorkerPool = this.annotationWorkerPool;
            if (annotationWorkerPool != null) {
                String string = output.append("\n# eot\n").toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                annotationWorkerPool.pushToQueue(string);
            }
        } else if (this.outputFormat != OutputFormat.KORAPXML) {
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue(printStream, "out");
            PrintStream printStream2 = printStream;
            synchronized (printStream2) {
                boolean bl = false;
                System.out.println((Object)output.toString());
                Unit unit = Unit.INSTANCE;
            }
        } else {
            this.korapXmlOutput(foundry, docId);
        }
        ConcurrentHashMap[] concurrentHashMapArray = new ConcurrentHashMap[]{this.tokens, this.texts, this.sentences, this.morpho, this.fnames, this.metadata, this.extraFeatures};
        ConcurrentHashMap[] $this$forEach$iv = concurrentHashMapArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ConcurrentHashMap element$iv;
            ConcurrentHashMap map4 = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            map4.remove(docId);
        }
        if (this.outputFormat == OutputFormat.KORAPXML) {
            String string;
            Object object;
            if (this.parserName != null) {
                $i$f$forEach = docId;
                var7_11 = new Regex("[_.]");
                object = "/";
                string = var7_11.replace($i$f$forEach, (String)object) + "/" + this.parserName + "/dependency.xml";
            } else {
                $i$f$forEach = docId;
                var7_11 = new Regex("[_.]");
                object = "/";
                string = var7_11.replace($i$f$forEach, (String)object) + "/" + morphoFoundry + "/morpho.xml";
            }
            String entryPath = string;
            ZipArchiveEntry zipEntry = new ZipArchiveEntry(entryPath);
            zipEntry.setUnixMode(KorapXmlToolKt.getZIP_ENTRY_UNIX_MODE());
            ZipArchiveOutputStream zipArchiveOutputStream = this.morphoZipOutputStream;
            Intrinsics.checkNotNull(zipArchiveOutputStream);
            object = zipArchiveOutputStream;
            synchronized (object) {
                boolean bl = false;
                ZipArchiveOutputStream zipArchiveOutputStream2 = this.morphoZipOutputStream;
                Intrinsics.checkNotNull(zipArchiveOutputStream2);
                zipArchiveOutputStream2.putArchiveEntry(zipEntry);
                ZipArchiveOutputStream zipArchiveOutputStream3 = this.morphoZipOutputStream;
                Intrinsics.checkNotNull(zipArchiveOutputStream3);
                String string2 = output.toString();
                Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                byte[] byArray = string2.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
                zipArchiveOutputStream3.write(byArray);
                ZipArchiveOutputStream zipArchiveOutputStream4 = this.morphoZipOutputStream;
                Intrinsics.checkNotNull(zipArchiveOutputStream4);
                zipArchiveOutputStream4.closeArchiveEntry();
                Unit unit = Unit.INSTANCE;
            }
            StringsKt.clear(output);
        }
    }

    private final String getMorphoFoundry() {
        Object object = this.taggerToolBridges.get(Thread.currentThread().getId());
        if (object == null || (object = object.getFoundry()) == null) {
            object = "base";
        }
        return object;
    }

    private final StringBuilder korapXmlDependencyOutput(String foundry, String docId) {
        List sortedKeys;
        List list;
        DocumentBuilder documentBuilder = this.dBuilder;
        Intrinsics.checkNotNull(documentBuilder);
        Document document = documentBuilder.newDocument();
        Intrinsics.checkNotNullExpressionValue(document, "newDocument(...)");
        Document doc = document;
        Element layer = doc.createElement("layer");
        layer.setAttribute("xmlns", "http://ids-mannheim.de/ns/KorAP");
        layer.setAttribute("version", "KorAP-0.4");
        layer.setAttribute("docid", docId);
        doc.appendChild(layer);
        Element spanList = doc.createElement("spanList");
        layer.appendChild(spanList);
        int i = 0;
        int s2 = 0;
        int n = 0;
        Map<String, MorphoSpan> map2 = this.morpho.get(docId);
        if (map2 != null && (map2 = map2.keySet()) != null) {
            Iterable $this$sortedBy$iv = (Iterable)((Object)map2);
            boolean $i$f$sortedBy = false;
            list = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    String it = (String)a;
                    boolean bl = false;
                    String[] stringArray = new String[]{"-"};
                    Comparable comparable = Integer.valueOf(Integer.parseInt((String)StringsKt.split$default((CharSequence)it, stringArray, false, 0, 6, null).get(0)));
                    it = (String)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    stringArray = new String[]{"-"};
                    return ComparisonsKt.compareValues(comparable2, Integer.parseInt((String)StringsKt.split$default((CharSequence)it, stringArray, false, 0, 6, null).get(0)));
                }
            });
        } else {
            list = null;
        }
        List list2 = sortedKeys = list;
        if (list2 != null) {
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int headInt;
                String spanString = (String)element$iv;
                boolean bl = false;
                Map<String, MorphoSpan> map3 = this.morpho.get(docId);
                MorphoSpan mfs = map3 != null ? map3.get(spanString) : null;
                String[] stringArray = new String[]{"-"};
                List offsets = StringsKt.split$default((CharSequence)spanString, stringArray, false, 0, 6, null);
                if (offsets.size() != 2) {
                    this.LOGGER.warning("Invalid span: " + spanString + " in " + docId);
                    continue;
                }
                int n2 = Integer.parseInt((String)offsets.get(0));
                Span[] spanArray = this.sentences.get(docId);
                Intrinsics.checkNotNull(spanArray);
                if (n2 > ((Span)((Object[])spanArray)[s2]).getTo()) {
                    ++s2;
                    n = i;
                }
                ++i;
                MorphoSpan morphoSpan = mfs;
                Intrinsics.checkNotNull(morphoSpan);
                if (Intrinsics.areEqual(morphoSpan.getDeprel(), "_")) continue;
                Element spanNode = doc.createElement("span");
                spanNode.setAttribute("id", "s" + (s2 + 1) + "_n" + (i - n));
                spanNode.setAttribute("from", (String)offsets.get(0));
                spanNode.setAttribute("to", (String)offsets.get(1));
                Element rel = doc.createElement("rel");
                rel.setAttribute("label", mfs.getDeprel());
                Element innerSpan = doc.createElement("span");
                int n3 = headInt = Intrinsics.areEqual(mfs.getHead(), "_") ? 0 : Integer.parseInt(mfs.getHead()) - 1;
                if (headInt < 0) {
                    Span[] spanArray2 = this.sentences.get(docId);
                    Intrinsics.checkNotNull(spanArray2);
                    innerSpan.setAttribute("from", String.valueOf(((Span)((Object[])spanArray2)[s2]).getFrom()));
                    Span[] spanArray3 = this.sentences.get(docId);
                    Intrinsics.checkNotNull(spanArray3);
                    innerSpan.setAttribute("to", String.valueOf(((Span)((Object[])spanArray3)[s2]).getTo()));
                } else {
                    Map<String, MorphoSpan> map4 = this.morpho.get(docId);
                    Intrinsics.checkNotNull(map4);
                    if (headInt + n >= map4.size()) {
                        Map<String, MorphoSpan> map5 = this.morpho.get(docId);
                        Intrinsics.checkNotNull(map5);
                        this.LOGGER.warning("Head index out of bounds: " + (headInt + n) + " >= " + map5.size() + " in " + docId);
                        continue;
                    }
                    String destSpanString = (String)sortedKeys.get(headInt + n);
                    String[] stringArray2 = new String[]{"-"};
                    List destOffsets = StringsKt.split$default((CharSequence)destSpanString, stringArray2, false, 0, 6, null);
                    innerSpan.setAttribute("from", (String)destOffsets.get(0));
                    innerSpan.setAttribute("to", (String)destOffsets.get(1));
                }
                rel.appendChild(innerSpan);
                spanNode.appendChild(rel);
                spanList.appendChild(spanNode);
            }
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "1");
        DOMSource domSource = new DOMSource(doc);
        StreamResult streamResult = new StreamResult(new StringWriter());
        transformer.transform(domSource, streamResult);
        return new StringBuilder(streamResult.getWriter().toString());
    }

    private final StringBuilder korapXmlOutput(String foundry, String docId) {
        return this.parserName != null ? this.korapXmlDependencyOutput(foundry, docId) : this.korapXmlMorphoOutput(foundry, docId);
    }

    private final StringBuilder korapXmlMorphoOutput(String foundry, String docId) {
        DocumentBuilder documentBuilder = this.dBuilder;
        Intrinsics.checkNotNull(documentBuilder);
        Document document = documentBuilder.newDocument();
        Intrinsics.checkNotNullExpressionValue(document, "newDocument(...)");
        Document doc = document;
        Element layer = doc.createElement("layer");
        layer.setAttribute("xmlns", "http://ids-mannheim.de/ns/KorAP");
        layer.setAttribute("version", "KorAP-0.4");
        layer.setAttribute("docid", docId);
        doc.appendChild(layer);
        Element spanList = doc.createElement("spanList");
        layer.appendChild(spanList);
        int i = 0;
        Map<String, MorphoSpan> map2 = this.morpho.get(docId);
        if (map2 != null) {
            Map<String, MorphoSpan> $this$forEach$iv = map2;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, MorphoSpan>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object innerF;
                Map.Entry<String, MorphoSpan> element$iv;
                Map.Entry<String, MorphoSpan> entry = element$iv = iterator2.next();
                boolean bl = false;
                String spanString = entry.getKey();
                MorphoSpan mfs = entry.getValue();
                String[] stringArray = new String[]{"-"};
                List offsets = StringsKt.split$default((CharSequence)spanString, stringArray, false, 0, 6, null);
                Element spanNode = doc.createElement("span");
                spanNode.setAttribute("id", "t_" + ++i);
                spanNode.setAttribute("from", (String)offsets.get(0));
                spanNode.setAttribute("to", (String)offsets.get(1));
                Element fs = doc.createElement("fs");
                fs.setAttribute("type", "lex");
                fs.setAttribute("xmlns", "http://www.tei-c.org/ns/1.0");
                spanNode.appendChild(fs);
                Element f = doc.createElement("f");
                f.setAttribute("name", "lex");
                fs.appendChild(f);
                Element innerFs = doc.createElement("fs");
                f.appendChild(innerFs);
                if (!Intrinsics.areEqual(mfs.getLemma(), "_")) {
                    innerF = doc.createElement("f");
                    innerF.setAttribute("name", "lemma");
                    innerF.setTextContent(mfs.getLemma());
                    innerFs.appendChild((Node)innerF);
                }
                if (!Intrinsics.areEqual(mfs.getUpos(), "_")) {
                    innerF = doc.createElement("f");
                    innerF.setAttribute("name", "upos");
                    innerF.setTextContent(mfs.getUpos());
                    innerFs.appendChild((Node)innerF);
                }
                if (!Intrinsics.areEqual(mfs.getXpos(), "_")) {
                    innerF = doc.createElement("f");
                    innerF.setAttribute("name", "pos");
                    innerF.setTextContent(mfs.getXpos());
                    innerFs.appendChild((Node)innerF);
                }
                if (!Intrinsics.areEqual(mfs.getFeats(), "_")) {
                    innerF = doc.createElement("f");
                    innerF.setAttribute("name", "msd");
                    innerF.setTextContent(mfs.getFeats());
                    innerFs.appendChild((Node)innerF);
                }
                if (!Intrinsics.areEqual(mfs.getMisc(), "_")) {
                    String string = mfs.getMisc();
                    Intrinsics.checkNotNull(string);
                    innerF = string;
                    if (new Regex("^[0-9.]+$").matches((CharSequence)innerF)) {
                        innerF = doc.createElement("f");
                        innerF.setAttribute("name", "certainty");
                        innerF.setTextContent(mfs.getMisc());
                        innerFs.appendChild((Node)innerF);
                    }
                }
                spanList.appendChild(spanNode);
            }
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "1");
        DOMSource domSource = new DOMSource(doc);
        StreamResult streamResult = new StreamResult(new StringWriter());
        transformer.transform(domSource, streamResult);
        return new StringBuilder(streamResult.getWriter().toString());
    }

    private final StringBuilder conlluOutput(String foundry, String docId) {
        StringBuilder output;
        block11: {
            int token_index = 0;
            int real_token_index = 0;
            int sentence_index = 0;
            output = null;
            output = new StringBuilder("# foundry = " + foundry + "\n# filename = " + this.fnames.get(docId) + "\n# text_id = " + docId + "\n").append(this.tokenOffsetsInSentence(this.sentences, docId, sentence_index, real_token_index, this.tokens));
            if (!((Collection)this.extractMetadataRegex).isEmpty()) {
                Object object = this.metadata.get(docId);
                if (object == null || (object = ArraysKt.joinToString$default(object, (CharSequence)"\t", (CharSequence)"# metadata=", (CharSequence)"\n", 0, null, null, 56, null)) == null) {
                    object = "";
                }
                output.append((String)object);
            }
            int previousSpanStart = 0;
            Span[] spanArray = this.tokens.get(docId);
            if (spanArray == null) break block11;
            Span[] $this$forEach$iv = spanArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Span span;
                block13: {
                    block12: {
                        Span element$iv;
                        span = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        ++token_index;
                        Span[] spanArray2 = this.sentences.get(docId);
                        Intrinsics.checkNotNull(spanArray2);
                        if (sentence_index >= ((Object[])spanArray2).length) break block12;
                        int n2 = span.getFrom();
                        Span[] spanArray3 = this.sentences.get(docId);
                        Intrinsics.checkNotNull(spanArray3);
                        if (n2 < spanArray3[sentence_index].getTo()) break block13;
                    }
                    output.append("\n");
                    token_index = 1;
                    output.append(this.tokenOffsetsInSentence(this.sentences, docId, ++sentence_index, real_token_index, this.tokens));
                }
                if (((CharSequence)this.extractAttributesRegex).length() > 0 && this.extraFeatures.get(docId) != null) {
                    int n3 = span.getFrom() + 1;
                    for (int i2 = previousSpanStart; i2 < n3; ++i2) {
                        Map<String, String> map2 = this.extraFeatures.get(docId);
                        boolean bl = map2 != null ? map2.containsKey(String.valueOf(i2)) : false;
                        if (!bl) continue;
                        Map<String, String> map3 = this.extraFeatures.get(docId);
                        Intrinsics.checkNotNull(map3);
                        output.append(map3.get(String.valueOf(i2)));
                        Map<String, String> map4 = this.extraFeatures.get(docId);
                        Intrinsics.checkNotNull(map4);
                        map4.remove(String.valueOf(i2));
                    }
                    previousSpanStart = span.getFrom() + 1;
                }
                Map<String, MorphoSpan> map5 = this.morpho.get(docId);
                boolean bl = map5 != null ? map5.containsKey(span.getFrom() + "-" + span.getTo()) : false;
                if (bl) {
                    Map<String, MorphoSpan> map6 = this.morpho.get(docId);
                    Intrinsics.checkNotNull(map6);
                    MorphoSpan mfs = map6.get(span.getFrom() + "-" + span.getTo());
                    int n4 = span.getTo();
                    NonBmpString nonBmpString = this.texts.get(docId);
                    Intrinsics.checkNotNull(nonBmpString);
                    if (n4 > nonBmpString.length()) {
                        NonBmpString nonBmpString2 = this.texts.get(docId);
                        Intrinsics.checkNotNull(nonBmpString2);
                        span.setTo(nonBmpString2.length());
                        int n5 = span.getFrom();
                        int n6 = span.getTo();
                        NonBmpString nonBmpString3 = this.texts.get(docId);
                        Intrinsics.checkNotNull(nonBmpString3);
                        this.LOGGER.warning("Offset error: could not retrieve token at " + n5 + "-" + n6 + " \u2013 ending with: " + ((Object)((CharSequence)nonBmpString3).subSequence(span.getFrom(), span.getTo())).toString());
                    }
                    NonBmpString nonBmpString4 = this.texts.get(docId);
                    Intrinsics.checkNotNull(nonBmpString4);
                    String string = ((Object)((CharSequence)nonBmpString4).subSequence(span.getFrom(), span.getTo())).toString();
                    MorphoSpan morphoSpan = mfs;
                    Intrinsics.checkNotNull(morphoSpan);
                    String string2 = morphoSpan.getLemma();
                    Intrinsics.checkNotNull(string2);
                    String string3 = mfs.getUpos();
                    Intrinsics.checkNotNull(string3);
                    String string4 = mfs.getXpos();
                    Intrinsics.checkNotNull(string4);
                    String string5 = mfs.getFeats();
                    Intrinsics.checkNotNull(string5);
                    String string6 = mfs.getHead();
                    Intrinsics.checkNotNull(string6);
                    String string7 = mfs.getDeprel();
                    Intrinsics.checkNotNull(string7);
                    String string8 = mfs.getDeps();
                    Intrinsics.checkNotNull(string8);
                    String string9 = mfs.getMisc();
                    Intrinsics.checkNotNull(string9);
                    v29 = output.append(this.printConlluToken(token_index, string, string2, string3, string4, string5, string6, string7, string8, string9, this.columns));
                } else {
                    NonBmpString nonBmpString = this.texts.get(docId);
                    Intrinsics.checkNotNull(nonBmpString);
                    v29 = output.append(KorapXmlTool.printConlluToken$default(this, token_index, ((Object)((CharSequence)nonBmpString).subSequence(span.getFrom(), span.getTo())).toString(), null, null, null, null, null, null, null, null, this.columns, 1020, null));
                }
                ++real_token_index;
            }
        }
        return output;
    }

    private final StringBuilder lmTrainingOutput(String docId) {
        StringBuilder output;
        block13: {
            int token_index = 0;
            int real_token_index = 0;
            int sentence_index = 0;
            output = null;
            output = new StringBuilder();
            if (!((Collection)this.extractMetadataRegex).isEmpty()) {
                Object object = this.metadata.get(docId);
                if (object == null || (object = ArraysKt.joinToString$default(object, (CharSequence)"\t", null, (CharSequence)"\t", 0, null, null, 58, null)) == null) {
                    object = "";
                }
                output.append((String)object);
            }
            if (this.texts.get(docId) == null) {
                return output;
            }
            Span[] spanArray = this.tokens.get(docId);
            if (spanArray == null) break block13;
            Span[] $this$forEach$iv = spanArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Span span;
                block14: {
                    block15: {
                        Span element$iv;
                        span = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        ++token_index;
                        if (this.sentences.get(docId) == null) break block14;
                        Span[] spanArray2 = this.sentences.get(docId);
                        Intrinsics.checkNotNull(spanArray2);
                        if (sentence_index >= ((Object[])spanArray2).length) break block15;
                        int n2 = span.getFrom();
                        Span[] spanArray3 = this.sentences.get(docId);
                        Intrinsics.checkNotNull(spanArray3);
                        if (n2 < spanArray3[sentence_index].getTo()) break block14;
                    }
                    if (((CharSequence)output).length() > 0) {
                        output.setCharAt(output.length() - 1, '\n');
                    } else {
                        output.append("\n");
                    }
                    if (!((Collection)this.extractMetadataRegex).isEmpty()) {
                        Span[] spanArray4 = this.tokens.get(docId);
                        Intrinsics.checkNotNull(spanArray4);
                        if (real_token_index < ((Object[])spanArray4).length - 1) {
                            Object object = this.metadata.get(docId);
                            if (object == null || (object = ArraysKt.joinToString$default(object, (CharSequence)"\t", null, (CharSequence)"\t", 0, null, null, 58, null)) == null) {
                                object = "";
                            }
                            output.append((String)object);
                        }
                    }
                    ++sentence_index;
                }
                String[] stringArray = new String[2];
                NonBmpString nonBmpString = this.texts.get(docId);
                Intrinsics.checkNotNull(nonBmpString);
                stringArray[0] = ((Object)((CharSequence)nonBmpString).subSequence(span.getFrom(), span.getTo())).toString();
                stringArray[1] = " ";
                StringsKt.append(output, stringArray);
                ++real_token_index;
            }
        }
        if (((CharSequence)output).length() > 0) {
            output.deleteCharAt(output.length() - 1);
        }
        return output;
    }

    private final String printConlluToken(int token_index, String token, String lemma, String upos, String xpos, String feats, String head, String deprel, String deps, String misc, int columns) {
        String myUpos = this.COMPATIBILITY_MODE && Intrinsics.areEqual(upos, "_") ? xpos : upos;
        return switch (columns) {
            case 1 -> token + "\n";
            case 10 -> token_index + "\t" + token + "\t" + lemma + "\t" + myUpos + "\t" + xpos + "\t" + feats + "\t" + head + "\t" + deprel + "\t" + deps + "\t" + misc + this.tokenSeparator;
            default -> {
                Object[] var13_13 = new Object[]{token_index, token, lemma, myUpos, xpos, feats, head, deprel, deps, misc};
                yield CollectionsKt.joinToString$default(ArraysKt.slice(var13_13, RangesKt.until(0, Math.min(columns, 10))), "\t", null, this.tokenSeparator, 0, null, null, 58, null);
            }
        };
    }

    static /* synthetic */ String printConlluToken$default(KorapXmlTool korapXmlTool, int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            string2 = "_";
        }
        if ((n3 & 8) != 0) {
            string3 = "_";
        }
        if ((n3 & 0x10) != 0) {
            string4 = "_";
        }
        if ((n3 & 0x20) != 0) {
            string5 = "_";
        }
        if ((n3 & 0x40) != 0) {
            string6 = "_";
        }
        if ((n3 & 0x80) != 0) {
            string7 = "_";
        }
        if ((n3 & 0x100) != 0) {
            string8 = "_";
        }
        if ((n3 & 0x200) != 0) {
            string9 = "_";
        }
        if ((n3 & 0x400) != 0) {
            n2 = 10;
        }
        return korapXmlTool.printConlluToken(n, string, string2, string3, string4, string5, string6, string7, string8, string9, n2);
    }

    private final String tokenOffsetsInSentence(ConcurrentHashMap<String, Span[]> sentences, String docId, int sentence_index, int token_index, ConcurrentHashMap<String, Span[]> tokens) {
        block4: {
            block3: {
                if (sentences.get(docId) == null) break block3;
                Span[] spanArray = sentences.get(docId);
                Intrinsics.checkNotNull(spanArray);
                if (((Object[])spanArray).length > sentence_index) break block4;
            }
            return "";
        }
        Span[] spanArray = sentences.get(docId);
        Intrinsics.checkNotNull(spanArray);
        int sentenceEndOffset = spanArray[sentence_index].getTo();
        int i = token_index;
        StringBuilder start_offsets_string = new StringBuilder();
        StringBuilder end_offsets_string = new StringBuilder();
        while (tokens.get(docId) != null) {
            Span[] spanArray2 = tokens.get(docId);
            Intrinsics.checkNotNull(spanArray2);
            if (i >= ((Object[])spanArray2).length) break;
            Span[] spanArray3 = tokens.get(docId);
            Intrinsics.checkNotNull(spanArray3);
            if (spanArray3[i].getTo() > sentenceEndOffset) break;
            Object[] objectArray = new Object[2];
            objectArray[0] = " ";
            Span[] spanArray4 = tokens.get(docId);
            Intrinsics.checkNotNull(spanArray4);
            objectArray[1] = spanArray4[i].getFrom();
            StringsKt.append(start_offsets_string, objectArray);
            objectArray = new Object[2];
            objectArray[0] = " ";
            Span[] spanArray5 = tokens.get(docId);
            Intrinsics.checkNotNull(spanArray5);
            objectArray[1] = spanArray5[i].getTo();
            StringsKt.append(end_offsets_string, objectArray);
            ++i;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objectArray = new Object[8];
        objectArray[0] = "# start_offsets = ";
        Span[] spanArray6 = tokens.get(docId);
        Intrinsics.checkNotNull(spanArray6);
        objectArray[1] = spanArray6[token_index].getFrom();
        objectArray[2] = start_offsets_string;
        objectArray[3] = "\n";
        objectArray[4] = "# end_offsets = ";
        objectArray[5] = sentenceEndOffset;
        objectArray[6] = end_offsets_string;
        objectArray[7] = "\n";
        String string = StringsKt.append(stringBuilder, objectArray).toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private final Span[] extractSpans(NodeList spans) {
        A[] AArray = IntStream.range(0, spans.getLength()).mapToObj(spans::item).filter(arg_0 -> KorapXmlTool.extractSpans$lambda$34(KorapXmlTool::extractSpans$lambda$33, arg_0)).map(arg_0 -> KorapXmlTool.extractSpans$lambda$36(arg_0 -> KorapXmlTool.extractSpans$lambda$35(this, arg_0), arg_0)).toArray(KorapXmlTool::extractSpans$lambda$37);
        Intrinsics.checkNotNullExpressionValue(AArray, "toArray(...)");
        return (Span[])AArray;
    }

    private final Map<String, MorphoSpan> extractMorphoSpans(NodeList fsSpans) {
        Regex UNKNOWN = new Regex("(UNKNOWN|<unknown>)");
        Map res = new HashMap();
        IntStream.range(0, fsSpans.getLength()).mapToObj(fsSpans::item).filter(arg_0 -> KorapXmlTool.extractMorphoSpans$lambda$39(KorapXmlTool::extractMorphoSpans$lambda$38, arg_0)).forEach(arg_0 -> KorapXmlTool.extractMorphoSpans$lambda$43(arg_0 -> KorapXmlTool.extractMorphoSpans$lambda$42(res, UNKNOWN, arg_0), arg_0));
        return res;
    }

    private final Span[] extractSentenceSpans(NodeList spans) {
        A[] AArray = IntStream.range(0, spans.getLength()).mapToObj(spans::item).filter(arg_0 -> KorapXmlTool.extractSentenceSpans$lambda$45(KorapXmlTool::extractSentenceSpans$lambda$44, arg_0)).map(arg_0 -> KorapXmlTool.extractSentenceSpans$lambda$47(KorapXmlTool::extractSentenceSpans$lambda$46, arg_0)).toArray(KorapXmlTool::extractSentenceSpans$lambda$48);
        Intrinsics.checkNotNullExpressionValue(AArray, "toArray(...)");
        return (Span[])AArray;
    }

    private final Map<String, String> extractMiscSpans(NodeList spans) {
        Map miscLocal = new HashMap();
        IntStream.range(0, spans.getLength()).mapToObj(spans::item).filter(arg_0 -> KorapXmlTool.extractMiscSpans$lambda$50(KorapXmlTool::extractMiscSpans$lambda$49, arg_0)).forEach(arg_0 -> KorapXmlTool.extractMiscSpans$lambda$54(arg_0 -> KorapXmlTool.extractMiscSpans$lambda$53(miscLocal, this, arg_0), arg_0));
        return miscLocal;
    }

    private static final Unit korapxml2conllu$lambda$0(KorapXmlTool this$0, Ref.ObjectRef $zips, String zipFilePath) {
        String string = zipFilePath;
        if (string == null) {
            string = "";
        }
        this$0.processZipFile(string.toString(), this$0.getFoundryFromZipFileNames((String[])$zips.element));
        return Unit.INSTANCE;
    }

    private static final void korapxml2conllu$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit korapxml2conllu$lambda$2(KorapXmlTool this$0, Ref.ObjectRef $zips, String zipFilePath) {
        String string = zipFilePath;
        if (string == null) {
            string = "";
        }
        this$0.processZipFileSequentially(string.toString(), this$0.getFoundryFromZipFileNames((String[])$zips.element));
        return Unit.INSTANCE;
    }

    private static final void korapxml2conllu$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean processZipFile$lambda$10$lambda$9$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void processZipFile$lambda$10$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit processZipFile$lambda$10(KorapXmlTool this$0, String $foundry, String zip2) {
        Closeable closeable = new ZipFile(zip2);
        Throwable throwable = null;
        try {
            ZipFile zipFile = (ZipFile)closeable;
            boolean bl = false;
            ((Stream)zipFile.stream().filter(arg_0 -> KorapXmlTool.processZipFile$lambda$10$lambda$9$lambda$7(new Function1(this$0){
                final /* synthetic */ KorapXmlTool this$0;
                {
                    this.this$0 = $receiver;
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public final Boolean invoke(ZipEntry it) {
                    boolean bl;
                    if (!(!((Collection)this.this$0.getExtractMetadataRegex()).isEmpty())) {
                        String string = it.getName();
                        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                        if (StringsKt.contains$default((CharSequence)string, "header.xml", false, 2, null)) {
                            bl = false;
                            return bl;
                        }
                    }
                    bl = true;
                    return bl;
                }
            }, arg_0)).parallel()).forEach(arg_0 -> KorapXmlTool.processZipFile$lambda$10$lambda$9$lambda$8(new Function1(this$0, zipFile, $foundry){
                final /* synthetic */ KorapXmlTool this$0;
                final /* synthetic */ ZipFile $zipFile;
                final /* synthetic */ String $foundry;
                {
                    this.this$0 = $receiver;
                    this.$zipFile = $zipFile;
                    this.$foundry = $foundry;
                }

                public final void invoke(ZipEntry zipEntry) {
                    Intrinsics.checkNotNull(zipEntry);
                    this.this$0.processZipEntry(this.$zipFile, this.$foundry, zipEntry, true);
                }
            }, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return Unit.INSTANCE;
    }

    private static final void processZipFile$lambda$11(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean processZipFile$lambda$14$lambda$12(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void processZipFile$lambda$14$lambda$13(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean processZipFileSequentially$lambda$18$lambda$17$lambda$15(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void processZipFileSequentially$lambda$18$lambda$17$lambda$16(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit processZipFileSequentially$lambda$18(KorapXmlTool this$0, String $foundry, String zip2) {
        Closeable closeable = new ZipFile(zip2);
        Throwable throwable = null;
        try {
            ZipFile zipFile = (ZipFile)closeable;
            boolean bl = false;
            ((Stream)zipFile.stream().filter(arg_0 -> KorapXmlTool.processZipFileSequentially$lambda$18$lambda$17$lambda$15(new Function1(this$0){
                final /* synthetic */ KorapXmlTool this$0;
                {
                    this.this$0 = $receiver;
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public final Boolean invoke(ZipEntry it) {
                    boolean bl;
                    if (!(!((Collection)this.this$0.getExtractMetadataRegex()).isEmpty())) {
                        String string = it.getName();
                        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                        if (StringsKt.contains$default((CharSequence)string, "header.xml", false, 2, null)) {
                            bl = false;
                            return bl;
                        }
                    }
                    bl = true;
                    return bl;
                }
            }, arg_0)).parallel()).forEach(arg_0 -> KorapXmlTool.processZipFileSequentially$lambda$18$lambda$17$lambda$16(new Function1(this$0, zipFile, $foundry){
                final /* synthetic */ KorapXmlTool this$0;
                final /* synthetic */ ZipFile $zipFile;
                final /* synthetic */ String $foundry;
                {
                    this.this$0 = $receiver;
                    this.$zipFile = $zipFile;
                    this.$foundry = $foundry;
                }

                public final void invoke(ZipEntry zipEntry) {
                    Intrinsics.checkNotNull(zipEntry);
                    this.this$0.processZipEntry(this.$zipFile, this.$foundry, zipEntry, true);
                }
            }, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return Unit.INSTANCE;
    }

    private static final void processZipFileSequentially$lambda$19(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean processZipFileSequentially$lambda$22$lambda$20(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void processZipFileSequentially$lambda$22$lambda$21(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean extractSpans$lambda$33(Node node) {
        return node instanceof Element;
    }

    private static final boolean extractSpans$lambda$34(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Object extractSpans$lambda$35(KorapXmlTool this$0, Node node) {
        Object object;
        try {
            Intrinsics.checkNotNull(node, "null cannot be cast to non-null type org.w3c.dom.Element");
            object = new Span(Integer.parseInt(((Element)node).getAttribute("from")), Integer.parseInt(((Element)node).getAttribute("to")));
        }
        catch (NumberFormatException e) {
            Logger logger = this$0.LOGGER;
            Intrinsics.checkNotNull(node, "null cannot be cast to non-null type org.w3c.dom.Element");
            logger.warning("Error parsing span: \"" + ((Element)node).getAttribute("from") + "-" + ((Element)node).getAttribute("to") + "\"");
            object = Unit.INSTANCE;
        }
        return object;
    }

    private static final Object extractSpans$lambda$36(Function1 $tmp0, Object p0) {
        return $tmp0.invoke(p0);
    }

    private static final Span[] extractSpans$lambda$37(int size) {
        return new Span[size];
    }

    private static final boolean extractMorphoSpans$lambda$38(Node node) {
        return node instanceof Element && !Intrinsics.areEqual(((Element)node).getAttribute("type"), "alt");
    }

    private static final boolean extractMorphoSpans$lambda$39(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit extractMorphoSpans$lambda$42$lambda$40(MorphoSpan $fs, Regex $UNKNOWN, Node feature) {
        block29: {
            Intrinsics.checkNotNull(feature, "null cannot be cast to non-null type org.w3c.dom.Element");
            String attr = ((Element)feature).getAttribute("name");
            String string = ((Element)feature).getTextContent();
            Intrinsics.checkNotNullExpressionValue(string, "getTextContent(...)");
            String value = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (((CharSequence)value).length() == 0) {
                return Unit.INSTANCE;
            }
            String string2 = attr;
            if (string2 == null) break block29;
            int n = -1;
            switch (string2.hashCode()) {
                case 3686108: {
                    if (string2.equals("xpos")) {
                        n = 1;
                    }
                    break;
                }
                case 111188: {
                    if (string2.equals("pos")) {
                        n = 1;
                    }
                    break;
                }
                case 102857384: {
                    if (string2.equals("lemma")) {
                        n = 2;
                    }
                    break;
                }
                case 3596735: {
                    if (string2.equals("upos")) {
                        n = 3;
                    }
                    break;
                }
                case 3063895: {
                    if (string2.equals("ctag")) {
                        n = 1;
                    }
                    break;
                }
                case -1404142937: {
                    if (string2.equals("certainty")) {
                        n = 4;
                    }
                    break;
                }
                case 3575610: {
                    if (string2.equals("type")) {
                        n = 5;
                    }
                    break;
                }
                case 97304961: {
                    if (string2.equals("feats")) {
                        n = 6;
                    }
                    break;
                }
                case 108414: {
                    if (string2.equals("msd")) {
                        n = 6;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    if (!Intrinsics.areEqual($fs.getLemma(), "_")) break;
                    CharSequence charSequence = value;
                    String string3 = "--";
                    $fs.setLemma($UNKNOWN.replace(charSequence, string3));
                    break;
                }
                case 3: {
                    $fs.setUpos(value);
                    break;
                }
                case 1: {
                    if (!Intrinsics.areEqual($fs.getXpos(), "_")) break;
                    CharSequence charSequence = value;
                    String string4 = "--";
                    $fs.setXpos($UNKNOWN.replace(charSequence, string4));
                    break;
                }
                case 6: {
                    if (!Intrinsics.areEqual($fs.getFeats(), "_")) break;
                    $fs.setFeats(value);
                    break;
                }
                case 5: {
                    if (!Intrinsics.areEqual($fs.getFeats(), "_")) break;
                    String string5 = ((Element)feature).getElementsByTagName("symbol").item(0).getAttributes().getNamedItem("value").getTextContent();
                    Intrinsics.checkNotNullExpressionValue(string5, "getTextContent(...)");
                    $fs.setFeats(((Object)StringsKt.trim((CharSequence)string5)).toString());
                    break;
                }
                case 4: {
                    if (!Intrinsics.areEqual($fs.getMisc(), "_")) break;
                    $fs.setMisc(value);
                }
            }
        }
        return Unit.INSTANCE;
    }

    private static final void extractMorphoSpans$lambda$42$lambda$41(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit extractMorphoSpans$lambda$42(Map $res, Regex $UNKNOWN, Node node) {
        Intrinsics.checkNotNull(node, "null cannot be cast to non-null type org.w3c.dom.Element");
        NodeList features = ((Element)node).getElementsByTagName("f");
        MorphoSpan fs = new MorphoSpan(null, null, null, null, null, null, null, null, 255, null);
        String fromTo = ((Element)node).getAttribute("from") + "-" + ((Element)node).getAttribute("to");
        IntStream.range(0, features.getLength()).mapToObj(features::item).forEach(arg_0 -> KorapXmlTool.extractMorphoSpans$lambda$42$lambda$41(arg_0 -> KorapXmlTool.extractMorphoSpans$lambda$42$lambda$40(fs, $UNKNOWN, arg_0), arg_0));
        $res.put(fromTo, fs);
        return Unit.INSTANCE;
    }

    private static final void extractMorphoSpans$lambda$43(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean extractSentenceSpans$lambda$44(Node node) {
        return node instanceof Element && ((Element)node).getElementsByTagName("f").item(0).getTextContent().equals("s");
    }

    private static final boolean extractSentenceSpans$lambda$45(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Span extractSentenceSpans$lambda$46(Node node) {
        Intrinsics.checkNotNull(node, "null cannot be cast to non-null type org.w3c.dom.Element");
        return new Span(Integer.parseInt(((Element)node).getAttribute("from")), Integer.parseInt(((Element)node).getAttribute("to")));
    }

    private static final Span extractSentenceSpans$lambda$47(Function1 $tmp0, Object p0) {
        return (Span)$tmp0.invoke(p0);
    }

    private static final Span[] extractSentenceSpans$lambda$48(int size) {
        return new Span[size];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean extractMiscSpans$lambda$49(Node node) {
        if (!(node instanceof Element)) return false;
        if (((Element)node).getElementsByTagName("f").getLength() <= 1) return false;
        Node node2 = ((Element)node).getElementsByTagName("f").item(0);
        Intrinsics.checkNotNull(node2, "null cannot be cast to non-null type org.w3c.dom.Element");
        if (!((Element)node2).getAttribute("name").equals("name")) return false;
        Node node3 = ((Element)node).getElementsByTagName("f").item(1);
        Intrinsics.checkNotNull(node3, "null cannot be cast to non-null type org.w3c.dom.Element");
        if (!((Element)node3).getAttribute("name").equals("attr")) return false;
        return true;
    }

    private static final boolean extractMiscSpans$lambda$50(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit extractMiscSpans$lambda$53$lambda$51(String $elementName, KorapXmlTool this$0, StringBuilder $res, Node attr) {
        Intrinsics.checkNotNull(attr, "null cannot be cast to non-null type org.w3c.dom.Element");
        String attrName = $elementName + "/" + ((Element)attr).getAttribute("name");
        CharSequence charSequence = attrName;
        if (new Regex(this$0.extractAttributesRegex).matches(charSequence)) {
            $res.append("# " + attrName + " = " + ((Element)attr).getTextContent() + "\n");
        }
        return Unit.INSTANCE;
    }

    private static final void extractMiscSpans$lambda$53$lambda$52(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit extractMiscSpans$lambda$53(Map $miscLocal, KorapXmlTool this$0, Node node) {
        if (node == null) {
            return Unit.INSTANCE;
        }
        String string = ((Element)node).getElementsByTagName("f").item(0).getTextContent();
        Intrinsics.checkNotNullExpressionValue(string, "getTextContent(...)");
        String elementName = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String from = ((Element)node).getAttribute("from");
        Node node2 = ((Element)node).getElementsByTagName("f").item(1);
        Intrinsics.checkNotNull(node2, "null cannot be cast to non-null type org.w3c.dom.Element");
        NodeList attributes = ((Element)node2).getElementsByTagName("f");
        StringBuilder res = new StringBuilder();
        IntStream.range(0, attributes.getLength()).mapToObj(attributes::item).forEach(arg_0 -> KorapXmlTool.extractMiscSpans$lambda$53$lambda$52(arg_0 -> KorapXmlTool.extractMiscSpans$lambda$53$lambda$51(elementName, this$0, res, arg_0), arg_0));
        if (((CharSequence)res).length() > 0) {
            if ($miscLocal.containsKey(from)) {
                $miscLocal.put(from, "" + $miscLocal.get(from) + res);
            } else {
                $miscLocal.put(from, res.toString());
            }
        }
        return Unit.INSTANCE;
    }

    private static final void extractMiscSpans$lambda$54(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001c\u0018\u00002\u00020\u0001Bg\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u000b\u0010\fR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0010R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000e\"\u0004\b\u0018\u0010\u0010R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000e\"\u0004\b\u001a\u0010\u0010R\u001c\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000e\"\u0004\b\u001c\u0010\u0010R\u001c\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000e\"\u0004\b\u001e\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lde/ids_mannheim/korapxmltools/KorapXmlTool$MorphoSpan;", "", "lemma", "", "upos", "xpos", "feats", "head", "deprel", "deps", "misc", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getLemma", "()Ljava/lang/String;", "setLemma", "(Ljava/lang/String;)V", "getUpos", "setUpos", "getXpos", "setXpos", "getFeats", "setFeats", "getHead", "setHead", "getDeprel", "setDeprel", "getDeps", "setDeps", "getMisc", "setMisc", "app"})
    public static final class MorphoSpan {
        @Nullable
        private String lemma;
        @Nullable
        private String upos;
        @Nullable
        private String xpos;
        @Nullable
        private String feats;
        @Nullable
        private String head;
        @Nullable
        private String deprel;
        @Nullable
        private String deps;
        @Nullable
        private String misc;

        public MorphoSpan(@Nullable String lemma, @Nullable String upos, @Nullable String xpos, @Nullable String feats, @Nullable String head, @Nullable String deprel, @Nullable String deps, @Nullable String misc) {
            this.lemma = lemma;
            this.upos = upos;
            this.xpos = xpos;
            this.feats = feats;
            this.head = head;
            this.deprel = deprel;
            this.deps = deps;
            this.misc = misc;
        }

        public /* synthetic */ MorphoSpan(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "_";
            }
            if ((n & 2) != 0) {
                string2 = "_";
            }
            if ((n & 4) != 0) {
                string3 = "_";
            }
            if ((n & 8) != 0) {
                string4 = "_";
            }
            if ((n & 0x10) != 0) {
                string5 = "_";
            }
            if ((n & 0x20) != 0) {
                string6 = "_";
            }
            if ((n & 0x40) != 0) {
                string7 = "_";
            }
            if ((n & 0x80) != 0) {
                string8 = "_";
            }
            this(string, string2, string3, string4, string5, string6, string7, string8);
        }

        @Nullable
        public final String getLemma() {
            return this.lemma;
        }

        public final void setLemma(@Nullable String string) {
            this.lemma = string;
        }

        @Nullable
        public final String getUpos() {
            return this.upos;
        }

        public final void setUpos(@Nullable String string) {
            this.upos = string;
        }

        @Nullable
        public final String getXpos() {
            return this.xpos;
        }

        public final void setXpos(@Nullable String string) {
            this.xpos = string;
        }

        @Nullable
        public final String getFeats() {
            return this.feats;
        }

        public final void setFeats(@Nullable String string) {
            this.feats = string;
        }

        @Nullable
        public final String getHead() {
            return this.head;
        }

        public final void setHead(@Nullable String string) {
            this.head = string;
        }

        @Nullable
        public final String getDeprel() {
            return this.deprel;
        }

        public final void setDeprel(@Nullable String string) {
            this.deprel = string;
        }

        @Nullable
        public final String getDeps() {
            return this.deps;
        }

        public final void setDeps(@Nullable String string) {
            this.deps = string;
        }

        @Nullable
        public final String getMisc() {
            return this.misc;
        }

        public final void setMisc(@Nullable String string) {
            this.misc = string;
        }

        public MorphoSpan() {
            this(null, null, null, null, null, null, null, null, 255, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lde/ids_mannheim/korapxmltools/KorapXmlTool$OutputFormatConverter;", "Lpicocli/CommandLine$ITypeConverter;", "Lde/ids_mannheim/korapxmltools/OutputFormat;", "<init>", "()V", "convert", "value", "", "app"})
    public static final class OutputFormatConverter
    implements CommandLine.ITypeConverter<OutputFormat> {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public OutputFormat convert(@Nullable String value) {
            String string;
            String string2 = value;
            if (string2 != null) {
                String string3 = string2;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                String string4 = string3.toLowerCase(locale);
                v3 = string4;
                Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
            } else {
                v3 = string = null;
            }
            if (string == null) throw new IllegalArgumentException("Unknown output format: `" + value + "'. Use one of: " + CollectionsKt.joinToString$default(OutputFormat.getEntries(), ", ", null, null, 0, null, OutputFormatConverter::convert$lambda$0, 30, null));
            int n = -1;
            switch (string.hashCode()) {
                case 120609: {
                    if (string.equals("zip")) {
                        n = 1;
                    }
                    break;
                }
                case 94844546: {
                    if (string.equals("conll")) {
                        n = 2;
                    }
                    break;
                }
                case 102236221: {
                    if (string.equals("korap")) {
                        n = 1;
                    }
                    break;
                }
                case 118807: {
                    if (string.equals("xml")) {
                        n = 1;
                    }
                    break;
                }
                case 116027: {
                    if (string.equals("w2v")) {
                        n = 3;
                    }
                    break;
                }
                case -1354786253: {
                    if (string.equals("conllu")) {
                        n = 2;
                    }
                    break;
                }
                case 27374636: {
                    if (string.equals("word2vec")) {
                        n = 3;
                    }
                    break;
                }
                case 587565754: {
                    if (string.equals("korapxml")) {
                        n = 1;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    OutputFormat outputFormat = OutputFormat.CONLLU;
                    return outputFormat;
                }
                case 3: {
                    OutputFormat outputFormat = OutputFormat.WORD2VEC;
                    return outputFormat;
                }
                case 1: {
                    OutputFormat outputFormat = OutputFormat.KORAPXML;
                    return outputFormat;
                }
                default: {
                    throw new IllegalArgumentException("Unknown output format: `" + value + "'. Use one of: " + CollectionsKt.joinToString$default(OutputFormat.getEntries(), ", ", null, null, 0, null, OutputFormatConverter::convert$lambda$0, 30, null));
                }
            }
        }

        private static final CharSequence convert$lambda$0(OutputFormat it) {
            Intrinsics.checkNotNullParameter((Object)it, "it");
            return it.name();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lde/ids_mannheim/korapxmltools/KorapXmlTool$Span;", "", "from", "", "to", "<init>", "(II)V", "getFrom", "()I", "setFrom", "(I)V", "getTo", "setTo", "app"})
    public static final class Span {
        private int from;
        private int to;

        public Span(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public final int getFrom() {
            return this.from;
        }

        public final void setFrom(int n) {
            this.from = n;
        }

        public final int getTo() {
            return this.to;
        }

        public final void setTo(int n) {
            this.to = n;
        }
    }
}

