/*
 * Decompiled with CFR 0.152.
 */
package experimental.morfessor;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import experimental.morfessor.MeanScorer;
import experimental.morfessor.Scorer;
import experimental.morfessor.Segment;
import experimental.morfessor.Splitter;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import marmot.util.CollectableDouble;
import marmot.util.FileUtils;
import marmot.util.LineIterator;
import marmot.util.StringUtils;
import marmot.util.Trie;

public class CompoundSplitter
implements Serializable,
Splitter {
    private static final long serialVersionUID = 1L;
    private Trie<CollectableDouble> trie_ = new Trie();
    private boolean normalize_;

    public CompoundSplitter(boolean normalize) {
        this.normalize_ = normalize;
    }

    public CompoundSplitter() {
        this(false);
    }

    public void addWord(String word, double count2) {
        if (this.normalize_) {
            word = StringUtils.normalize(word, StringUtils.Mode.lower);
        }
        this.trie_.addWord(word, new CollectableDouble(count2));
    }

    public PriorityQueue<Segment> segment(Segment segment, String compound, int start_index, Scorer scorer) {
        char c;
        PriorityQueue<Segment> queue = new PriorityQueue<Segment>();
        Trie<CollectableDouble> trie = this.trie_;
        for (int i = start_index; i < compound.length() && (trie = trie.getChild(c = compound.charAt(i))) != null; ++i) {
            if (!trie.isTerminal()) continue;
            Segment seg = new Segment(segment, i + 1, trie.getContent().getValue(), scorer);
            if (i + 1 == compound.length()) {
                queue.add(seg);
                continue;
            }
            queue.addAll(this.segment(seg, compound, i + 1, scorer));
        }
        return queue;
    }

    public PriorityQueue<Segment> segment(String compound, Scorer scorer) {
        if (this.normalize_) {
            compound = StringUtils.normalize(compound, StringUtils.Mode.lower);
        }
        return this.segment(null, compound, 0, scorer);
    }

    public Trie<CollectableDouble> getTrie() {
        return this.trie_;
    }

    public static void main(String[] args) throws JSAPException {
        JSAP jsap = new JSAP();
        FlaggedOption opt = new FlaggedOption("vocab-file").setRequired(true).setLongFlag("vocab-file");
        jsap.registerParameter((Parameter)opt);
        opt = new FlaggedOption("splitter-file").setRequired(true).setLongFlag("splitter-file");
        jsap.registerParameter((Parameter)opt);
        opt = new FlaggedOption("min-freq").setRequired(false).setStringParser((StringParser)JSAP.INTEGER_PARSER).setLongFlag("min-freq").setDefault("10");
        jsap.registerParameter((Parameter)opt);
        opt = new FlaggedOption("min-length").setRequired(false).setStringParser((StringParser)JSAP.INTEGER_PARSER).setLongFlag("min-length").setDefault("3");
        jsap.registerParameter((Parameter)opt);
        JSAPResult config = jsap.parse(args);
        if (!config.success()) {
            Iterator errs = config.getErrorMessageIterator();
            while (errs.hasNext()) {
                System.err.println("Error: " + errs.next());
            }
            System.err.println("Usage: ");
            System.err.println(jsap.getUsage());
            System.err.println(jsap.getHelp());
            System.err.println();
            System.exit(1);
        }
        int min_freq = config.getInt("min-freq");
        int min_length = config.getInt("min-length");
        CompoundSplitter splitter = new CompoundSplitter(true);
        splitter.loadFile(config.getString("vocab-file"), min_freq, min_length);
        FileUtils.saveToFile((Serializable)splitter, config.getString("splitter-file"));
    }

    public void loadFile(String filename, int min_freq, int min_length) {
        LineIterator iterator2 = new LineIterator(filename);
        while (iterator2.hasNext()) {
            Object list = iterator2.next();
            String form = (String)list.get(0);
            int freq = Integer.parseInt((String)list.get(1));
            if (freq < min_freq) break;
            if (form.length() < min_length) continue;
            this.addWord(form, freq);
        }
    }

    public List<String> split(String word, Scorer scorer) {
        PriorityQueue<Segment> queue = this.segment(word, scorer);
        if (queue.isEmpty()) {
            return Collections.singletonList(word);
        }
        LinkedList<String> list = new LinkedList<String>();
        Segment segment = queue.poll();
        int from_index = word.length();
        for (Segment run = segment.getPreviousSegment(); run != null; run = run.getPreviousSegment()) {
            int to_index = run.getIndex();
            String morph = word.substring(to_index, from_index);
            list.add(0, morph);
            from_index = to_index;
        }
        String morph = word.substring(0, from_index);
        list.add(0, morph);
        return list;
    }

    @Override
    public List<String> split(String form) {
        return this.split(form, new MeanScorer());
    }
}

