/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.plkexport;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.ids_mannheim.korap.plkexport.ExWSConf;
import de.ids_mannheim.korap.plkexport.Exporter;
import de.ids_mannheim.korap.plkexport.Match;
import de.ids_mannheim.korap.plkexport.MatchAggregator;
import de.ids_mannheim.korap.plkexport.Snippet;
import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.Properties;

public class RtfExporter
extends MatchAggregator
implements Exporter {
    private Properties prop = ExWSConf.properties(null);
    private static final String HLINE = "{\\pard\\brdrb\\brdrs\\brdrw2\\brsp20\\par}\n";
    private static final ObjectMapper mapper = new ObjectMapper();
    static final CharsetEncoder charsetEncoder = Charset.forName("Windows-1252").newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);

    @Override
    public String getMimeType() {
        return "application/rtf";
    }

    @Override
    public String getSuffix() {
        return "rtf";
    }

    @Override
    public void writeHeader(Writer w) throws IOException {
        String footnote = this.prop.getProperty("rtf.footnote");
        w.append("{").append("\\rtf1\\ansi\\deff0\n").append("{\\colortbl;\\red0\\green0\\blue0;\\red127\\green127\\blue127;\\red255\\green255\\blue255;}\n").append("{\\fonttbl{\\f0\\fcharset0 Times New Roman;}{\\f1\\fcharset1 Courier;}}\n");
        w.append("{\\footer\\pard\\qr\\fs18\\f0 ");
        if (footnote != null && footnote.length() > 0) {
            RtfExporter.rtfText(w, footnote);
            w.append(" \\endash  ");
        }
        w.append("\\chpgn /{\\field{\\*\\fldinst{\\fs18\\f0 NUMPAGES}}}");
        w.append("\\par}\n");
        if (this.getQueryString() != null) {
            w.append("{\\pard\\fs28\\b\\f1\\ldblquote ");
            RtfExporter.rtfText(w, this.getQueryString());
            w.append("\\rdblquote\\par}");
        }
        w.append("\n{\\pard \\par}\n");
        this.addInfoTable(w);
    }

    @Override
    public void writeFooter(Writer w) throws IOException {
        String trail = this.prop.getProperty("rtf.trail");
        if (trail != null && trail.length() > 0) {
            w.append(HLINE).append("\\par {\\pard\\fs18\\f0 ");
            RtfExporter.rtfText(w, trail);
            w.append("\\par}\n");
        }
        w.append(HLINE).append("}");
    }

    @Override
    public void addMatch(JsonNode n, Writer w) throws IOException {
        try {
            Match match = mapper.treeToValue((TreeNode)n, Match.class);
            Snippet s = match.getSnippet();
            w.append("\\line ");
            if (s != null) {
                w.append("{\\pard\\fs20\\f0\\qj ");
                if (s.hasMoreLeft()) {
                    w.append("[...] ");
                }
                RtfExporter.rtfText(w, s.getLeft());
                w.append("{\\b ");
                RtfExporter.rtfText(w, s.getMark());
                if (s.isCutted()) {
                    w.append(" [!]");
                }
                w.append("}");
                RtfExporter.rtfText(w, s.getRight());
                if (s.hasMoreRight()) {
                    w.append(" [...]");
                }
                w.append("\\par}");
            }
            w.append("{\\pard");
            w.append("\\qr\\fs18\\cf2\\f0 ");
            w.append("{\\b ");
            RtfExporter.rtfText(w, match.getTitle());
            if (match.getAuthor() != null) {
                w.append(" von ");
                RtfExporter.rtfText(w, match.getAuthor());
            }
            if (match.getPubDate() != null) {
                w.append(" (");
                RtfExporter.rtfText(w, match.getPubDate());
                w.append(")");
            }
            w.append("}");
            w.append("\\par}");
            w.append("{\\pard\\qr\\b\\fs18\\cf2\\f1 [");
            RtfExporter.rtfText(w, match.getTextSigle());
            w.append("]\\par}");
            w.append("\n");
        }
        catch (JsonProcessingException jpe) {
            System.err.println(jpe);
            w.append("{\\pard {\\b Unable to process match} \\par}");
        }
    }

    private void addInfoTable(Writer w) throws IOException {
        String q = this.getQueryString();
        if (q != null && q.length() > 0) {
            this.addInfoRow(w, "Query", this.getQueryString());
        }
        if ((q = this.getCorpusQueryString()) != null && q.length() > 0) {
            this.addInfoRow(w, "Corpus", q);
        }
        if (this.getTotalResults() != -1) {
            StringBuilder str = new StringBuilder(32);
            if (this.hasTimeExceeded()) {
                str.append("> ");
            }
            str.append(Integer.toString(this.getTotalResults()));
            if (this.hasTimeExceeded()) {
                str.append(" (Time exceeded)");
            }
            this.addInfoRow(w, "Number of results", str.toString());
        }
        if (this.getTotalResults() == -1 || this.getTotalResults() > this.getMaxResults()) {
            this.addInfoRow(w, "Fetched", this.getMaxResults());
        }
        if ((q = this.getSource()) != null && q.length() > 0) {
            this.addInfoRow(w, "Source", q);
        }
        if (this.getMeta() != null && this.getMeta().has("version")) {
            this.addInfoRow(w, "Backend-Version", this.getMeta().get("version").asText());
        }
        this.addInfoRow(w, "Export-Version", this.getVersion().toString());
    }

    private void addInfoRow(Writer w, String title, int value) throws IOException {
        this.addInfoRow(w, title, Integer.toString(value));
    }

    private void addInfoRow(Writer w, String title, String value) throws IOException {
        w.append("{\\trowd\\trql\\lttrow").append("\\clbrdrt\\brdrs\\clbrdrl\\brdrs\\clbrdrb\\brdrs").append("\\clpadl80\\clpadt80\\clpadb80\\clpadr80\\clcbpat2\\cellx2240").append("\\clbrdrt\\brdrs\\clbrdrl\\brdrs\\clbrdrb\\brdrs\\clbrdrr\\brdrs").append("\\clpadl80\\clpadt80\\clpadb80\\clpadr80\\cellx9300").append("\\intbl\\cf3\\fs18\\b1\\f1 ");
        RtfExporter.rtfText(w, title);
        w.append(":\\cell\\cf0\\fs18\\b0\\f1 ");
        RtfExporter.rtfText(w, value);
        w.append("\\cell\\row}\n");
    }

    private Version getVersion() {
        return new Version(0, 2, 7, null, null, null);
    }

    private static void rtfText(Writer w, String rawText) throws IOException {
        if (rawText == null) {
            return;
        }
        charsetEncoder.reset();
        for (int i = 0; i < rawText.length(); ++i) {
            char c = rawText.charAt(i);
            if (c == '\n') {
                w.append("\\par\n");
                continue;
            }
            if (c == '\t') {
                w.append("\\tab\n");
                continue;
            }
            if (c == '\\') {
                w.append("\\\\");
                continue;
            }
            if (c == '{') {
                w.append("\\{");
                continue;
            }
            if (c == '}') {
                w.append("\\}");
                continue;
            }
            if (c < '\u007f') {
                w.append(c);
                continue;
            }
            w.append("\\u").append(Integer.toString(c));
            if (!charsetEncoder.canEncode(c)) {
                w.append("?");
            }
            try {
                ByteBuffer bytes = charsetEncoder.encode(CharBuffer.wrap(String.valueOf(c)));
                int unsignedCharByte = bytes.get() & 0xFF;
                w.append(String.format("\\'%02x", unsignedCharByte));
                continue;
            }
            catch (CharacterCodingException characterCodingException) {
                // empty catch block
            }
        }
    }
}

