/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.util.Objects;
import org.apache.maven.surefire.booter.SystemUtils;

public final class JdkAttributes {
    private final File jvmExecutable;
    private final File jdkHome;
    private final boolean java9AtLeast;

    public JdkAttributes(File jvmExecutable, File jdkHome, boolean java9AtLeast) {
        this.jvmExecutable = Objects.requireNonNull(jvmExecutable, "null path to java executable");
        this.jdkHome = jdkHome;
        this.java9AtLeast = java9AtLeast;
    }

    public JdkAttributes(String jvmExecutable, boolean java9AtLeast) {
        this(new File(jvmExecutable), SystemUtils.toJdkHomeFromJvmExec(jvmExecutable), java9AtLeast);
    }

    public File getJvmExecutable() {
        return this.jvmExecutable;
    }

    public File getJdkHome() {
        return this.jdkHome;
    }

    public boolean isJava9AtLeast() {
        return this.java9AtLeast;
    }
}

