/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient.output;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.surefire.booterclient.output.MultipleFailureException;
import org.apache.maven.surefire.api.event.Event;
import org.apache.maven.surefire.api.util.internal.DaemonThreadFactory;
import org.apache.maven.surefire.extensions.EventHandler;

public final class ThreadedStreamConsumer
implements EventHandler<Event>,
Closeable {
    private static final Event END_ITEM = new FinalEvent();
    private static final int ITEM_LIMIT_BEFORE_SLEEP = 10000;
    private final BlockingQueue<Event> items = new ArrayBlockingQueue<Event>(10000);
    private final AtomicBoolean stop = new AtomicBoolean();
    private final Thread thread;
    private final Pumper pumper;

    public ThreadedStreamConsumer(EventHandler<Event> target) {
        this.pumper = new Pumper(target);
        this.thread = DaemonThreadFactory.newDaemonThread(this.pumper, "ThreadedStreamConsumer");
        this.thread.start();
    }

    @Override
    public void handleEvent(@Nonnull Event event) {
        if (this.stop.get()) {
            return;
        }
        if (!this.thread.isAlive()) {
            this.items.clear();
            return;
        }
        try {
            this.items.put(event);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.stop.compareAndSet(false, true)) {
            try {
                this.items.put(END_ITEM);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.pumper.hasErrors()) {
            this.pumper.throwErrors();
        }
    }

    private boolean shouldStopQueueing(Event item) {
        return item == END_ITEM;
    }

    private static class FinalEvent
    extends Event {
        FinalEvent() {
            super(null);
        }

        @Override
        public boolean isControlCategory() {
            return false;
        }

        @Override
        public boolean isConsoleCategory() {
            return false;
        }

        @Override
        public boolean isConsoleErrorCategory() {
            return false;
        }

        @Override
        public boolean isStandardStreamCategory() {
            return false;
        }

        @Override
        public boolean isSysPropCategory() {
            return false;
        }

        @Override
        public boolean isTestCategory() {
            return false;
        }

        @Override
        public boolean isJvmExitError() {
            return false;
        }
    }

    final class Pumper
    implements Runnable {
        private final EventHandler<Event> target;
        private final MultipleFailureException errors = new MultipleFailureException();

        Pumper(EventHandler<Event> target) {
            this.target = target;
        }

        @Override
        public void run() {
            while (!ThreadedStreamConsumer.this.stop.get() || !ThreadedStreamConsumer.this.items.isEmpty()) {
                try {
                    Event item = (Event)ThreadedStreamConsumer.this.items.take();
                    if (ThreadedStreamConsumer.this.shouldStopQueueing(item)) {
                        return;
                    }
                    this.target.handleEvent(item);
                }
                catch (Throwable t) {
                    this.errors.addException(t);
                }
            }
        }

        boolean hasErrors() {
            return this.errors.hasNestedExceptions();
        }

        void throwErrors() throws IOException {
            throw this.errors;
        }
    }
}

