/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.maven.plugin.surefire.StartupReportConfiguration;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.log.api.Level;
import org.apache.maven.plugin.surefire.report.NullConsoleOutputReceiver;
import org.apache.maven.plugin.surefire.report.NullConsoleReporter;
import org.apache.maven.plugin.surefire.report.NullFileReporter;
import org.apache.maven.plugin.surefire.report.NullStatelessXmlReporter;
import org.apache.maven.plugin.surefire.report.NullStatisticsReporter;
import org.apache.maven.plugin.surefire.report.ReportEntryType;
import org.apache.maven.plugin.surefire.report.TestMethodStats;
import org.apache.maven.plugin.surefire.report.TestSetRunListener;
import org.apache.maven.plugin.surefire.report.TestSetStats;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.plugin.surefire.runorder.StatisticsReporter;
import org.apache.maven.surefire.api.report.ReporterFactory;
import org.apache.maven.surefire.api.report.RunListener;
import org.apache.maven.surefire.api.report.StackTraceWriter;
import org.apache.maven.surefire.api.suite.RunResult;
import org.apache.maven.surefire.api.util.internal.ObjectUtils;
import org.apache.maven.surefire.extensions.ConsoleOutputReportEventListener;
import org.apache.maven.surefire.extensions.StatelessReportEventListener;
import org.apache.maven.surefire.extensions.StatelessTestsetInfoConsoleReportEventListener;
import org.apache.maven.surefire.extensions.StatelessTestsetInfoFileReportEventListener;
import org.apache.maven.surefire.report.RunStatistics;
import org.apache.maven.surefire.shared.utils.logging.MessageBuilder;
import org.apache.maven.surefire.shared.utils.logging.MessageUtils;

public class DefaultReporterFactory
implements ReporterFactory {
    private final Collection<TestSetRunListener> listeners = new ConcurrentLinkedQueue<TestSetRunListener>();
    private final StartupReportConfiguration reportConfiguration;
    private final ConsoleLogger consoleLogger;
    private final Integer forkNumber;
    private RunStatistics globalStats = new RunStatistics();
    private Map<String, List<TestMethodStats>> flakyTests;
    private Map<String, List<TestMethodStats>> failedTests;
    private Map<String, List<TestMethodStats>> errorTests;

    public DefaultReporterFactory(StartupReportConfiguration reportConfiguration, ConsoleLogger consoleLogger) {
        this(reportConfiguration, consoleLogger, null);
    }

    public DefaultReporterFactory(StartupReportConfiguration reportConfiguration, ConsoleLogger consoleLogger, Integer forkNumber) {
        this.reportConfiguration = reportConfiguration;
        this.consoleLogger = consoleLogger;
        this.forkNumber = forkNumber;
    }

    @Override
    public RunListener createReporter() {
        TestSetRunListener testSetRunListener = new TestSetRunListener(this.createConsoleReporter(), this.createFileReporter(), this.createSimpleXMLReporter(), this.createConsoleOutputReceiver(), this.createStatisticsReporter(), this.reportConfiguration.isTrimStackTrace(), "plain".equals(this.reportConfiguration.getReportFormat()), this.reportConfiguration.isBriefOrPlainFormat());
        this.addListener(testSetRunListener);
        return testSetRunListener;
    }

    public File getReportsDirectory() {
        return this.reportConfiguration.getReportsDirectory();
    }

    private StatelessTestsetInfoConsoleReportEventListener<WrappedReportEntry, TestSetStats> createConsoleReporter() {
        StatelessTestsetInfoConsoleReportEventListener<WrappedReportEntry, TestSetStats> consoleReporter = this.reportConfiguration.instantiateConsoleReporter(this.consoleLogger);
        return ObjectUtils.useNonNull(consoleReporter, NullConsoleReporter.INSTANCE);
    }

    private StatelessTestsetInfoFileReportEventListener<WrappedReportEntry, TestSetStats> createFileReporter() {
        StatelessTestsetInfoFileReportEventListener<WrappedReportEntry, TestSetStats> fileReporter = this.reportConfiguration.instantiateFileReporter(this.forkNumber);
        return ObjectUtils.useNonNull(fileReporter, NullFileReporter.INSTANCE);
    }

    private StatelessReportEventListener<WrappedReportEntry, TestSetStats> createSimpleXMLReporter() {
        StatelessReportEventListener<WrappedReportEntry, TestSetStats> xmlReporter = this.reportConfiguration.instantiateStatelessXmlReporter(this.forkNumber);
        return ObjectUtils.useNonNull(xmlReporter, NullStatelessXmlReporter.INSTANCE);
    }

    private ConsoleOutputReportEventListener createConsoleOutputReceiver() {
        ConsoleOutputReportEventListener outputReporter = this.reportConfiguration.instantiateConsoleOutputFileReporter(this.forkNumber);
        return ObjectUtils.useNonNull(outputReporter, NullConsoleOutputReceiver.INSTANCE);
    }

    private StatisticsReporter createStatisticsReporter() {
        StatisticsReporter statisticsReporter = this.reportConfiguration.getStatisticsReporter();
        return ObjectUtils.useNonNull(statisticsReporter, NullStatisticsReporter.INSTANCE);
    }

    public void mergeFromOtherFactories(Collection<DefaultReporterFactory> factories) {
        for (DefaultReporterFactory factory : factories) {
            this.listeners.addAll(factory.listeners);
        }
    }

    final void addListener(TestSetRunListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public RunResult close() {
        this.mergeTestHistoryResult();
        this.runCompleted();
        for (TestSetRunListener listener : this.listeners) {
            listener.close();
        }
        return this.globalStats.getRunResult();
    }

    public void runStarting() {
        if (this.reportConfiguration.isPrintSummary()) {
            this.log("");
            this.log("-------------------------------------------------------");
            this.log(" T E S T S");
            this.log("-------------------------------------------------------");
        }
    }

    private void runCompleted() {
        if (this.reportConfiguration.isPrintSummary()) {
            this.log("");
            this.log("Results:");
            this.log("");
        }
        boolean printedFailures = this.printTestFailures(TestResultType.failure);
        boolean printedErrors = this.printTestFailures(TestResultType.error);
        boolean printedFlakes = this.printTestFailures(TestResultType.flake);
        if (this.reportConfiguration.isPrintSummary()) {
            if (printedFailures | printedErrors | printedFlakes) {
                this.log("");
            }
            boolean hasSuccessful = this.globalStats.getCompletedCount() > 0;
            boolean hasSkipped = this.globalStats.getSkipped() > 0;
            this.log(this.globalStats.getSummary(), hasSuccessful, printedFailures, printedErrors, hasSkipped, printedFlakes);
            this.log("");
        }
    }

    public RunStatistics getGlobalRunStatistics() {
        this.mergeTestHistoryResult();
        return this.globalStats;
    }

    static TestResultType getTestResultType(List<ReportEntryType> reportEntries, int rerunFailingTestsCount) {
        if (reportEntries == null || reportEntries.isEmpty()) {
            return TestResultType.unknown;
        }
        boolean seenSuccess = false;
        boolean seenFailure = false;
        boolean seenError = false;
        for (ReportEntryType resultType : reportEntries) {
            if (resultType == ReportEntryType.SUCCESS) {
                seenSuccess = true;
                continue;
            }
            if (resultType == ReportEntryType.FAILURE) {
                seenFailure = true;
                continue;
            }
            if (resultType != ReportEntryType.ERROR) continue;
            seenError = true;
        }
        if (seenFailure || seenError) {
            if (seenSuccess && rerunFailingTestsCount > 0) {
                return TestResultType.flake;
            }
            return seenError ? TestResultType.error : TestResultType.failure;
        }
        if (seenSuccess) {
            return TestResultType.success;
        }
        return TestResultType.skipped;
    }

    private void mergeTestHistoryResult() {
        this.globalStats = new RunStatistics();
        this.flakyTests = new TreeMap<String, List<TestMethodStats>>();
        this.failedTests = new TreeMap<String, List<TestMethodStats>>();
        this.errorTests = new TreeMap<String, List<TestMethodStats>>();
        HashMap<String, ArrayList<TestMethodStats>> mergedTestHistoryResult = new HashMap<String, ArrayList<TestMethodStats>>();
        for (TestSetRunListener listener : this.listeners) {
            for (TestMethodStats testMethodStats : listener.getTestMethodStats()) {
                ArrayList<TestMethodStats> currentMethodStats = (ArrayList<TestMethodStats>)mergedTestHistoryResult.get(testMethodStats.getTestClassMethodName());
                if (currentMethodStats == null) {
                    currentMethodStats = new ArrayList<TestMethodStats>();
                    currentMethodStats.add(testMethodStats);
                    mergedTestHistoryResult.put(testMethodStats.getTestClassMethodName(), currentMethodStats);
                    continue;
                }
                currentMethodStats.add(testMethodStats);
            }
        }
        int completedCount = 0;
        int skipped = 0;
        block9: for (Map.Entry entry : mergedTestHistoryResult.entrySet()) {
            List testMethodStats = (List)entry.getValue();
            String testClassMethodName = (String)entry.getKey();
            ++completedCount;
            ArrayList<ReportEntryType> resultTypes = new ArrayList<ReportEntryType>();
            for (TestMethodStats methodStats : testMethodStats) {
                resultTypes.add(methodStats.getResultType());
            }
            switch (DefaultReporterFactory.getTestResultType(resultTypes, this.reportConfiguration.getRerunFailingTestsCount())) {
                case success: {
                    int successCount = 0;
                    for (ReportEntryType type : resultTypes) {
                        if (type != ReportEntryType.SUCCESS) continue;
                        ++successCount;
                    }
                    completedCount += successCount - 1;
                    continue block9;
                }
                case skipped: {
                    ++skipped;
                    continue block9;
                }
                case flake: {
                    this.flakyTests.put(testClassMethodName, testMethodStats);
                    continue block9;
                }
                case failure: {
                    this.failedTests.put(testClassMethodName, testMethodStats);
                    continue block9;
                }
                case error: {
                    this.errorTests.put(testClassMethodName, testMethodStats);
                    continue block9;
                }
            }
            throw new IllegalStateException("Get unknown test result type");
        }
        this.globalStats.set(completedCount, this.errorTests.size(), this.failedTests.size(), skipped, this.flakyTests.size());
    }

    boolean printTestFailures(TestResultType type) {
        Level level;
        Map<String, List<TestMethodStats>> testStats;
        switch (type) {
            case failure: {
                testStats = this.failedTests;
                level = Level.FAILURE;
                break;
            }
            case error: {
                testStats = this.errorTests;
                level = Level.FAILURE;
                break;
            }
            case flake: {
                testStats = this.flakyTests;
                level = Level.UNSTABLE;
                break;
            }
            default: {
                return false;
            }
        }
        boolean printed = false;
        if (!testStats.isEmpty()) {
            this.log(type.getLogPrefix(), level);
            printed = true;
        }
        for (Map.Entry<String, List<TestMethodStats>> entry : testStats.entrySet()) {
            List<TestMethodStats> testMethodStats = entry.getValue();
            if (testMethodStats.size() == 1) {
                this.failure("  " + testMethodStats.get(0).getStackTraceWriter().smartTrimmedStackTrace());
                continue;
            }
            this.log(entry.getKey(), level);
            for (int i = 0; i < testMethodStats.size(); ++i) {
                StackTraceWriter failureStackTrace = testMethodStats.get(i).getStackTraceWriter();
                if (failureStackTrace == null) {
                    this.success("  Run " + (i + 1) + ": PASS");
                    continue;
                }
                this.failure("  Run " + (i + 1) + ": " + failureStackTrace.smartTrimmedStackTrace());
            }
            this.log("");
        }
        return printed;
    }

    private void log(String s, boolean success, boolean failures, boolean errors, boolean skipped, boolean flakes) {
        Level level = Level.resolveLevel(success, failures, errors, skipped, flakes);
        this.log(s, level);
    }

    private void log(String s, Level level) {
        switch (level) {
            case FAILURE: {
                this.failure(s);
                break;
            }
            case UNSTABLE: {
                this.warning(s);
                break;
            }
            case SUCCESS: {
                this.success(s);
                break;
            }
            default: {
                this.info(s);
            }
        }
    }

    private void log(String s) {
        this.consoleLogger.info(s);
    }

    private void info(String s) {
        MessageBuilder builder = MessageUtils.buffer();
        this.consoleLogger.info(builder.a(s).toString());
    }

    private void warning(String s) {
        MessageBuilder builder = MessageUtils.buffer();
        this.consoleLogger.warning(builder.warning(s).toString());
    }

    private void success(String s) {
        MessageBuilder builder = MessageUtils.buffer();
        this.consoleLogger.info(builder.success(s).toString());
    }

    private void failure(String s) {
        MessageBuilder builder = MessageUtils.buffer();
        this.consoleLogger.error(builder.failure(s).toString());
    }

    static enum TestResultType {
        error("Errors: "),
        failure("Failures: "),
        flake("Flakes: "),
        success("Success: "),
        skipped("Skipped: "),
        unknown("Unknown: ");

        private final String logPrefix;

        private TestResultType(String logPrefix) {
            this.logPrefix = logPrefix;
        }

        public String getLogPrefix() {
            return this.logPrefix;
        }
    }
}

