/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.dependencies.resolve.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.artifact.filter.resolve.transform.EclipseAetherFilterTransformer;
import org.apache.maven.shared.transfer.dependencies.DependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolverException;
import org.apache.maven.shared.transfer.dependencies.resolve.internal.Invoker;
import org.apache.maven.shared.transfer.dependencies.resolve.internal.Maven31ArtifactResult;
import org.apache.maven.shared.transfer.dependencies.resolve.internal.Maven31DependencyResolverException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;

@Component(role=DependencyResolver.class, hint="maven31")
class Maven31DependencyResolver
implements DependencyResolver {
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;

    Maven31DependencyResolver() {
    }

    @Override
    public Iterable<org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult> resolveDependencies(ProjectBuildingRequest buildingRequest, DependableCoordinate coordinate, TransformableFilter dependencyFilter) throws DependencyResolverException {
        ArtifactTypeRegistry typeRegistry = (ArtifactTypeRegistry)Invoker.invoke(RepositoryUtils.class, "newArtifactTypeRegistry", ArtifactHandlerManager.class, (Object)this.artifactHandlerManager);
        Dependency aetherRoot = Maven31DependencyResolver.toDependency(coordinate, typeRegistry);
        List aetherRepositories = (List)Invoker.invoke(RepositoryUtils.class, "toRepos", List.class, (Object)buildingRequest.getRemoteRepositories());
        CollectRequest request = new CollectRequest(aetherRoot, aetherRepositories);
        return this.resolveDependencies(buildingRequest, aetherRepositories, dependencyFilter, request);
    }

    @Override
    public Iterable<org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult> resolveDependencies(ProjectBuildingRequest buildingRequest, Model model, TransformableFilter dependencyFilter) throws DependencyResolverException {
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(model.getPackaging());
        String extension = artifactHandler != null ? artifactHandler.getExtension() : null;
        DefaultArtifact aetherArtifact = new DefaultArtifact(model.getGroupId(), model.getArtifactId(), extension, model.getVersion());
        Dependency aetherRoot = new Dependency((Artifact)aetherArtifact, null);
        List aetherRepositories = (List)Invoker.invoke(RepositoryUtils.class, "toRepos", List.class, (Object)buildingRequest.getRemoteRepositories());
        CollectRequest request = new CollectRequest(aetherRoot, aetherRepositories);
        ArtifactTypeRegistry typeRegistry = (ArtifactTypeRegistry)Invoker.invoke(RepositoryUtils.class, "newArtifactTypeRegistry", ArtifactHandlerManager.class, (Object)this.artifactHandlerManager);
        ArrayList<Dependency> aetherDependencies = new ArrayList<Dependency>(model.getDependencies().size());
        for (org.apache.maven.model.Dependency mavenDependency : model.getDependencies()) {
            aetherDependencies.add(Maven31DependencyResolver.toDependency(mavenDependency, typeRegistry));
        }
        request.setDependencies(aetherDependencies);
        DependencyManagement mavenDependencyManagement = model.getDependencyManagement();
        if (mavenDependencyManagement != null) {
            ArrayList<Dependency> aetherManagerDependencies = new ArrayList<Dependency>(mavenDependencyManagement.getDependencies().size());
            for (org.apache.maven.model.Dependency mavenDependency : mavenDependencyManagement.getDependencies()) {
                aetherManagerDependencies.add(Maven31DependencyResolver.toDependency(mavenDependency, typeRegistry));
            }
            request.setManagedDependencies(aetherManagerDependencies);
        }
        return this.resolveDependencies(buildingRequest, aetherRepositories, dependencyFilter, request);
    }

    @Override
    public Iterable<org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult> resolveDependencies(ProjectBuildingRequest buildingRequest, Collection<org.apache.maven.model.Dependency> mavenDependencies, Collection<org.apache.maven.model.Dependency> managedMavenDependencies, TransformableFilter filter) throws DependencyResolverException {
        ArtifactTypeRegistry typeRegistry = (ArtifactTypeRegistry)Invoker.invoke(RepositoryUtils.class, "newArtifactTypeRegistry", ArtifactHandlerManager.class, (Object)this.artifactHandlerManager);
        Class[] argClasses = new Class[]{org.apache.maven.model.Dependency.class, ArtifactTypeRegistry.class};
        ArrayList<Dependency> aetherDeps = null;
        if (mavenDependencies != null) {
            aetherDeps = new ArrayList<Dependency>(mavenDependencies.size());
            for (org.apache.maven.model.Dependency dependency : mavenDependencies) {
                Object[] args = new Object[]{dependency, typeRegistry};
                Dependency aetherDependency = (Dependency)Invoker.invoke(RepositoryUtils.class, "toDependency", argClasses, args);
                aetherDeps.add(aetherDependency);
            }
        }
        ArrayList<Dependency> aetherManagedDependencies = null;
        if (managedMavenDependencies != null) {
            aetherManagedDependencies = new ArrayList<Dependency>(managedMavenDependencies.size());
            for (org.apache.maven.model.Dependency mavenDependency : managedMavenDependencies) {
                Object[] args = new Object[]{mavenDependency, typeRegistry};
                Dependency aetherDependency = (Dependency)Invoker.invoke(RepositoryUtils.class, "toDependency", argClasses, args);
                aetherManagedDependencies.add(aetherDependency);
            }
        }
        List list = (List)Invoker.invoke(RepositoryUtils.class, "toRepos", List.class, (Object)buildingRequest.getRemoteRepositories());
        CollectRequest request = new CollectRequest(aetherDeps, aetherManagedDependencies, list);
        return this.resolveDependencies(buildingRequest, list, filter, request);
    }

    private Iterable<org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult> resolveDependencies(ProjectBuildingRequest buildingRequest, List<RemoteRepository> aetherRepositories, TransformableFilter dependencyFilter, CollectRequest request) throws DependencyResolverException {
        try {
            DependencyFilter depFilter = null;
            if (dependencyFilter != null) {
                depFilter = dependencyFilter.transform(new EclipseAetherFilterTransformer());
            }
            DependencyRequest depRequest = new DependencyRequest(request, depFilter);
            RepositorySystemSession session = (RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
            final DependencyResult dependencyResults = this.repositorySystem.resolveDependencies(session, depRequest);
            return new Iterable<org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult>(){

                @Override
                public Iterator<org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult> iterator() {
                    ArrayList<Maven31ArtifactResult> artResults = new ArrayList<Maven31ArtifactResult>(dependencyResults.getArtifactResults().size());
                    for (ArtifactResult artifactResult : dependencyResults.getArtifactResults()) {
                        artResults.add(new Maven31ArtifactResult(artifactResult));
                    }
                    return artResults.iterator();
                }
            };
        }
        catch (DependencyResolutionException e) {
            throw new Maven31DependencyResolverException(e);
        }
    }

    private static Dependency toDependency(DependableCoordinate coordinate, ArtifactTypeRegistry stereotypes) {
        ArtifactType stereotype = stereotypes.get(coordinate.getType());
        if (stereotype == null) {
            stereotype = new DefaultArtifactType(coordinate.getType());
        }
        DefaultArtifact artifact = new DefaultArtifact(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getClassifier(), null, coordinate.getVersion(), null, stereotype);
        return new Dependency((Artifact)artifact, null);
    }

    private static Dependency toDependency(org.apache.maven.model.Dependency root, ArtifactTypeRegistry typeRegistry) throws DependencyResolverException {
        Class[] argClasses = new Class[]{org.apache.maven.model.Dependency.class, ArtifactTypeRegistry.class};
        Object[] args = new Object[]{root, typeRegistry};
        return (Dependency)Invoker.invoke(RepositoryUtils.class, "toDependency", argClasses, args);
    }
}

