/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.api.report;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum RunMode {
    NORMAL_RUN("normal-run"),
    RERUN_TEST_AFTER_FAILURE("rerun-test-after-failure");

    public static final Map<String, RunMode> MODES;
    private final String runName;

    private static Map<String, RunMode> modes() {
        ConcurrentHashMap<String, RunMode> modes = new ConcurrentHashMap<String, RunMode>();
        for (RunMode mode : RunMode.values()) {
            modes.put(mode.geRunName(), mode);
        }
        return Collections.unmodifiableMap(modes);
    }

    private RunMode(String runName) {
        this.runName = runName;
    }

    public String geRunName() {
        return this.runName;
    }

    static {
        MODES = RunMode.modes();
    }
}

