/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.maven.surefire.api.provider.SurefireProvider;
import org.apache.maven.surefire.api.report.ReporterException;
import org.apache.maven.surefire.api.suite.RunResult;
import org.apache.maven.surefire.api.testset.TestSetFailedException;
import org.apache.maven.surefire.api.util.ReflectionUtils;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireReflector;

public class ProviderFactory {
    private final StartupConfiguration startupConfiguration;
    private final ProviderConfiguration providerConfiguration;
    private final ClassLoader classLoader;
    private final SurefireReflector surefireReflector;
    private final Object reporterManagerFactory;
    private static final Class[] INVOKE_PARAMETERS = new Class[]{Object.class};
    private static final Class[] INVOKE_EMPTY_PARAMETER_TYPES = new Class[0];
    private static final Object[] INVOKE_EMPTY_PARAMETERS = new Object[0];

    public ProviderFactory(StartupConfiguration startupConfiguration, ProviderConfiguration providerConfiguration, ClassLoader testsClassLoader, Object reporterManagerFactory) {
        this.providerConfiguration = providerConfiguration;
        this.startupConfiguration = startupConfiguration;
        this.surefireReflector = new SurefireReflector(testsClassLoader);
        this.classLoader = testsClassLoader;
        this.reporterManagerFactory = reporterManagerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RunResult invokeProvider(Object testSet, ClassLoader testsClassLoader, Object factory, ProviderConfiguration providerConfiguration, boolean insideFork, StartupConfiguration startupConfig, boolean restoreStreams) throws TestSetFailedException, InvocationTargetException {
        PrintStream orgSystemOut = System.out;
        PrintStream orgSystemErr = System.err;
        try {
            RunResult runResult = new ProviderFactory(startupConfig, providerConfiguration, testsClassLoader, factory).createProvider(insideFork).invoke(testSet);
            return runResult;
        }
        finally {
            if (restoreStreams && System.getSecurityManager() == null) {
                System.setOut(orgSystemOut);
                System.setErr(orgSystemErr);
            }
        }
    }

    public SurefireProvider createProvider(boolean isInsideFork) {
        Thread currentThread = Thread.currentThread();
        ClassLoader systemClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.classLoader);
        Object o = this.surefireReflector.createBooterConfiguration(this.classLoader, isInsideFork);
        this.surefireReflector.setReporterFactoryAware(o, this.reporterManagerFactory);
        this.surefireReflector.setTestSuiteDefinitionAware(o, this.providerConfiguration.getTestSuiteDefinition());
        this.surefireReflector.setProviderPropertiesAware(o, this.providerConfiguration.getProviderProperties());
        this.surefireReflector.setReporterConfigurationAware(o, this.providerConfiguration.getReporterConfiguration());
        this.surefireReflector.setTestClassLoaderAware(o, this.classLoader);
        this.surefireReflector.setTestArtifactInfoAware(o, this.providerConfiguration.getTestArtifact());
        this.surefireReflector.setRunOrderParameters(o, this.providerConfiguration.getRunOrderParameters());
        this.surefireReflector.setIfDirScannerAware(o, this.providerConfiguration.getDirScannerParams());
        this.surefireReflector.setMainCliOptions(o, this.providerConfiguration.getMainCliOptions());
        this.surefireReflector.setSkipAfterFailureCount(o, this.providerConfiguration.getSkipAfterFailureCount());
        if (isInsideFork) {
            this.surefireReflector.setSystemExitTimeout(o, this.providerConfiguration.getSystemExitTimeout());
        }
        Object provider = this.surefireReflector.instantiateProvider(this.startupConfiguration.getActualClassName(), o);
        currentThread.setContextClassLoader(systemClassLoader);
        return new ProviderProxy(provider, this.classLoader);
    }

    private final class ProviderProxy
    implements SurefireProvider {
        private final Object providerInOtherClassLoader;
        private final ClassLoader testsClassLoader;

        private ProviderProxy(Object providerInOtherClassLoader, ClassLoader testsClassLoader) {
            this.providerInOtherClassLoader = providerInOtherClassLoader;
            this.testsClassLoader = testsClassLoader;
        }

        @Override
        public Iterable<Class<?>> getSuites() {
            ClassLoader current = this.swapClassLoader(this.testsClassLoader);
            try {
                Iterable iterable = (Iterable)ReflectionUtils.invokeGetter(this.providerInOtherClassLoader, "getSuites");
                return iterable;
            }
            finally {
                Thread.currentThread().setContextClassLoader(current);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RunResult invoke(Object forkTestSet) throws ReporterException, InvocationTargetException {
            ClassLoader current = this.swapClassLoader(this.testsClassLoader);
            try {
                Method invoke = ReflectionUtils.getMethod(this.providerInOtherClassLoader.getClass(), "invoke", INVOKE_PARAMETERS);
                Object result = ReflectionUtils.invokeMethodWithArray2(this.providerInOtherClassLoader, invoke, forkTestSet);
                RunResult runResult = (RunResult)ProviderFactory.this.surefireReflector.convertIfRunResult(result);
                return runResult;
            }
            finally {
                if (System.getSecurityManager() == null) {
                    Thread.currentThread().setContextClassLoader(current);
                }
            }
        }

        private ClassLoader swapClassLoader(ClassLoader newClassLoader) {
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(newClassLoader);
            return current;
        }

        @Override
        public void cancel() {
            Class<?> providerType = this.providerInOtherClassLoader.getClass();
            Method invoke = ReflectionUtils.getMethod(providerType, "cancel", INVOKE_EMPTY_PARAMETER_TYPES);
            ReflectionUtils.invokeMethodWithArray(this.providerInOtherClassLoader, invoke, INVOKE_EMPTY_PARAMETERS);
        }
    }
}

