/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.validate.ValidatingFilter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.instruct.DummyNamespaceResolver;
import net.sf.saxon.expr.number.Numberer_en;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.IndexedStack;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Whitespace;

public class IdValidator
extends ValidatingFilter {
    private final IndexedStack<Set<String>> stack = new IndexedStack();
    private int level = 0;
    private final HashSet<String> idValues = new HashSet(100);
    private final HashSet<String> unresolvedRefs = new HashSet(100);
    private IdValueChecker currentElementChecker = null;
    private final UnicodeBuilder buffer = new UnicodeBuilder(32);
    private Location textLocationId = Loc.NONE;
    private final Map<SchemaType, IdValueChecker> checkerMap = new HashMap<SchemaType, IdValueChecker>(10);
    private static final IdValueChecker SimpleIdChecker = (validator, value, locationId) -> validator.processId(Whitespace.trim(value).toString(), locationId);
    private static final IdValueChecker SimpleIdRefChecker = (validator, value, locationId) -> {
        String id = Whitespace.trim(value).toString();
        if (!id.isEmpty() && !validator.idValues.contains(id)) {
            validator.unresolvedRefs.add(id);
        }
    };
    private static final IdValueChecker IdListChecker = (validator, value, locationId) -> {
        String ids = value.toString();
        StringTokenizer tok = new StringTokenizer(ids, " \t\n\r", false);
        while (tok.hasMoreTokens()) {
            String id = tok.nextToken();
            validator.processId(id, locationId);
        }
    };
    private static final IdValueChecker IdRefListChecker = (validator, value, locationId) -> {
        String ids = value.toString();
        StringTokenizer tok = new StringTokenizer(ids, " \t\n\r", false);
        while (tok.hasMoreTokens()) {
            String id = tok.nextToken();
            if (validator.idValues.contains(id)) continue;
            validator.unresolvedRefs.add(id);
        }
    };
    private static final IdValueChecker NonIdChecker = (validator, value, locationId) -> {};

    public IdValidator(Receiver next) {
        super(next);
    }

    @Override
    public void startElement(NodeName elemName, SchemaType typeCode, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        this.currentElementChecker = this.checkerMap.get(typeCode);
        if (this.currentElementChecker == null) {
            this.currentElementChecker = this.allocateChecker(typeCode);
            this.checkerMap.put(typeCode, this.currentElementChecker);
        }
        if (this.currentElementChecker == NonIdChecker) {
            this.currentElementChecker = null;
        }
        this.stack.push(new HashSet(4));
        ++this.level;
        for (AttributeInfo att : attributes) {
            SimpleType type = att.getType();
            IdValueChecker checker = this.checkerMap.get(type);
            if (checker == null) {
                checker = this.allocateChecker(type);
                this.checkerMap.put(type, checker);
            }
            checker.checkValue(this, StringView.of(att.getValue()).tidy(), att.getLocation());
        }
        this.nextReceiver.startElement(elemName, typeCode, attributes, namespaces, location, properties);
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        if (this.currentElementChecker != null) {
            this.buffer.accept(chars);
        }
        this.nextReceiver.characters(chars, locationId, properties);
        this.textLocationId = locationId;
    }

    @Override
    public void endElement() throws XPathException {
        --this.level;
        this.stack.pop();
        if (this.currentElementChecker != null) {
            this.currentElementChecker.checkValue(this, this.buffer.toUnicodeString(), this.textLocationId);
        }
        this.buffer.clear();
        this.currentElementChecker = null;
        this.nextReceiver.endElement();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IdValueChecker allocateChecker(SchemaType type) throws MissingComponentException {
        SimpleType stype;
        int fingerprint = type.getFingerprint();
        switch (fingerprint) {
            case 560: {
                return SimpleIdChecker;
            }
            case 561: {
                return SimpleIdRefChecker;
            }
            case 562: {
                return IdRefListChecker;
            }
        }
        if (fingerprint < 1023) {
            return NonIdChecker;
        }
        Configuration config = this.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        if (type.isComplexType()) {
            if (!((ComplexType)type).isSimpleContent()) return NonIdChecker;
            stype = ((ComplexType)type).getSimpleContentType();
            assert (stype != null);
        } else {
            stype = (SimpleType)type;
        }
        if (type.isAtomicType()) {
            if (type.isIdType()) {
                return SimpleIdChecker;
            }
            if (!type.isIdRefType()) return NonIdChecker;
            return SimpleIdRefChecker;
        }
        if (stype.isListType()) {
            SimpleType componentType = ((ListType)stype).getItemType();
            if (componentType instanceof AtomicType && th.isSubType((AtomicType)componentType, BuiltInAtomicType.ID)) {
                return IdListChecker;
            }
            if (componentType instanceof AtomicType && th.isSubType((AtomicType)componentType, BuiltInAtomicType.IDREF)) {
                return IdRefListChecker;
            }
            if (!type.isIdType() && !type.isIdRefType()) return NonIdChecker;
            return this.getUnionChecker(stype);
        }
        if (!type.isIdType() && !type.isIdRefType()) return NonIdChecker;
        return this.getUnionChecker(stype);
    }

    @Override
    public void endDocument() throws XPathException {
        this.checkUnresolvedRefs();
        this.nextReceiver.endDocument();
    }

    @Override
    public void close() throws XPathException {
        this.nextReceiver.close();
    }

    private void checkUnresolvedRefs() throws XPathException {
        if (!this.unresolvedRefs.isEmpty()) {
            String value;
            String howMany;
            int count = this.unresolvedRefs.size();
            if (count == 1) {
                howMany = " is one";
                value = "value";
            } else {
                Numberer_en num = new Numberer_en();
                num.setTensUnitsSeparatorCardinal("-");
                howMany = " are " + num.toWords("", count, 1);
                value = "values";
            }
            StringBuilder err = new StringBuilder("There" + howMany + " IDREF " + value + " with no corresponding ID");
            if (count > 10) {
                err.append(". First ten:");
            } else {
                err.append(':');
            }
            int i = 0;
            for (String id : this.unresolvedRefs) {
                err.append("\n    ");
                err.append(id);
                if (i++ <= 9) continue;
                break;
            }
            ValidationFailure ve = new ValidationFailure(err.toString());
            ve.setErrorCode(this.getPipelineConfiguration().isXSLT() ? "XTTE1555" : "XQDY0027");
            ve.setConstraintReference(1, "cvc-id", "1");
            this.reportValidationError(ve, Loc.NONE);
        }
    }

    @Override
    public boolean usesTypeAnnotations() {
        return true;
    }

    protected void reportValidationError(ValidationFailure err, Location locationId) throws XPathException {
        PipelineConfiguration pipe = this.getPipelineConfiguration();
        err.setErrorCode(pipe.isXSLT() ? "XTTE1555" : "XQDY0027");
        super.reportValidationError(err, false, locationId);
    }

    private void processId(String id, Location locationId) throws XPathException {
        if (this.level == 0) {
            ValidationFailure ve = new ValidationFailure("An element of type xs:ID must have a parent element within the tree being validated");
            ve.setErrorCode(this.getPipelineConfiguration().isXSLT() ? "XTTE1555" : "XQDY0027");
            ve.setConstraintReference(1, "cvc-id", "2");
            this.reportValidationError(ve, locationId);
            throw ve.makeException();
        }
        if (this.idValues.contains(id)) {
            Set<String> idsForElement = this.stack.get(this.level - 1);
            if (this.getConfiguration().getXsdVersion() == 10 || !idsForElement.contains(id)) {
                ValidationFailure ve = new ValidationFailure("ID value '" + id + "' is not unique");
                ve.setErrorCode(this.getPipelineConfiguration().isXSLT() ? "XTTE1555" : "XQDY0027");
                ve.setConstraintReference(1, "cvc-id", "2");
                this.reportValidationError(ve, locationId);
            }
        } else {
            this.idValues.add(id);
            if (this.level >= 1) {
                this.stack.get(this.level - 1).add(id);
            }
        }
        this.unresolvedRefs.remove(id);
    }

    private IdValueChecker getUnionChecker(SimpleType type) {
        return (validator, value, locationId) -> {
            Configuration config = this.getConfiguration();
            TypeHierarchy th = config.getTypeHierarchy();
            AtomicSequence typedValue = type.getTypedValue(value, DummyNamespaceResolver.getInstance(), config.getConversionRules());
            for (AtomicValue val : typedValue) {
                String idref;
                AtomicType itemType = val.getItemType();
                if (th.isSubType(itemType, BuiltInAtomicType.ID)) {
                    this.processId(val.getStringValue(), locationId);
                    continue;
                }
                if (!th.isSubType(itemType, BuiltInAtomicType.IDREF) || this.idValues.contains(idref = val.getStringValue())) continue;
                this.unresolvedRefs.add(idref);
            }
        };
    }

    @FunctionalInterface
    private static interface IdValueChecker {
        public void checkValue(IdValidator var1, UnicodeString var2, Location var3) throws XPathException;
    }
}

