/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToItemCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.functions.hof.CurriedFunction;
import com.saxonica.functions.hof.PartialApply;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public class PartialApplyCompiler
extends ToItemCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        PartialApplyCompiler.visitAnnotation(compiler, "PartialApplyCompiler - " + expression.getExpressionName());
        PartialApplyCompiler.visitLineNumber(compiler, ga, expression);
        PartialApply pa = (PartialApply)expression;
        compiler.compileToItem(pa.getBaseExpression());
        ga.checkClass(Function.class);
        ga.push(pa.getNumberOfArguments());
        ga.newArray(Type.getType(Sequence.class));
        int valuesVar = methodInfo.allocateLocal(Sequence[].class);
        ga.storeLocal(valuesVar);
        PartialApplyCompiler.visitAnnotation(compiler, "ArrayCreated - ");
        for (int i = 0; i < pa.getNumberOfArguments(); ++i) {
            Expression expr = pa.getArgument(i);
            if (expr == null) {
                ga.loadLocal(valuesVar);
                ga.push(i);
                ga.push((String)null);
                ga.arrayStore(Type.getType(Sequence.class));
                continue;
            }
            ga.loadLocal(valuesVar);
            ga.push(i);
            compiler.compileToIterator(expr);
            ga.invokeInstanceMethod(SequenceIterator.class, "materialize", new Class[0]);
            ga.arrayStore(Type.getType(Sequence.class));
        }
        LabelInfo end = methodInfo.newLabel("endPartialApply");
        LabelInfo L0 = methodInfo.newLabel("L0");
        LabelInfo L1 = methodInfo.newLabel("L1");
        LabelInfo L2 = methodInfo.newLabel("L2");
        ga.visitTryCatchBlock(L0, L1, L2, "net/sf/saxon/trans/XPathException");
        methodInfo.placeLabel(L0);
        ga.newInstance(CurriedFunction.class);
        ga.dup();
        ga.dup2X1();
        ga.pop2();
        ga.loadLocal(valuesVar);
        ga.invokeConstructor(CurriedFunction.class, Function.class, Sequence[].class);
        methodInfo.placeLabel(L1);
        ga.goTo(end.label());
        methodInfo.placeLabel(L2);
        PartialApplyCompiler.visitAnnotation(compiler, "PartialApply-Catch");
        ga.dup();
        PartialApplyCompiler.allocateStatic(compiler, pa.getLocation());
        ga.invokeInstanceMethod(XPathException.class, "maybeSetLocation", Location.class);
        ga.dup();
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathException.class, "maybeSetContext", XPathContext.class);
        ga.throwException();
        methodInfo.placeLabel(end);
        methodInfo.releaseLocal(valuesVar);
    }
}

