/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.AttributeDecl;
import com.saxonica.ee.schema.AttributeGroupDecl;
import com.saxonica.ee.schema.AttributeUse;
import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.ModelGroupDefinition;
import com.saxonica.ee.schema.Notation;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.SchemaStructure;
import com.saxonica.ee.schema.SerializableSchemaComponent;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.schema.UserSimpleType;
import com.saxonica.ee.schema.sdoc.SimpleTypeDefinition;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.CheckSumFilter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.QualifiedNameValue;

public class SchemaModelSerializer {
    private EnterpriseConfiguration config;
    private Receiver receiver;
    private LinkedList<SchemaComponent> pendingComponents = new LinkedList();
    private IdentityHashMap<SchemaComponent, String> componentToIdMap = new IdentityHashMap(200);
    private IdentityHashMap<SerializableSchemaComponent, String> serializedComponents = new IdentityHashMap(200);
    private int nextComponent = 0;
    private boolean inStartTag = false;
    private static FingerprintedQName XML_BASE = new FingerprintedQName("xml", "http://www.w3.org/XML/1998/namespace", "base", 385);

    public SchemaModelSerializer(Configuration config, Receiver out) {
        config.checkLicensedFeature(1, "schema processing", -1);
        this.config = (EnterpriseConfiguration)config;
        NamespaceReducer reducer = new NamespaceReducer(out);
        this.receiver = new CheckSumFilter(reducer);
    }

    public void serialize() throws XPathException {
        SchemaStructure decl;
        this.receiver.open();
        this.receiver.startDocument(0);
        this.startElement("schema");
        this.emitAttribute("generatedAt", DateTimeValue.getCurrentDateTime(null).getStringValue());
        this.emitAttribute("xsdVersion", this.config.getConfigurationProperty(Feature.XSD_VERSION));
        String dmk = this.config.getLicenseFeature("DMK");
        if (dmk != null) {
            this.emitAttribute("dmk", dmk);
        }
        PreparedSchema schema = this.config.getSuperSchema();
        Iterator<SchemaComponent> iter = schema.iterateTypes();
        while (iter.hasNext()) {
            SchemaType type = iter.next();
            if (type instanceof SimpleTypeDefinition) {
                type = ((SimpleTypeDefinition)type).getSimpleType();
            }
            if (!(type instanceof SerializableSchemaComponent)) continue;
            this.serializeComponent((SerializableSchemaComponent)((Object)type));
        }
        iter = schema.iterateElementDeclarations();
        while (iter.hasNext()) {
            decl = (ElementDecl)iter.next();
            this.serializeComponent((SerializableSchemaComponent)((Object)decl));
        }
        iter = schema.iterateAttributeDeclarations();
        while (iter.hasNext()) {
            decl = (AttributeDecl)iter.next();
            this.serializeComponent((SerializableSchemaComponent)((Object)decl));
        }
        iter = schema.iterateModelGroups();
        while (iter.hasNext()) {
            decl = (ModelGroupDefinition)iter.next();
            this.serializeComponent((SerializableSchemaComponent)((Object)decl));
        }
        iter = schema.iterateAttributeGroups();
        while (iter.hasNext()) {
            decl = (AttributeGroupDecl)iter.next();
            this.serializeComponent((SerializableSchemaComponent)((Object)decl));
        }
        iter = schema.iterateNotations();
        while (iter.hasNext()) {
            decl = (Notation)iter.next();
            this.serializeComponent((SerializableSchemaComponent)((Object)decl));
        }
        while (!this.pendingComponents.isEmpty()) {
            SerializableSchemaComponent component = (SerializableSchemaComponent)((Object)this.pendingComponents.getFirst());
            this.serializeComponent(component);
            this.pendingComponents.removeFirst();
        }
        this.endElement();
        if (this.receiver instanceof CheckSumFilter) {
            int c = ((CheckSumFilter)this.receiver).getChecksum();
            this.receiver.processingInstruction("\u03a3", Integer.toHexString(c), ExplicitLocation.UNKNOWN_LOCATION, 0);
        }
        this.receiver.endDocument();
        this.receiver.close();
    }

    public void startElement(String elementName) throws XPathException {
        if (this.inStartTag) {
            this.receiver.startContent();
        }
        this.inStartTag = true;
        FingerprintedQName nc = new FingerprintedQName("scm", "http://ns.saxonica.com/schema-component-model", elementName);
        this.receiver.startElement(nc, Untyped.getInstance(), ExplicitLocation.UNKNOWN_LOCATION, 0);
    }

    public void endElement() throws XPathException {
        if (this.inStartTag) {
            this.receiver.startContent();
            this.inStartTag = false;
        }
        this.receiver.endElement();
    }

    public void emitNamespaceContext(NamespaceResolver resolver) throws XPathException {
        Iterator<String> iter = resolver.iteratePrefixes();
        while (iter.hasNext()) {
            String prefix = iter.next();
            String uri = resolver.getURIForPrefix(prefix, false);
            this.declareNamespace(prefix, uri);
        }
    }

    public void declareNamespace(String prefix, String uri) throws XPathException {
        this.receiver.namespace(new NamespaceBinding(prefix, uri), 0);
    }

    public void emitAttribute(String attributeName, String value) throws XPathException {
        if (!this.inStartTag) {
            throw new IllegalStateException("Attribute emitted when not in start tag");
        }
        NodeName nc = attributeName.equals("xml:base") ? XML_BASE : new NoNamespaceName(attributeName);
        this.receiver.attribute(nc, BuiltInAtomicType.UNTYPED_ATOMIC, value, ExplicitLocation.UNKNOWN_LOCATION, 0);
    }

    public void setIsSerialized(SerializableSchemaComponent component) {
        this.serializedComponents.put(component, "");
    }

    public String getId(SchemaComponent component, boolean forSelf) {
        if (component instanceof SimpleTypeDefinition) {
            throw new IllegalStateException("Unresolved SimpleTypeDefinition found");
        }
        if (component instanceof AttributeUse) {
            throw new IllegalStateException("AttributeUse has no ID");
        }
        if (component instanceof SerializableSchemaComponent) {
            String existing = this.componentToIdMap.get(component);
            if (existing != null) {
                return existing;
            }
            String id = "C" + this.nextComponent++;
            this.componentToIdMap.put(component, id);
            if (!forSelf) {
                this.pendingComponents.add(component);
            }
            return id;
        }
        throw new UnsupportedOperationException(component.getClass().getName());
    }

    private void serializeComponent(SerializableSchemaComponent component) throws XPathException {
        if (this.serializedComponents.get(component) == null) {
            component.serialize(this);
            this.serializedComponents.put(component, "");
        }
    }

    public void emitTypedValue(AtomicSequence value) throws XPathException {
        value.iterate().forEachOrFail(atom -> {
            this.startElement("item");
            BuiltInAtomicType type = atom.getPrimitiveType();
            this.emitAttribute("type", "#" + type.getName());
            this.emitAttribute("value", atom.getStringValue());
            if (atom instanceof QualifiedNameValue) {
                this.emitAttribute("namespace", ((QualifiedNameValue)atom).getNamespaceURI());
            }
            this.endElement();
        });
    }

    public String getTypeLink(SchemaType type) {
        if (type instanceof UserSimpleType || type instanceof UserComplexType) {
            return this.getId(type, false);
        }
        return "#" + type.getName();
    }
}

