/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.ComponentReference;
import com.saxonica.ee.schema.MissingComponentExceptionImpl;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaStructure;
import com.saxonica.ee.schema.UserSimpleType;
import com.saxonica.ee.schema.sdoc.SimpleTypeDefinition;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaType;

public class TypeReference
extends SchemaStructure
implements ComponentReference {
    private StructuredQName qName;
    private int fingerprint;
    private boolean dangling;
    private SchemaType target;

    public TypeReference(int fingerprint, EnterpriseConfiguration config, SourceLocator locator) {
        this.fingerprint = fingerprint;
        this.qName = config.getNamePool().getStructuredQName(fingerprint);
        if (locator != null) {
            this.setLocator(locator);
        }
        if (fingerprint < 1024) {
            this.setTarget(BuiltInType.getSchemaType(fingerprint));
        }
        this.setConfiguration(config);
    }

    @Override
    public boolean isResolved() {
        return this.target != null;
    }

    public void setTarget(SchemaType target) {
        this.target = target;
    }

    public int getTargetFingerprint() {
        return this.fingerprint;
    }

    @Override
    public StructuredQName getTargetComponentName() {
        return this.qName;
    }

    @Override
    public boolean isDangling() {
        return this.dangling;
    }

    @Override
    public int getSymbolSpace() {
        return 803;
    }

    public boolean isAnonymousType() {
        return this.getTargetFingerprint() > 1023 && this.getTargetComponentName().hasURI("http://ns.saxonica.com/anonymous-type");
    }

    @Override
    public SchemaComponent getTarget() throws MissingComponentException {
        UserSimpleType ust;
        if (this.target == null) {
            throw new MissingComponentExceptionImpl(this);
        }
        if (this.target instanceof SimpleTypeDefinition && (ust = ((SimpleTypeDefinition)this.target).getSimpleType()) != null) {
            this.target = ust;
        }
        return this.target;
    }

    @Override
    public void tryToResolve(SchemaCompiler compiler) {
        if (!this.dangling) {
            if (this.target == null) {
                this.target = compiler.getPreparedSchema().getType(this.qName);
            }
            if (this.target == null) {
                this.target = this.getConfiguration().getSuperSchema().getType(this.qName);
            }
            if (this.target == null) {
                this.dangling = true;
            }
        }
    }
}

