/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.doccat;

import java.io.IOException;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;

public class DocumentSampleStream
extends FilterObjectStream<String, DocumentSample> {
    public DocumentSampleStream(ObjectStream<String> samples) {
        super(samples);
    }

    @Override
    public DocumentSample read() throws IOException {
        String sampleString = (String)this.samples.read();
        if (sampleString != null) {
            String[] tokens = WhitespaceTokenizer.INSTANCE.tokenize(sampleString);
            if (tokens.length <= 1) {
                throw new IOException("Empty lines, or lines with only a category string are not allowed!");
            }
            String category = tokens[0];
            String[] docTokens = new String[tokens.length - 1];
            System.arraycopy(tokens, 1, docTokens, 0, tokens.length - 1);
            DocumentSample sample2 = new DocumentSample(category, docTokens);
            return sample2;
        }
        return null;
    }
}

