/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query;

import de.ids_mannheim.korap.query.SimpleSpanQuery;
import de.ids_mannheim.korap.query.spans.SubSpans;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;

public class SpanSubspanQuery
extends SimpleSpanQuery {
    private int startOffset;
    private int length;
    private int windowSize = 10;

    public SpanSubspanQuery(SpanQuery firstClause, int startOffset, int length, boolean collectPayloads) {
        super(firstClause, collectPayloads);
        this.startOffset = startOffset;
        this.length = length;
    }

    @Override
    public SimpleSpanQuery clone() {
        SpanSubspanQuery sq = new SpanSubspanQuery(this.getFirstClause(), this.startOffset, this.length, this.collectPayloads);
        sq.setBoost(this.getBoost());
        return sq;
    }

    @Override
    public Spans getSpans(LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        return new SubSpans(this, context, acceptDocs, termContexts);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("subspan(");
        sb.append(this.firstClause.toString());
        sb.append(", ");
        sb.append(this.startOffset);
        sb.append(", ");
        sb.append(this.length);
        sb.append(")");
        return sb.toString();
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(int startOffset) {
        this.startOffset = startOffset;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }
}

