/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.ids_mannheim.korap.index.AbstractDocument;
import de.ids_mannheim.korap.response.MetaField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Text
extends AbstractDocument {
    private static final Logger log = LoggerFactory.getLogger(Text.class);
    public static final boolean DEBUG = false;
    ObjectMapper mapper = new ObjectMapper();

    @Override
    public String toJsonString() {
        ObjectNode json = (ObjectNode)this.toJsonNode();
        ArrayNode fields = json.putArray("fields");
        for (MetaField mf : this.mFields) {
            fields.add(mf.toJsonNode());
            String mfs = mf.key;
            String value = this.getFieldValue(mfs);
            if (value == null || json.has(mfs)) continue;
            json.set(mfs, new TextNode(value));
        }
        this.addMessage(0, "Support for flat field values is deprecated", new String[0]);
        if (json.size() == 0) {
            return "{}";
        }
        try {
            return this.mapper.writeValueAsString(json);
        }
        catch (Exception e) {
            log.warn(e.getLocalizedMessage());
            return "{}";
        }
    }
}

