/*
 * Decompiled with CFR 0.152.
 */
package chipmunk.segmenter;

import chipmunk.segmenter.Dictionary;
import chipmunk.segmenter.IndexConsumer;
import chipmunk.segmenter.IndexScorer;
import chipmunk.segmenter.IndexUpdater;
import chipmunk.segmenter.SegmentationInstance;
import chipmunk.segmenter.SegmentationReading;
import chipmunk.segmenter.SegmentationResult;
import chipmunk.segmenter.SegmenterOptions;
import chipmunk.segmenter.TagSet;
import chipmunk.segmenter.Word;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import marmot.core.Feature;
import marmot.util.DynamicWeights;
import marmot.util.Encoder;
import marmot.util.SymbolTable;

public class SegmenterModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SymbolTable<String> tag_table_;
    private SymbolTable<Character> char_table_;
    private int max_segment_length_;
    private transient Encoder encoder_;
    private transient Encoder.State encoder_state_;
    private int window_length_bits_;
    private int num_char_bits_;
    private int num_tag_bits_;
    private int max_segment_length_bits_;
    private IndexScorer scorer_;
    private IndexUpdater updater_;
    private static final int FEATURE_BITS = Encoder.bitsNeeded(4);
    private static final int TRANS_FEAT = 0;
    private static final int TAG_FEAT = 1;
    private static final int PAIR_FEAT = 2;
    private static final int CHARACTER_FEAT = 3;
    private static final int DICT_FEAT = 4;
    private List<Dictionary> dictionaries_;
    private int dictionary_bits_;
    private List<List<Integer>> tags_to_subtags_;
    private SegmenterOptions options_;

    /*
     * WARNING - void declaration
     */
    public void init(SegmenterOptions options, Collection<Word> words) {
        this.options_ = options;
        this.tag_table_ = new SymbolTable(true);
        this.char_table_ = new SymbolTable();
        this.max_segment_length_ = 0;
        for (Word word : words) {
            void var5_9;
            for (SegmentationReading reading : word.getReadings()) {
                for (String segment : reading.getSegments()) {
                    assert (segment.length() > 0);
                    if (segment.length() <= this.max_segment_length_) continue;
                    this.max_segment_length_ = segment.length();
                }
                for (String tag : reading.getTags()) {
                    this.tag_table_.toIndex(tag, true);
                }
            }
            boolean bl = false;
            while (var5_9 < word.getWord().length()) {
                char c = word.getWord().charAt((int)var5_9);
                this.char_table_.toIndex(Character.valueOf(c), true);
                ++var5_9;
            }
        }
        this.tags_to_subtags_ = new ArrayList<List<Integer>>();
        for (int i = 0; i < this.tag_table_.size(); ++i) {
            this.tags_to_subtags_.add(null);
        }
        SymbolTable<String> subtag_table = new SymbolTable<String>();
        for (Map.Entry<String, Integer> entry : this.tag_table_.entrySet()) {
            String tag = entry.getKey();
            String[] subtags = TagSet.split(tag);
            LinkedList<Integer> indexes = new LinkedList<Integer>();
            indexes.add(subtag_table.toIndex(tag, true));
            if (subtags.length > 1) {
                for (String subtag : subtags) {
                    indexes.add(subtag_table.toIndex(subtag, true));
                }
            }
            this.tags_to_subtags_.set(entry.getValue(), indexes);
        }
        if (this.options_.getBoolean("verbose").booleanValue()) {
            System.err.println("Tag table: " + this.tag_table_);
            System.err.println("Num tags: " + this.tag_table_.size());
        }
        this.dictionaries_ = new LinkedList<Dictionary>();
        Collection<String> collection = this.options_.getDictionaries();
        for (String path : collection) {
            Dictionary dictionary = new Dictionary(path, this.options_.getString("lang"), this.max_segment_length_);
            if (this.options_.getBoolean("verbose").booleanValue()) {
                System.err.format("Created dictionary with %d entries from %s\n", dictionary.size(), path);
            }
            this.dictionaries_.add(dictionary);
        }
        this.num_tag_bits_ = Encoder.bitsNeeded(subtag_table.size());
        this.num_char_bits_ = Encoder.bitsNeeded(this.char_table_.size());
        this.max_segment_length_bits_ = Encoder.bitsNeeded(this.max_segment_length_);
        this.window_length_bits_ = Encoder.bitsNeeded(this.options_.getInt("max-character-window") + 1);
        if (!this.dictionaries_.isEmpty()) {
            this.dictionary_bits_ = Encoder.bitsNeeded(this.dictionaries_.size());
        }
        SymbolTable<Feature> symbolTable = new SymbolTable<Feature>();
        this.scorer_ = new IndexScorer(null, symbolTable, this.num_tag_bits_);
        this.updater_ = new IndexUpdater(null, symbolTable, this.num_tag_bits_);
    }

    private void prepareEncoder() {
        if (this.encoder_ == null) {
            this.encoder_ = new Encoder(10);
            this.encoder_state_ = new Encoder.State();
        }
        this.encoder_.reset();
    }

    public int getNumTags() {
        return this.tag_table_.size();
    }

    public int getMaxSegmentLength() {
        return this.max_segment_length_;
    }

    public double getPairScore(SegmentationInstance instance, int l_start, int l_end, int tag) {
        this.scorer_.reset();
        this.consumeTagPair(this.scorer_, instance, l_start, l_end, tag);
        return this.scorer_.getScore();
    }

    public double getTransitionScore(SegmentationInstance instance, int last_tag, int tag, int l_start, int l_end) {
        this.scorer_.reset();
        this.consumeTransition(this.scorer_, instance, l_start, l_end, last_tag, tag);
        return this.scorer_.getScore();
    }

    private void consumeTagPair(IndexConsumer consumer, SegmentationInstance instance, int l_start, int l_end, int tag) {
        assert (l_start >= 0 && l_end <= instance.getLength());
        this.consumePairFeature(consumer, instance, l_start, l_end, tag);
        this.consumeCharacterFeature(consumer, instance, l_start, l_end, tag);
        this.consumeTagFeature(consumer, instance, l_start, l_end, tag);
        if (!this.dictionaries_.isEmpty()) {
            String segment = instance.getWord().getWord().substring(l_start, l_end);
            int length = l_end - l_start;
            assert (segment.length() == length);
            assert (length <= this.max_segment_length_);
            int dict_index = 0;
            for (Dictionary dictionary : this.dictionaries_) {
                boolean value = dictionary.contains(segment);
                this.prepareEncoder();
                this.encoder_.append(4, FEATURE_BITS);
                this.encoder_.append(dict_index, this.dictionary_bits_);
                this.encoder_.append(0, this.max_segment_length_bits_);
                this.encoder_.append(value);
                consumer.consume(this.encoder_, this.tags_to_subtags_.get(tag));
                this.prepareEncoder();
                this.encoder_.append(4, FEATURE_BITS);
                this.encoder_.append(dict_index, this.dictionary_bits_);
                this.encoder_.append(length, this.max_segment_length_bits_);
                this.encoder_.append(value);
                consumer.consume(this.encoder_, this.tags_to_subtags_.get(tag));
                ++dict_index;
            }
        }
    }

    private void consumeCharacterFeature(IndexConsumer consumer, SegmentationInstance instance, int l_start, int l_end, int tag) {
        if (this.options_.getBoolean("use-character-feature").booleanValue()) {
            int window;
            short[] chars = instance.getFormCharIndexes(this.char_table_);
            this.prepareEncoder();
            this.encoder_.append(3, FEATURE_BITS);
            this.encoder_.append(0, 2);
            this.encoder_.storeState(this.encoder_state_);
            for (window = 1; window <= this.options_.getInt("max-character-window"); ++window) {
                this.encoder_.restoreState(this.encoder_state_);
                this.addSegment(chars, l_start, l_start + window);
                consumer.consume(this.encoder_, this.tags_to_subtags_.get(tag));
            }
            this.prepareEncoder();
            this.encoder_.append(3, FEATURE_BITS);
            this.encoder_.append(2, 2);
            this.encoder_.storeState(this.encoder_state_);
            for (window = 1; window <= this.options_.getInt("max-character-window"); ++window) {
                this.encoder_.restoreState(this.encoder_state_);
                this.addSegment(chars, l_end - window, l_end);
                consumer.consume(this.encoder_, this.tags_to_subtags_.get(tag));
            }
        }
    }

    private void consumeTransition(IndexConsumer consumer, SegmentationInstance instance, int l_start, int l_end, int last_tag, int tag) {
        this.consumeTransitionFeature(consumer, instance, l_start, l_end, last_tag, tag);
    }

    public void consumeTagFeature(IndexConsumer consumer, SegmentationInstance instance, int l_start, int l_end, int tag) {
        this.prepareEncoder();
        this.encoder_.append(1, FEATURE_BITS);
        consumer.consume(this.encoder_, this.tags_to_subtags_.get(tag));
    }

    public void consumePairFeature(IndexConsumer consumer, SegmentationInstance instance, int l_start, int l_end, int tag) {
        assert (l_start >= 0 && l_end <= instance.getLength());
        this.prepareEncoder();
        short[] chars = instance.getFormCharIndexes(this.char_table_);
        assert (chars.length == instance.getLength());
        this.encoder_.append(2, FEATURE_BITS);
        this.encoder_.append(l_end - l_start, this.max_segment_length_bits_);
        for (int l = l_start; l < l_end; ++l) {
            short c = chars[l];
            if (c < 0) {
                return;
            }
            this.encoder_.append(c, this.num_char_bits_);
        }
        consumer.consume(this.encoder_, this.tags_to_subtags_.get(tag));
        this.addCharacterContext(instance, consumer, l_start, l_end, tag);
    }

    public void consumeTransitionFeature(IndexConsumer consumer, SegmentationInstance instance, int l_start, int l_end, int last_tag, int tag) {
        if (last_tag < 0) {
            return;
        }
        for (int last_subtag : this.tags_to_subtags_.get(last_tag)) {
            this.prepareEncoder();
            this.encoder_.append(0, FEATURE_BITS);
            this.encoder_.append(last_subtag, this.num_tag_bits_);
            consumer.consume(this.encoder_, this.tags_to_subtags_.get(tag));
        }
    }

    public void update(SegmentationInstance instance, SegmentationResult result2, double update) {
        this.updater_.setUpdate(update);
        Iterator<Integer> tag_iterator = result2.getTags().iterator();
        Iterator<Integer> input_iterator = result2.getInputIndexes().iterator();
        int last_tag = -1;
        int l_start = 0;
        while (tag_iterator.hasNext()) {
            int tag = tag_iterator.next();
            int l_end = input_iterator.next();
            assert (l_end <= instance.getLength());
            if (last_tag >= 0) {
                this.consumeTransition(this.updater_, instance, l_start, l_end, last_tag, tag);
            }
            assert (l_start >= 0 && l_end <= instance.getLength());
            this.consumeTagPair(this.updater_, instance, l_start, l_end, tag);
            last_tag = tag;
            l_start = l_end;
        }
    }

    public double getScore(SegmentationInstance instance, SegmentationResult result2) {
        this.scorer_.reset();
        Iterator<Integer> tag_iterator = result2.getTags().iterator();
        Iterator<Integer> input_iterator = result2.getInputIndexes().iterator();
        int last_tag = -1;
        int l_start = 0;
        while (tag_iterator.hasNext()) {
            int tag = tag_iterator.next();
            int l_end = input_iterator.next();
            if (last_tag >= 0) {
                this.consumeTransition(this.scorer_, instance, l_start, l_end, last_tag, tag);
            }
            this.consumeTagPair(this.scorer_, instance, l_start, l_end, tag);
            last_tag = tag;
            l_start = l_end;
        }
        return this.scorer_.getScore();
    }

    public SegmentationInstance getInstance(Word word) {
        LinkedList<SegmentationResult> results = new LinkedList<SegmentationResult>();
        for (SegmentationReading reading : word.getReadings()) {
            ArrayList<Integer> tags = new ArrayList<Integer>();
            for (String tag : reading.getTags()) {
                int tag_index = this.tag_table_.toIndex(tag, -1, false);
                tags.add(tag_index);
            }
            ArrayList<Integer> input_indexes = new ArrayList<Integer>();
            int index = 0;
            for (String segment : reading.getSegments()) {
                assert ((index += segment.length()) <= word.getLength()) : word + " " + reading;
                input_indexes.add(index);
            }
            results.add(new SegmentationResult(tags, input_indexes));
        }
        SegmentationInstance instance = new SegmentationInstance(word, results);
        return instance;
    }

    public void setWeights(DynamicWeights weights) {
        this.setScorerWeights(weights);
        this.setUpdaterWeights(weights);
    }

    public void setScorerWeights(DynamicWeights weights) {
        this.scorer_.setWeights(weights);
    }

    public void setUpdaterWeights(DynamicWeights weights) {
        this.updater_.setWeights(weights);
    }

    public Word toWord(String form, SegmentationResult result2) {
        ArrayList<String> tags = new ArrayList<String>();
        for (int tag_index : result2.getTags()) {
            tags.add(this.tag_table_.toSymbol(tag_index));
        }
        ArrayList<String> segments = new ArrayList<String>();
        int start_index = 0;
        for (int end_index : result2.getInputIndexes()) {
            segments.add(form.substring(start_index, end_index));
            start_index = end_index;
        }
        Word word = new Word(form);
        word.add(new SegmentationReading(segments, tags));
        return word;
    }

    public void update(SegmentationInstance instance, int l_start, int l_end, int tag, double update) {
        this.updater_.setUpdate(update);
        this.consumeTagPair(this.updater_, instance, l_start, l_end, tag);
    }

    public void update(SegmentationInstance instance, int l_start, int l_end, int last_tag, int tag, double update) {
        this.updater_.setUpdate(update);
        this.consumeTransition(this.updater_, instance, l_start, l_end, last_tag, tag);
    }

    public void printWeights() {
        System.err.println(Arrays.toString(this.scorer_.getWeights().getWeights()));
        System.err.println(Arrays.toString(this.updater_.getWeights().getWeights()));
    }

    public void setFinal() {
        this.updater_ = null;
        this.scorer_.setInsert(false);
        this.scorer_.getWeights().setExapnd(false);
        this.encoder_ = null;
    }

    public IndexScorer getScorer() {
        return this.scorer_;
    }

    public IndexUpdater getUpdater() {
        return this.updater_;
    }

    private void addCharacterContext(SegmentationInstance instance, IndexConsumer consumer, int l_start, int l_end, int tag_index) {
        if (this.options_.getBoolean("use-segment-context").booleanValue()) {
            int window;
            this.encoder_.storeState(this.encoder_state_);
            for (window = 1; window <= this.options_.getInt("max-character-window"); ++window) {
                this.encoder_.restoreState(this.encoder_state_);
                this.encoder_.append(0, 1);
                this.addSegment(instance.getFormCharIndexes(this.char_table_), l_start - window, l_start);
                consumer.consume(this.encoder_, this.tags_to_subtags_.get(tag_index));
            }
            for (window = 1; window <= this.options_.getInt("max-character-window"); ++window) {
                this.encoder_.restoreState(this.encoder_state_);
                this.encoder_.append(1, 1);
                this.addSegment(instance.getFormCharIndexes(this.char_table_), l_end, l_end + window);
                consumer.consume(this.encoder_, this.tags_to_subtags_.get(tag_index));
            }
        }
    }

    private void addSegment(short[] chars, int start, int end) {
        this.encoder_.append(end - start, this.window_length_bits_);
        for (int i = start; i < end; ++i) {
            int c = i >= 0 && i < chars.length ? chars[i] : this.char_table_.size();
            if (c < 0) {
                return;
            }
            this.encoder_.append(c, this.num_char_bits_);
        }
    }
}

