/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.LocalVariableBinding;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.InstructionInfo;

public class ClauseInfo
implements InstructionInfo {
    private Clause clause;
    private NamespaceResolver nsResolver;

    public ClauseInfo(Clause clause) {
        this.clause = clause;
    }

    public Clause getClause() {
        return this.clause;
    }

    @Override
    public int getConstructType() {
        return 3000 + this.clause.getClauseKey();
    }

    @Override
    public StructuredQName getObjectName() {
        LocalVariableBinding[] vars = this.clause.getRangeVariables();
        if (vars != null && vars.length > 0) {
            return vars[0].getVariableQName();
        }
        return null;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.nsResolver;
    }

    public void setNamespaceResolver(NamespaceResolver nsResolver) {
        this.nsResolver = nsResolver;
    }

    @Override
    public String getSystemId() {
        return this.clause.getLocation().getSystemId();
    }

    @Override
    public int getLineNumber() {
        return this.clause.getLocation().getLineNumber();
    }

    @Override
    public Location saveLocation() {
        return new ExplicitLocation(this);
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public Iterator<String> getProperties() {
        List ls = Collections.emptyList();
        return ls.iterator();
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }
}

