/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToStringCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.functions.Translate;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntToIntMap;

public class TranslateCompiler
extends ToStringCompiler {
    @Override
    public void compileToPrimitive(CompilerService compiler, Expression expression, Class requiredClass, OnEmpty onEmpty) throws CannotCompileException {
        SystemFunctionCall fnc = (SystemFunctionCall)expression;
        Translate fn = (Translate)fnc.getTargetFunction();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        TranslateCompiler.visitAnnotation(compiler, "Translate-str");
        LabelInfo translateReturn = methodInfo.newLabel("translateReturn");
        compiler.compileToItem(fnc.getArg(0));
        this.returnZeroLengthStringIfNull(fnc.getArg(0), ga, methodInfo, translateReturn, 0);
        ga.checkClass(StringValue.class);
        IntToIntMap staticMap = fn.getStaticMap();
        if (staticMap != null) {
            TranslateCompiler.allocateStatic(compiler, staticMap);
            ga.invokeStaticMethod(Translate.class, "translateUsingMap", StringValue.class, IntToIntMap.class);
        } else {
            compiler.compileToItem(fnc.getArg(1));
            ga.checkClass(StringValue.class);
            compiler.compileToItem(fnc.getArg(2));
            ga.checkClass(StringValue.class);
            ga.invokeStaticMethod(Translate.class, "translate", StringValue.class, StringValue.class, StringValue.class);
        }
        if (requiredClass == String.class) {
            ga.invokeInstanceMethod(CharSequence.class, "toString", new Class[0]);
        }
        methodInfo.placeLabel(translateReturn);
    }
}

