/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.schema.ValueConstraint;
import com.saxonica.ee.validate.AnyTypeValidator;
import com.saxonica.ee.validate.AttributeValidator;
import com.saxonica.ee.validate.ContentValidator;
import com.saxonica.ee.validate.ValidationContext;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationFailure;

public class SimpleContentValidator
extends AttributeValidator {
    private SchemaType schemaType;
    private SimpleType simpleType;
    private ValueConstraint fixedValue = null;
    private CharSequence fixedValueLexicalForm = null;
    private Comparable fixedValueComparable = null;
    private ValueConstraint defaultValue = null;
    private boolean needToValidateConstraint = false;
    private FastStringBuffer buffer = new FastStringBuffer(64);

    public SimpleContentValidator(ElementDecl declaration, SchemaType type, Receiver next) throws MissingComponentException {
        super(next);
        this.setSchemaType(type);
        if (declaration != null) {
            this.defaultValue = declaration.getDefaultValueConstraint();
            this.fixedValue = declaration.getFixedValueConstraint();
            if (this.fixedValue != null) {
                this.fixedValueLexicalForm = this.fixedValue.getLexicalForm();
                this.fixedValueComparable = this.fixedValue.getComparisonKey();
            }
            this.setNillability(declaration.isNillable() ? ContentValidator.Nillability.ALLOWED : ContentValidator.Nillability.DISALLOWED);
            this.needToValidateConstraint = type != declaration.getType();
        } else {
            this.needToValidateConstraint = false;
        }
    }

    @Override
    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaType(SchemaType type) throws MissingComponentException {
        this.schemaType = type;
        if (type.isSimpleType()) {
            this.simpleType = (SimpleType)type;
        } else {
            UserComplexType ctype = (UserComplexType)type;
            this.simpleType = ctype.getSimpleContentType();
            this.setAttributeGroup(ctype.getCombinedAttributeGroup());
        }
        this.setAnnotation(this.schemaType);
        this.needToValidateConstraint = true;
    }

    @Override
    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        String message = "Invalid child element " + Err.wrap(nameCode.getDisplayName(), 1) + ", " + this.getContainingElementName() + " must have simple content";
        ValidationFailure ve = new ValidationFailure(message);
        ve.setConstraintReference(1, "cvc-type", "3.1.2");
        ve.setSchemaType(this.schemaType);
        this.reportValidationError(ve, true, location);
        super.startElement(nameCode, AnyType.getInstance(), location, properties);
    }

    @Override
    protected ContentValidator getChildValidator() {
        return new AnyTypeValidator(this.getNextReceiver());
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.checkNoCharactersWhenNil(locationId);
        this.buffer.append(chars);
        if (this.getNillability() == ContentValidator.Nillability.ALLOWED) {
            properties |= 0x200;
        }
        this.nextReceiver.characters(chars, locationId, properties);
    }

    @Override
    public void endElement() throws XPathException {
        if (this.isNil()) {
            if (!this.buffer.isEmpty()) {
                String message = "The " + this.getContainingElementName() + " has xsi:nil='true' so it cannot have character content";
                ValidationFailure ve = new ValidationFailure(message);
                ve.setSchemaType(this.schemaType);
                ve.setConstraintReference(1, "cvc-elt", "3.2.1");
                this.reportValidationError(ve, true, this.getContainingElementLocationId());
                super.endElement();
                return;
            }
            if (this.fixedValue != null) {
                String message = "The " + this.getContainingElementName() + " has a fixed value so it must not be nil";
                ValidationFailure ve = new ValidationFailure(message);
                ve.setConstraintReference(1, "cvc-elt", "3.2.2");
                ve.setSchemaType(this.schemaType);
                this.reportValidationError(ve, true, this.getContainingElementLocationId());
                super.endElement();
                return;
            }
        } else if (this.defaultValue != null && this.buffer.isEmpty()) {
            ValidationFailure err;
            if (this.needToValidateConstraint && (err = this.simpleType.validateContent(this.defaultValue.getLexicalForm(), this.getNamespaceResolver(), this.getConfiguration().getConversionRules())) != null) {
                String message = "The default value " + Err.wrap(this.defaultValue.getLexicalForm(), 4) + " for " + this.getContainingElementName() + " does not match the type " + this.simpleType.getDescription() + ": " + err.getMessage();
                err.setMessage(message);
                err.setSchemaType(this.simpleType);
                err.setConstraintReference(2, "cvc-datatype-valid", "1");
                this.reportValidationError(err, true, this.getContainingElementLocationId());
                super.endElement();
                return;
            }
            this.characters(this.defaultValue.getLexicalForm(), ExplicitLocation.UNKNOWN_LOCATION, 8);
        } else if (this.fixedValue != null) {
            if (this.buffer.isEmpty()) {
                ValidationFailure err;
                if (this.needToValidateConstraint && (err = this.simpleType.validateContent(this.fixedValueLexicalForm, this.getNamespaceResolver(), this.getConfiguration().getConversionRules())) != null) {
                    String message = "The fixed value " + Err.wrap(this.fixedValueLexicalForm, 4) + " for " + this.getContainingElementName() + " does not match the type " + this.simpleType.getDescription() + ": " + err.getMessage();
                    ValidationFailure ve = new ValidationFailure(message);
                    ve.setSchemaType(this.simpleType);
                    ve.setConstraintReference(2, "cvc-datatype-valid", "1");
                    this.reportValidationError(ve, true, this.getContainingElementLocationId());
                    super.endElement();
                    return;
                }
                this.characters(this.fixedValueLexicalForm, ExplicitLocation.UNKNOWN_LOCATION, 0);
            } else {
                AtomicSequence actual = this.simpleType.getTypedValue(this.buffer, this.getNamespaceResolver(), this.getConfiguration().getConversionRules());
                if (!actual.getSchemaComparable().equals(this.fixedValueComparable)) {
                    String message = "The content " + Err.wrap(this.buffer, 4) + " of " + this.getContainingElementName() + " does not match the fixed value " + Err.wrap(this.fixedValueLexicalForm, 4);
                    ValidationFailure ve = new ValidationFailure(message);
                    ve.setSchemaType(this.simpleType);
                    ve.setConstraintReference(1, "cvc-elt", "5.2.2.2");
                    this.reportValidationError(ve, true, this.getContainingElementLocationId());
                }
            }
        } else {
            ValidationContext rules = this.getValidationContext();
            ValidationFailure err = this.simpleType.validateContent(this.buffer, this.getNamespaceResolver(), rules);
            if (err != null) {
                String message = "The content " + Err.wrap(this.buffer, 4) + " of " + this.getContainingElementName() + " does not match the required simple type. " + err.getMessage();
                ValidationFailure ve = new ValidationFailure(message);
                ve.setSchemaType(this.simpleType);
                ve.setConstraintReference(2, "cvc-datatype-valid", "1");
                this.reportValidationError(ve, true, this.getContainingElementLocationId());
                super.endElement();
                return;
            }
        }
        super.endElement();
    }
}

