/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ptree;

import com.saxonica.config.ProfessionalConfiguration;
import com.saxonica.ptree.PTreeWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.Emitter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class PTreeEmitter
extends Emitter {
    private TinyBuilder builder;

    public PTreeEmitter(PipelineConfiguration pipe) {
        this.builder = new TinyBuilder(pipe);
        this.builder.setStatistics(pipe.getConfiguration().getTreeStatistics().RESULT_TREE_STATISTICS);
        this.setPipelineConfiguration(pipe);
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration config) {
        this.builder.setPipelineConfiguration(config);
        super.setPipelineConfiguration(config);
    }

    @Override
    public void setStreamResult(StreamResult result) throws XPathException {
        super.setStreamResult(result);
        this.makeWriter();
    }

    @Override
    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        this.builder.attribute(nameCode, typeCode, value, locationId, properties);
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.builder.characters(chars, locationId, properties);
    }

    @Override
    public void close() throws XPathException {
        TinyDocumentImpl doc = (TinyDocumentImpl)this.builder.getCurrentRoot();
        if (doc != null) {
            PTreeWriter out = new PTreeWriter((ProfessionalConfiguration)this.getPipelineConfiguration().getConfiguration());
            try {
                out.writeTree(doc.getTree(), new DataOutputStream(this.getOutputStream()));
            }
            catch (IOException e) {
                throw new XPathException(e);
            }
        }
        this.builder = null;
        super.close();
    }

    @Override
    public void comment(CharSequence content, Location locationId, int properties) throws XPathException {
        this.builder.comment(content, locationId, properties);
    }

    @Override
    public void endDocument() throws XPathException {
        this.builder.endDocument();
    }

    @Override
    public void endElement() throws XPathException {
        this.builder.endElement();
    }

    @Override
    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        this.builder.namespace(namespaceBindings, properties);
    }

    @Override
    public void open() throws XPathException {
        this.builder.open();
    }

    @Override
    public void processingInstruction(String name, CharSequence data, Location locationId, int properties) throws XPathException {
        this.builder.processingInstruction(name, data, locationId, properties);
    }

    @Override
    public void startContent() throws XPathException {
        this.builder.startContent();
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        this.open();
        this.builder.startDocument(properties);
    }

    @Override
    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        this.builder.startElement(nameCode, typeCode, location, properties);
    }

    @Override
    public boolean usesTypeAnnotations() {
        return true;
    }
}

