/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.liblinear;

import de.bwaldvogel.liblinear.FeatureNode;
import de.bwaldvogel.liblinear.Function;
import de.bwaldvogel.liblinear.Problem;

class L2R_L2_SvcFunction
implements Function {
    private final Problem prob;
    private final double[] C;
    private final int[] I;
    private final double[] z;
    private int sizeI;

    public L2R_L2_SvcFunction(Problem prob, double Cp, double Cn) {
        int l = prob.l;
        int[] y = prob.y;
        this.prob = prob;
        this.z = new double[l];
        this.C = new double[l];
        this.I = new int[l];
        for (int i = 0; i < l; ++i) {
            this.C[i] = y[i] == 1 ? Cp : Cn;
        }
    }

    @Override
    public double fun(double[] w) {
        int i;
        double f = 0.0;
        int[] y = this.prob.y;
        int l = this.prob.l;
        int w_size = this.get_nr_variable();
        this.Xv(w, this.z);
        for (i = 0; i < l; ++i) {
            this.z[i] = (double)y[i] * this.z[i];
            double d = 1.0 - this.z[i];
            if (!(d > 0.0)) continue;
            f += this.C[i] * d * d;
        }
        f = 2.0 * f;
        for (i = 0; i < w_size; ++i) {
            f += w[i] * w[i];
        }
        return f /= 2.0;
    }

    @Override
    public int get_nr_variable() {
        return this.prob.n;
    }

    @Override
    public void grad(double[] w, double[] g2) {
        int i;
        int[] y = this.prob.y;
        int l = this.prob.l;
        int w_size = this.get_nr_variable();
        this.sizeI = 0;
        for (i = 0; i < l; ++i) {
            if (!(this.z[i] < 1.0)) continue;
            this.z[this.sizeI] = this.C[i] * (double)y[i] * (this.z[i] - 1.0);
            this.I[this.sizeI] = i;
            ++this.sizeI;
        }
        this.subXTv(this.z, g2);
        for (i = 0; i < w_size; ++i) {
            g2[i] = w[i] + 2.0 * g2[i];
        }
    }

    @Override
    public void Hv(double[] s2, double[] Hs) {
        int i;
        int l = this.prob.l;
        int w_size = this.get_nr_variable();
        double[] wa = new double[l];
        this.subXv(s2, wa);
        for (i = 0; i < this.sizeI; ++i) {
            wa[i] = this.C[this.I[i]] * wa[i];
        }
        this.subXTv(wa, Hs);
        for (i = 0; i < w_size; ++i) {
            Hs[i] = s2[i] + 2.0 * Hs[i];
        }
    }

    private void subXTv(double[] v, double[] XTv) {
        int i;
        int w_size = this.get_nr_variable();
        for (i = 0; i < w_size; ++i) {
            XTv[i] = 0.0;
        }
        for (i = 0; i < this.sizeI; ++i) {
            for (FeatureNode s2 : this.prob.x[this.I[i]]) {
                int n = s2.index - 1;
                XTv[n] = XTv[n] + v[i] * s2.value;
            }
        }
    }

    private void subXv(double[] v, double[] Xv) {
        for (int i = 0; i < this.sizeI; ++i) {
            Xv[i] = 0.0;
            for (FeatureNode s2 : this.prob.x[this.I[i]]) {
                int n = i;
                Xv[n] = Xv[n] + v[s2.index - 1] * s2.value;
            }
        }
    }

    private void Xv(double[] v, double[] Xv) {
        for (int i = 0; i < this.prob.l; ++i) {
            Xv[i] = 0.0;
            for (FeatureNode s2 : this.prob.x[i]) {
                int n = i;
                Xv[n] = Xv[n] + v[s2.index - 1] * s2.value;
            }
        }
    }
}

