/*
 * Decompiled with CFR 0.152.
 */
package libsvm;

class Cache {
    private final int l;
    private long size;
    private final head_t[] head;
    private head_t lru_head;

    Cache(int l_, long size_) {
        this.l = l_;
        this.size = size_;
        this.head = new head_t[this.l];
        for (int i = 0; i < this.l; ++i) {
            this.head[i] = new head_t();
        }
        this.size /= 4L;
        this.size -= (long)(this.l * 4);
        this.size = Math.max(this.size, 2L * (long)this.l);
        this.lru_head.next = this.lru_head.prev = (this.lru_head = new head_t());
    }

    private void lru_delete(head_t h2) {
        h2.prev.next = h2.next;
        h2.next.prev = h2.prev;
    }

    private void lru_insert(head_t h2) {
        h2.next = this.lru_head;
        h2.prev = this.lru_head.prev;
        h2.prev.next = h2;
        h2.next.prev = h2;
    }

    int get_data(int index, float[][] data, int len) {
        int more;
        head_t h2 = this.head[index];
        if (h2.len > 0) {
            this.lru_delete(h2);
        }
        if ((more = len - h2.len) > 0) {
            while (this.size < (long)more) {
                head_t old = this.lru_head.next;
                this.lru_delete(old);
                this.size += (long)old.len;
                old.data = null;
                old.len = 0;
            }
            float[] new_data = new float[len];
            if (h2.data != null) {
                System.arraycopy(h2.data, 0, new_data, 0, h2.len);
            }
            h2.data = new_data;
            this.size -= (long)more;
            int _ = h2.len;
            h2.len = len;
            len = _;
        }
        this.lru_insert(h2);
        data[0] = h2.data;
        return len;
    }

    void swap_index(int i, int j) {
        if (i == j) {
            return;
        }
        if (this.head[i].len > 0) {
            this.lru_delete(this.head[i]);
        }
        if (this.head[j].len > 0) {
            this.lru_delete(this.head[j]);
        }
        float[] _ = this.head[i].data;
        this.head[i].data = this.head[j].data;
        this.head[j].data = _;
        int _2 = this.head[i].len;
        this.head[i].len = this.head[j].len;
        this.head[j].len = _2;
        if (this.head[i].len > 0) {
            this.lru_insert(this.head[i]);
        }
        if (this.head[j].len > 0) {
            this.lru_insert(this.head[j]);
        }
        if (i > j) {
            _2 = i;
            i = j;
            j = _2;
        }
        head_t h2 = this.lru_head.next;
        while (h2 != this.lru_head) {
            if (h2.len > i) {
                if (h2.len > j) {
                    float _3 = h2.data[i];
                    h2.data[i] = h2.data[j];
                    h2.data[j] = _3;
                } else {
                    this.lru_delete(h2);
                    this.size += (long)h2.len;
                    h2.data = null;
                    h2.len = 0;
                }
            }
            h2 = h2.next;
        }
    }

    private final class head_t {
        head_t prev;
        head_t next;
        float[] data;
        int len;

        private head_t() {
        }
    }
}

