/*
 * Decompiled with CFR 0.152.
 */
package marmot.util.edit;

import marmot.util.Counter;
import marmot.util.edit.EditTree;
import marmot.util.edit.EditTreeBuilder;

public class ReplaceNode
implements EditTree {
    private static final long serialVersionUID = 1L;
    private String input_;
    private String output_;

    public ReplaceNode(String input, String output) {
        this.input_ = input;
        this.output_ = output;
    }

    public String toString() {
        return String.format("r(%s, %s)", this.input_, this.output_);
    }

    @Override
    public double getCost(EditTreeBuilder builder) {
        double count2 = builder.getCounter().count(this.toString()) + 1.0;
        double cost = (double)(this.input_.length() + this.output_.length()) / count2;
        return cost;
    }

    @Override
    public void increment(Counter<String> counter) {
        counter.increment(this.toString(), 1.0);
    }

    @Override
    public String apply(String input, int start, int end) {
        assert (start >= 0);
        assert (end <= input.length());
        int length = end - start;
        if (length != this.input_.length()) {
            return null;
        }
        if (!input.substring(start, end).equals(this.input_)) {
            return null;
        }
        return this.output_;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.input_ == null ? 0 : this.input_.hashCode());
        result2 = 31 * result2 + (this.output_ == null ? 0 : this.output_.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReplaceNode other = (ReplaceNode)obj;
        if (this.input_ == null ? other.input_ != null : !this.input_.equals(other.input_)) {
            return false;
        }
        return !(this.output_ == null ? other.output_ != null : !this.output_.equals(other.output_));
    }

    @Override
    public int getFixedInputLength() {
        return this.input_.length();
    }

    @Override
    public int getFixedOutputLength() {
        return this.output_.length();
    }
}

