/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.extfn;

import java.util.ArrayList;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.CopyInformee;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.Sink;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.DummyNamespaceResolver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Invalidity;
import net.sf.saxon.lib.InvalidityHandler;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.ma.map.DictionaryMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.AbsolutePath;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.type.ValidationParams;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;

public class ValidateFn
extends SystemFunction {
    public ZeroOrOne<MapItem> call(XPathContext context, Sequence[] arguments) throws XPathException {
        final ArrayList<ValidationFailure> errorList = new ArrayList<ValidationFailure>(5);
        boolean returnTreeOnFailure = false;
        NodeInfo resultNode = null;
        Configuration config = context.getConfiguration();
        NodeInfo input = (NodeInfo)arguments[0].head();
        if (input == null) {
            return ZeroOrOne.empty();
        }
        SchemaType schemaType = null;
        int validation = 1;
        boolean expand = true;
        boolean buildTree = true;
        if (arguments.length >= 2) {
            MapItem options = (MapItem)arguments[1].head();
            GroundedValue<?> val = options.get(new StringValue("buildTree"));
            if (val != null && val.head() != null) {
                if (val instanceof BooleanValue) {
                    returnTreeOnFailure = buildTree = ((BooleanValue)val).getBooleanValue();
                } else {
                    throw new XPathException("buildTree must be true() or false() or ()");
                }
            }
            if ((val = options.get(new StringValue("type"))) != null) {
                if (val instanceof QNameValue) {
                    schemaType = config.getSchemaType(((QNameValue)val).getStructuredQName());
                    if (schemaType == null) {
                        throw new XPathException("Unknown type " + val, "XPTY0004");
                    }
                } else {
                    throw new XPathException("'type' option in second argument of saxon:validate() must be a QName", "XPTY0004");
                }
            }
            if ((val = options.get(new StringValue("processContents"))) != null) {
                if (val instanceof StringValue) {
                    Object s;
                    switch (s = ((StringValue)val).getStringValue()) {
                        case "strict": {
                            break;
                        }
                        case "lax": {
                            validation = 2;
                            break;
                        }
                        default: {
                            throw new XPathException("processContents must be 'strict' or 'lax'");
                        }
                    }
                } else {
                    throw new XPathException("'processContents' option in second argument of saxon:validate() must be a string", "XPTY0004");
                }
            }
            if ((val = options.get(new StringValue("expandDefaults"))) != null) {
                if (val instanceof BooleanValue) {
                    expand = ((BooleanValue)val).getBooleanValue();
                } else {
                    throw new XPathException("processContents must be true() or false()");
                }
            }
        }
        ValidationParams params = new ValidationParams();
        if (arguments.length >= 3) {
            MapItem rawParams = (MapItem)arguments[2].head();
            for (KeyValuePair pair : rawParams.keyValuePairs()) {
                QNameValue qKey;
                AtomicValue key = pair.key;
                if (key instanceof QNameValue) {
                    qKey = (QNameValue)key;
                } else if (key instanceof StringValue) {
                    qKey = new QNameValue("", "", key.getStringValue());
                } else {
                    throw new XPathException("key value in third argument to saxon:validate must be a string or QName");
                }
                params.put(qKey.getStructuredQName(), pair.value);
            }
        } else {
            params = new ValidationParams();
        }
        ParseOptions options = new ParseOptions();
        options.setValidationParams(params);
        options.setSchemaValidationMode(validation);
        options.setTopLevelType(schemaType);
        options.setExpandAttributeDefaults(expand);
        options.setContinueAfterValidationErrors(true);
        final ArrayList currentErrorNode = new ArrayList(1);
        PipelineConfiguration pipe = context.getController().makePipelineConfiguration();
        pipe.setParseOptions(options);
        pipe.setXPathContext(context);
        pipe.setComponent(CopyInformee.class.getName(), element -> {
            currentErrorNode.clear();
            currentErrorNode.add(element);
            return null;
        });
        options.setInvalidityHandler(new InvalidityHandler(){

            @Override
            public void startReporting(String systemId) {
            }

            @Override
            public void reportInvalidity(Invalidity failure) {
                if (!currentErrorNode.isEmpty()) {
                    ((ValidationFailure)failure).setSourceLocator((SourceLocator)currentErrorNode.get(0));
                    ((ValidationFailure)failure).setPath(AbsolutePath.pathToNode((NodeInfo)currentErrorNode.get(0)));
                    ((ValidationFailure)failure).setInvalidNode((NodeInfo)currentErrorNode.get(0));
                }
                errorList.add(failure);
            }

            @Override
            public Sequence<?> endReporting() {
                return null;
            }
        });
        int kind = input.getNodeKind();
        switch (kind) {
            case 9: {
                SequenceReceiver out = buildTree ? new SequenceOutputter(pipe) : new Sink(pipe);
                Receiver val = config.getDocumentValidator(out, input.getBaseURI(), options, null);
                val.setPipelineConfiguration(out.getPipelineConfiguration());
                val.setSystemId(input.getBaseURI());
                input.copy(val, 2, ExplicitLocation.UNKNOWN_LOCATION);
                resultNode = buildTree ? (NodeInfo)((SequenceOutputter)out).getFirstItem() : null;
                break;
            }
            case 1: {
                SequenceReceiver out = buildTree ? new SequenceOutputter(pipe) : new Sink(pipe);
                options.setTopLevelElement(NameOfNode.makeName(input).getStructuredQName());
                Receiver val = config.getElementValidator(out, options, ExplicitLocation.UNKNOWN_LOCATION);
                val.setPipelineConfiguration(out.getPipelineConfiguration());
                val.setSystemId(input.getBaseURI());
                input.copy(val, 2, ExplicitLocation.UNKNOWN_LOCATION);
                resultNode = buildTree ? (NodeInfo)((SequenceOutputter)out).getFirstItem() : null;
                break;
            }
            case 2: {
                SimpleType simpleType = BuiltInAtomicType.UNTYPED_ATOMIC;
                if (schemaType instanceof SimpleType) {
                    simpleType = (SimpleType)schemaType;
                    ValidationFailure err = simpleType.validateContent(input.getStringValue(), DummyNamespaceResolver.getInstance(), context.getConfiguration().getConversionRules());
                    if (err != null) {
                        ValidationFailure ve = new ValidationFailure("Attribute value " + Err.wrap(input.getStringValue(), 4) + " does not match the required type " + schemaType.getDescription() + ". " + err.getMessage());
                        ve.setErrorCode("XTTE1540");
                        ve.setSchemaType(schemaType);
                        ve.setPath(AbsolutePath.pathToNode(input));
                        errorList.add(ve);
                    }
                } else if (validation == 1 || validation == 2) {
                    try {
                        simpleType = config.validateAttribute(NameOfNode.makeName(input).getStructuredQName(), input.getStringValue(), validation);
                    }
                    catch (ValidationException e) {
                        ValidationFailure vf = e.getValidationFailure();
                        vf.setInvalidNode(input);
                        errorList.add(vf);
                    }
                } else {
                    resultNode = input;
                    break;
                }
                if (buildTree) {
                    Orphan result = new Orphan(config);
                    result.setNodeKind((short)2);
                    result.setNodeName(NameOfNode.makeName(input));
                    result.setStringValue(input.getStringValue());
                    result.setTypeAnnotation(simpleType);
                    resultNode = result;
                    break;
                }
                resultNode = null;
                break;
            }
            default: {
                throw new XPathException("Input to saxon:validate must be a document, element, or attribute node", "XPTY0004");
            }
        }
        DictionaryMap result = new DictionaryMap();
        if (errorList.isEmpty()) {
            if (buildTree) {
                result.initialPut("node", resultNode);
            }
            result.initialPut("valid", BooleanValue.TRUE);
            return new ZeroOrOne<MapItem>(result);
        }
        result.initialPut("valid", BooleanValue.FALSE);
        if (returnTreeOnFailure) {
            result.initialPut("node", resultNode);
        }
        ArrayList<DictionaryMap> errors = new ArrayList<DictionaryMap>(errorList.size());
        for (Invalidity invalidity : errorList) {
            ValidationFailure v = (ValidationFailure)invalidity;
            DictionaryMap im = new DictionaryMap();
            if (v.getErrorCodeQName() != null) {
                im.initialPut("code", new QNameValue(v.getErrorCodeQName(), BuiltInAtomicType.QNAME));
            }
            im.initialPut("message", new StringValue(v.getMessage()));
            if (v.getSchemaPart() != -1) {
                im.initialPut("specPart", new Int64Value(v.getSchemaPart()));
            }
            if (v.getConstraintName() != null) {
                im.initialPut("constraint", new StringValue(v.getConstraintName()));
            }
            if (v.getConstraintClauseNumber() != null) {
                im.initialPut("clause", new StringValue(v.getConstraintClauseNumber()));
            }
            if (v.getLineNumber() != -1) {
                im.initialPut("line", new Int64Value(v.getLineNumber()));
            }
            if (v.getColumnNumber() != -1) {
                im.initialPut("colummn", new Int64Value(v.getColumnNumber()));
            }
            if (v.getSystemId() != null) {
                im.initialPut("systemId", new StringValue(v.getSystemId()));
            }
            if (v.getPublicId() != null) {
                im.initialPut("publicId", new StringValue(v.getPublicId()));
            }
            if (v.getInvalidNode() != null) {
                im.initialPut("node", v.getInvalidNode());
            }
            if (v.getPath() != null) {
                im.initialPut("path", new StringValue(v.getPath().getPathUsingUris()));
            }
            errors.add(im);
        }
        result.initialPut("errors", SequenceExtent.makeSequenceExtent(errors));
        return new ZeroOrOne<MapItem>(result);
    }
}

