/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.trans;

import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.Streamability;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.functions.AccumulatorFn;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;

public class ContextItemStaticInfoEE
extends ContextItemStaticInfo {
    private Posture explicitPosture;
    private boolean strictStreamabilityRules;
    private Actor container;
    private AccumulatorFn.Phase accumulatorPhase;
    public static final ContextItemStaticInfoEE DEFAULT = new ContextItemStaticInfoEE(AnyItemType.getInstance(), true, Posture.STRIDING);
    public static final ContextItemStaticInfoEE ABSENT = new ContextItemStaticInfoEE(ErrorType.getInstance(), true, Posture.STRIDING);

    public ContextItemStaticInfoEE(ItemType itemType, boolean maybeUndefined) {
        super(itemType, maybeUndefined);
    }

    public ContextItemStaticInfoEE(ItemType itemType, boolean maybeUndefined, Posture contextItemPosture) {
        super(itemType, maybeUndefined);
        this.explicitPosture = contextItemPosture;
    }

    @Override
    public void setContextPostureStriding() {
        this.explicitPosture = Posture.STRIDING;
    }

    @Override
    public void setContextPostureGrounded() {
        this.explicitPosture = Posture.GROUNDED;
    }

    public Actor getContainer() {
        return this.container;
    }

    public void setContainer(Actor container) {
        this.container = container;
    }

    public Posture getContextItemPosture() {
        if (this.explicitPosture == null) {
            Expression contextSetter = this.getContextSettingExpression();
            if (contextSetter != null) {
                return Streamability.getPosture(contextSetter);
            }
            Actor actor = this.getContainer();
            if (actor instanceof AttributeSet) {
                return ((AttributeSet)actor).isDeclaredStreamable() ? Posture.STRIDING : Posture.ROAMING;
            }
            return Posture.ROAMING;
        }
        return this.explicitPosture;
    }

    @Override
    public boolean isStrictStreamabilityRules() {
        return this.strictStreamabilityRules;
    }

    public void setStrictStreamabilityRules(boolean strictStreamabilityRules) {
        this.strictStreamabilityRules = strictStreamabilityRules;
    }

    public void setAccumulatorPhase(AccumulatorFn.Phase phase) {
        this.accumulatorPhase = phase;
    }

    public AccumulatorFn.Phase getAccumulatorPhase() {
        return this.accumulatorPhase;
    }
}

